package com.ptteng.course.home.controller;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.course.constant.Constant;
import com.ptteng.learn.common.model.Message;
import com.ptteng.learn.common.model.UserMessageRelation;
import com.ptteng.learn.common.service.MessageService;
import com.ptteng.learn.common.service.UserMessageRelationService;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * Locks  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class LocksController {
    private static final Log lockLog = LogFactory.getLog("lock");

    @Autowired
    private LocksService locksService;
    @Autowired
    private UserService userService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private UserMessageRelationService userMessageRelationService;



    @RequestMapping(value = "/a/u/share", method = RequestMethod.POST)
    public String shareUnlock(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Long targetId )
            throws Exception {

            Period period = new Period();

            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            lockLog.info("share task : targetId= " + targetId +", userId is " + user );
        try {

                 period = periodService.getObjectById(targetId);
                if (null == period) {
                    lockLog.info("period not exist");
                    model.addAttribute("code", -4012);
                    return "/common/success";
                }
                if (Period.UnLock.equals(period.getLocked())) {
                    lockLog.info("period not locked");
                    model.addAttribute("code", -4021);
                    return "/common/success";
                }
                period = periodService.getObjectById(targetId);
                String shareType = period.getLocktype().substring(2,3);
            lockLog.info(shareType);
            lockLog.info(!Integer.valueOf(shareType).equals(1));
                if( !Integer.valueOf(shareType).equals(1)&&Period.Lock.equals(period.getLocked())){
                    lockLog.info("period not share");
                    model.addAttribute("code", -4050);
                    return "/common/success";
                }





//            课程解锁部分

//            lock表相关字段相关设定
            Locks locks = new Locks();
            locks.setTargetID(targetId);
            locks.setUserID(uid);
            locks.setType(Locks.TYPE_PERIOD);
            locksService.insert(locks);


            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            lockLog.error(t.getMessage());
            lockLog.error("delete task error,targetId is  " + targetId);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }




    //学习星 分享 解锁  课程/课时
    @RequestMapping(value = "/a/u/unlock", method = RequestMethod.POST)
    public String unlock(HttpServletRequest request, HttpServletResponse response,
                         ModelMap model, Long targetId, Integer type) throws Exception {
        List<Long> pids = new ArrayList<>();
        List<Locks> lockses = new ArrayList<>();
        Lesson lesson = new Lesson();
        Period period = new Period();
        Long lockedId = 0L;
        Boolean lockStatus = false;
        List<Long> lessonPeriodIds = new ArrayList<>();
        Integer price = 0;
        Long lockRelation = 0L;
        Boolean unlockStatus = true;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        lockLog.info("get uid " + uid);

        try {
            if (!(Locks.TYPE_LESSON.equals(type) || Locks.TYPE_PERIOD.equals(type)   ||  Locks.TYPE_SHARE.equals(type) )) {
                lockLog.info("type illegal");
                model.addAttribute("code", -4000);
                return "/common/success";
            }

            if (type.equals(UserOrder.ORDER_LESSON)) {
                lesson = lessonService.getObjectById(targetId);
                if (null == lesson) {
                    lockLog.info("lesson not exist");
                    model.addAttribute("code", -4019);
                    return "/common/success";
                }

                //课程是否有未购课时
                lessonPeriodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(targetId, Period.status_normal, 0, Integer.MAX_VALUE);
                for (Long periodId : lessonPeriodIds) {
                    period = periodService.getObjectById(periodId);
                    if (Period.Lock.equals(period.getLocked())) {
                        lockedId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, periodId);
                        if (null == lockedId) {
                            lockStatus = true;
                            price = price + period.getStarPrice();
                        }
                    }
                }
                lockLog.info("lock status : " + lockStatus);
                if (!lockStatus) {
                    lockLog.info("lesson not lock period");
                    model.addAttribute("code", -4036);
                    return "/common/success";
                }

            } else {
                period = periodService.getObjectById(targetId);
                if (null == period) {
                    lockLog.info("period not exist");
                    model.addAttribute("code", -4012);
                    return "/common/success";
                }
                if (Period.UnLock.equals(period.getLocked())) {
                    lockLog.info("period not locked");
                    model.addAttribute("code", -4021);
                    return "/common/success";
                }
                price = period.getStarPrice();
                if (DataUtils.isNullOrEmpty(price)) {
                    lockLog.info("period price wrong");
                    model.addAttribute("code", -4023);
                    return "/common/success";
                }
            }

            lockLog.info("==========校验学习星是否足够==========");

            if (user.getScore() < price && !Locks.TYPE_SHARE.equals(type)) {
                lockLog.info("score is not enough");
                model.addAttribute("code", -2016);
                return "/common/success";
            }

            lockLog.info("==========学习星解锁课程课时==========");

            Locks locks = new Locks();
            locks.setTargetID(targetId);
            locks.setUserID(uid);
            locks.setType(type);
            locksService.insert(locks);

            if(Locks.TYPE_PERIOD.equals(type)){
                //是否已将所属课程/教材全部解锁
                period = periodService.getObjectById(targetId);

                if (Period.Lesson.equals(period.getType())) {
                    List<Long> periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(period.getLessonID(), Period.status_normal, 0, Integer.MAX_VALUE);
                    List<Period> periods = periodService.getObjectsByIds(periodIds);
                    for (Period period1 : periods) {
                        if (Period.Lock.equals(period.getLocked())) {
                            Long lockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period1.getId());
                            if (null == lockId) {
                                unlockStatus = false;
                            }
                        }
                    }
                    if (unlockStatus) {
                        Long locksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid,Locks.TYPE_LESSON,period.getLessonID());
                        if(null == locksId){
                            locks.setId(null);
                            locks.setTargetID(period.getLessonID());
                            locks.setUserID(uid);
                            locks.setType(Locks.TYPE_LESSON);
                            locksService.insert(locks);
                        }
                    }
                } else {
                    List<Long> periodIds = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(period.getBookID(), Period.status_normal, 0, Integer.MAX_VALUE);
                    List<Period> periods = periodService.getObjectsByIds(periodIds);
                    for (Period period1 : periods) {
                        if (Period.Lock.equals(period.getLocked())) {
                            Long lockId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period1.getId());
                            if (null == lockId) {
                                unlockStatus = false;
                            }
                        }
                    }
                    if (unlockStatus) {
                        Long locksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid,Locks.TYPE_BOOK,period.getBookID());
                        if(null == locksId){
                            locks.setId(null);
                            locks.setTargetID(period.getBookID());
                            locks.setUserID(uid);
                            locks.setType(Locks.TYPE_BOOK);
                            locksService.insert(locks);
                        }
                    }
                }
            }

            if (Locks.TYPE_LESSON.equals(type)) {
                //解锁锁定课程
                pids = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(targetId, Period.status_normal, null, null);
                List<Period> periods = periodService.getObjectsByIds(pids);
                lockLog.info("pids size : " + pids.size());
                for (Period period1 : periods) {
                    if(Period.Lock.equals(period1.getLocked())){
                        lockRelation = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                        if (null == lockRelation) {
                            locks.setId(null);
                            locks.setType(Locks.TYPE_PERIOD);
                            locks.setTargetID(period1.getId());
                            locksService.insert(locks);
                            lockLog.info("user lock period id is"+period1.getId());
                        }
                    }
                }
            }

            lockLog.info("==========减少学习星==========");
            if(!Locks.TYPE_SHARE.equals(type)){
                user.setScore(user.getScore() - price);
            }
            userService.update(user);

            //这是一个垃圾的单发短信。。。。
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format(new Date(System.currentTimeMillis()));
            String title = "学习星变动通知";
            String content = "";
            if (type.equals(UserOrder.ORDER_LESSON)) {
                content = "您于"+date+"使用学习星解锁“"+lesson.getName()+"”课程，消费"+price+"颗学习星。";
            }else {
                content = "您于"+date+"使用学习星解锁“"+period.getName()+"”课课时，消费"+price+"颗学习星。";
            }

            Message message = new Message();
            message.setType(Message.Type_pesson);
            message.setName(title);
            message.setContent(content);
            message.setUserId(uid);
            message.setPublishAt(System.currentTimeMillis());
            message.setSort(1);
            Long mid = messageService.insert(message);
            lockLog.info("send message success");

            UserMessageRelation userMessageRelation = new UserMessageRelation();
            userMessageRelation.setUserRead(UserMessageRelation.notRead);
            userMessageRelation.setTargetId(mid);
            userMessageRelation.setUserId(uid);
            userMessageRelationService.insert(userMessageRelation);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            lockLog.error(t.getMessage());
            lockLog.error("unlock error, id is  " + targetId);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //计算课程积分/现金价格
    @RequestMapping(value = "/a/u/price/{lid}", method = RequestMethod.POST)
    public String unlockPrice(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long lid, Integer type) throws Exception {
        List<Long> pids = new ArrayList<>();
        Period period = new Period();
        Long lockedId = 0L;
        Boolean lockStatus = false;
        List<Long> lessonPeriodIds = new ArrayList<>();
        BigDecimal price = new BigDecimal(0);
        Integer score = 0;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        lockLog.info("get uid " + uid);

        try {
            if (!(Constant.TYPE_SCORE.equals(type) || Constant.TYPE_CASH.equals(type) ||  Constant.TYPE_SHARE.equals(type))) {
                lockLog.info("type illegal");
                model.addAttribute("code", -4000);
                return "/common/success";
            }

            Lesson lesson = lessonService.getObjectById(lid);
            if (null == lesson) {
                lockLog.info("lesson not exist");
                model.addAttribute("code", -4019);
                return "/common/success";
            }


            //课程是否有未购课时
            lessonPeriodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lid, Period.status_normal, 0, Integer.MAX_VALUE);
            for (Long periodId : lessonPeriodIds) {
                period = periodService.getObjectById(periodId);
                if (Period.Lock.equals(period.getLocked())) {
                    lockedId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, periodId);
                    if (null == lockedId) {
                        lockStatus = true;
                        price.add(period.getMoneyPrice());
                        score = score + period.getStarPrice();
                    }
                }
            }
            lockLog.info("lock status : " + lockStatus);
            if (!lockStatus) {
                lockLog.info("lesson not lock period");
                model.addAttribute("code", -4036);
                return "/common/success";
            }

            model.addAttribute("code", 0);

            if(Constant.TYPE_SCORE.equals(type)){
                model.addAttribute("price", score);
            }else {
                model.addAttribute("price", price);
            }

        } catch (Throwable t) {
            lockLog.error(t.getMessage());
            lockLog.error("get unlock price error, id is  " + lid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/locks/json/unlockPrice";
    }


}

