package com.ptteng.course.home.controller;

import cn.jpush.api.common.Week;
import com.baidu.yun.core.annotation.R;
import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.GameScoreRank;
import com.ptteng.learn.course.model.GameScoreRecords;
import com.ptteng.learn.course.model.User;
import com.ptteng.learn.course.service.GameScoreRankService;
import com.ptteng.learn.course.service.GameScoreRecordsService;
import com.ptteng.learn.course.service.UserService;
import com.ptteng.learn.course.vo.TimeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;


/**
 * GameScoreRecords  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class GameScoreRecordsController {
	private static final Log log = LogFactory.getLog(GameScoreRecordsController.class);

	@Autowired
	private GameScoreRecordsService gameScoreRecordsService;
	@Autowired
	private GameScoreRankService gameScoreRankService;
	@Autowired
	private UserService userService;



    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
//
//	@RequestMapping(value = "/c/gameScoreRecords", method = RequestMethod.GET)
//	public String getgameScoreRecordsList(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model) throws Exception {
//
//
//
//		log.info("/gameScoreRecords  to /gameScoreRecords/view/gameScoreRecordsList");
//
//		return "/learn-course-service/gameScoreRecords/view/gameScoreRecordsList";
//	}
//
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
//
//
//		 @RequestMapping(value = "/c/gameScoreRecords1 ", method = RequestMethod.GET)
//	public String getGameScoreRecordsIdsByUserIdOrderByCreateAtList1(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model,Long userId) throws Exception {
//
//		log.info("/gameScoreRecords  to /gameScoreRecords/view/gameScoreRecordsList");
//
//		return "/learn-course-service/gameScoreRecords/view/gameScoreRecordsList";
//	}

	
	
//
//
//
//
//	@RequestMapping(value = "/c/gameScoreRecords/{id}", method = RequestMethod.GET)
//	public String getGameScoreRecords(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, @PathVariable Long id)
//			throws Exception {
//
//		log.info("/gameScoreRecords/" + id + "  to /gameScoreRecords/view/gameScoreRecordsDeail");
//		if(null != id){
//			model.addAttribute("id", id);
//		}else{
//			model.addAttribute("id", 0);
//		}
//
//		return "/learn-course-service/gameScoreRecords/view/gameScoreRecordsDetail";
//	}
//
//
//
//
//
    /**
	 * 获取用户积分记录列表
	 * @param size 每页条数；
	 * @param page 页数；
	 * @param userId 用户id；
	 * @return json
	 * @throws Exception；
	 *
	 */
	
		@RequestMapping(value = "/a/u/game/score/list", method = RequestMethod.GET)
	public String getGameScoreRecordsIdsByUserIdOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long userId) throws Exception {

			log.info("=========/a/gameScore/list=========");
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			User user = (User) request.getAttribute("user");
			log.info("get user game score , user id is " + user.getId());
			userId = user.getId();

			List<Long> ids= gameScoreRecordsService.getGameScoreRecordsIdsByUserIdOrderByCreateAt(userId,start,size);
			log.info("get countGameScoreRecordsIdsByUserIdOrderByCreateAt size is " + ids.size());

			List<GameScoreRecords> gameScoreRecordsList = gameScoreRecordsService.getObjectsByIds(ids);
			log.info("get gameScoreRecords data is " + gameScoreRecordsList.size());

			Integer total = gameScoreRecordsService. countGameScoreRecordsIdsByUserIdOrderByCreateAt(userId);
			log.info("get gameScoreRecords count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("gameScoreRecordsList", gameScoreRecordsList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get gameScoreRecords list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/gameScoreRecords/json/gameScoreRecordsListJson";
	}





//
//
//	@RequestMapping(value = "/a/gameScoreRecords/{id}", method = RequestMethod.GET)
//	public String getGameScoreRecordsJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, @PathVariable Long id)
//			throws Exception {
//
//		log.info("get data : id= " + id);
//		try {
//			GameScoreRecords gameScoreRecords = gameScoreRecordsService.getObjectById(id);
//			log.info("get gameScoreRecords data is " + gameScoreRecords);
//
//			model.addAttribute("code", 0);
//
//			model.addAttribute("gameScoreRecords", gameScoreRecords);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("get gameScoreRecords error,id is  " + id);
//			model.addAttribute("code", -100000);
//		}
//
//		return "/learn-course-service/gameScoreRecords/json/gameScoreRecordsDetailJson";
//	}
//
//	@RequestMapping(value = "/a/gameScoreRecords/{id}", method = RequestMethod.PUT)
//	public String updateGameScoreRecordsJson(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, GameScoreRecords gameScoreRecords) throws Exception {
//
//		log.info("update gameScoreRecords : gameScoreRecords= " + gameScoreRecords);
//
//		try {
//
//			gameScoreRecordsService.update(gameScoreRecords);
//
//			model.addAttribute("code", 0);
//
//			model.addAttribute("gameScoreRecords", gameScoreRecords);
//
//		} catch (Throwable t) {
//		    t.printStackTrace();
//			log.error(t.getMessage());
//			log.error("update gameScoreRecords error,id is  " + gameScoreRecords.getId());
//			model.addAttribute("code", -6003);
//
//		}
//
//		return "/data/json";
//	}


	/**
	 *新增游戏积分记录
	 * @param gameScoreRecords;
	 * @return json;
	 * @throws Exception;
	 *
	 */

	@RequestMapping(value = "/a/game/score", method = RequestMethod.POST)
	public String addGameScoreRecordsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, GameScoreRecords gameScoreRecords) throws Exception {
		log.info("========/a/u/gameScore==========");
		log.info("insert gameScoreRecords : gameScoreRecords= " + gameScoreRecords);
		//积分不能为空
		if (gameScoreRecords.getScore() == null ) {
			model.addAttribute("code", -7002);
			return "/common/success";
		}
		//游戏类型不能为空
		if (gameScoreRecords.getType() == null ) {
			model.addAttribute("code", -7003);
			return "/common/success";
		}
		//游戏模式不能为空
		if (gameScoreRecords.getMode() == null ) {
			model.addAttribute("code", -7006);
			return "/common/success";
		}
//
		//获取用户信息
//		User user = (User) request.getAttribute("user");
		Long userId = gameScoreRecords.getUserId();
		if (userId == null) {
			model.addAttribute("code", -7001);
			return "/common/success";
		}else {
			User user = userService.getObjectById(userId);
			if (user == null) {
				model.addAttribute("code", -7009);
				return "/common/success";
			}
		}
//		else if (!userId.equals(user.getId())){
//			model.addAttribute("code", -7007);
//			return "/common/success";
//		}


		try { 
			gameScoreRecords.setId(null);
			log.info("insert gameScoreRecords , uid is " + userId);
//			gameScoreRecords.setUserId(userId);
			gameScoreRecords.setCreateBy(userId);
			gameScoreRecords.setUpdateBy(userId);
			//是否为最佳积分
			boolean bestResult = bestScore(gameScoreRecords.getUserId(),gameScoreRecords.getType(),gameScoreRecords.getMode(),gameScoreRecords.getScore());
			if (bestResult){
				gameScoreRecords.setBest(GameScoreRecords.Is_Bast_Score);
			}
			//是否为该游戏最佳积分（不限制模式）
			Map<String,Object> param = DynamicUtil.getUserGameScoreIdsOrderByScore(userId,gameScoreRecords.getType(),null,null,true);
			List<Long> ids = gameScoreRecordsService.getIdsByDynamicCondition(GameScoreRecords.class,param,0,Integer.MAX_VALUE);
			if (ids.size()>0) {
				GameScoreRecords gameScoreRecordsTypeBest = gameScoreRecordsService.getObjectById(ids.get(0));
				//最高积分设置标识
				if(gameScoreRecords.getScore()>gameScoreRecordsTypeBest.getScore()){
					gameScoreRecords.setTypeBest(GameScoreRecords.Is_TypeBast_Score);

					//清除旧值
					gameScoreRecordsTypeBest.setTypeBest(null);
					gameScoreRecordsService.update(gameScoreRecordsTypeBest);
				}
			}else {
				gameScoreRecords.setTypeBest(GameScoreRecords.Is_TypeBast_Score);
			}



			Long id =gameScoreRecordsService.insert(gameScoreRecords);


			//统计周积分
			if (id != null) {
				setScoreRank(userId,gameScoreRecords.getScore(),gameScoreRecords.getType(),gameScoreRecords.getMode());
			}
			model.addAttribute("code", 0);
			model.addAttribute("bestResult", bestResult);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add gameScoreRecords error ");
			model.addAttribute("code", -1);
		}

		return "/learn-course-service/gameScoreRecords/json/addGameScoreRecordsResult";
	}



	//设置rank
	private void setScoreRank(Long uid,Long score,Integer type,Integer mode) throws Exception{

		log.info("setWeekScoreRank , uid is " + uid + " score is " + score+" type is " + type+" mode is " + mode);

//
		Long weekStatistics = TimeUtil.getTimesWeekmorningInMillis();
		//设置周统计信息
		setUserGame(uid,score,type,mode,weekStatistics);
		//非周统计信息
		setUserGame(uid,score,type,mode,GameScoreRank.UserRank_NotWeek);

		//更新用户数据
		updateUserMsg(uid,score);
	}
	/*========统计=======*/
	private void setUserGame(Long uid,Long score,Integer type,Integer mode,Long statisticsAt) throws Exception{
		//获取用户该游戏类型数据
		Map<String,Object> param =  DynamicUtil.getGameScoreRank(uid,statisticsAt,type,null,null);
		List<Long> ids = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param,0,Integer.MAX_VALUE);

		//更新积分
		if (ids.size()>0) {
			List<GameScoreRank> gameScoreRanks = gameScoreRankService.getObjectsByIds(ids);
			for (GameScoreRank gameScoreRank:gameScoreRanks){
				if (gameScoreRank.getMode()!=null && gameScoreRank.getMode().equals(mode) || gameScoreRank.getMode()==null) {
					gameScoreRank.setGameScore(gameScoreRank.getGameScore()+score);
				}

			}
			//更新用户总积分内容

			Map<String,Object> param1 =  DynamicUtil.getGameScoreRank(uid,statisticsAt,GameScoreRank.UserRank_Type_Null,null,null);
			List<Long> ids1 = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param1,0,Integer.MAX_VALUE);
			if (ids1.size() == 0) {
				log.info("user gameScoreRankService are empty, userId is " + uid);
			}
			GameScoreRank gameScoreRank1 = gameScoreRankService.getObjectsByIds(ids1).get(0);
			gameScoreRank1.setGameScore(gameScoreRank1.getGameScore()+score);
			gameScoreRanks.add(gameScoreRank1);

			boolean update= gameScoreRankService.updateList(gameScoreRanks);

			if (update) {
				log.info("update user game score success");
			}else {
				log.info("update user game score error");
			}


			//该游戏类型的内容-该模式
			param =  DynamicUtil.getGameScoreRank(uid,statisticsAt,type,mode,null);
			ids = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param,0,Integer.MAX_VALUE);
			if (ids.size() == 0 ) {
				GameScoreRank gameScoreRank = setGameScoreRank(uid,score,type,mode,statisticsAt);
				Long id = gameScoreRankService.insert(gameScoreRank);
				log.info("insert gameScoreRank success id is " + id);
			}



		} else {
			List<GameScoreRank> gameScoreRanks = new ArrayList<>();
			//分类分模式
			gameScoreRanks.add(setGameScoreRank(uid,score,type,mode,statisticsAt));
			//分类不分模式
			gameScoreRanks.add(setGameScoreRank(uid,score,type,GameScoreRank.UserRank_Mode_Null,statisticsAt));
			//不分类不分模式-只有周统计添加，用户统计在用户注册时候添加
			if (!statisticsAt.equals(GameScoreRank.UserRank_NotWeek)) {
				Map<String,Object> param2 =  DynamicUtil.getGameScoreRank(uid,statisticsAt,null,null,null);
				List<Long> ids2 = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param2,0,Integer.MAX_VALUE);
				if (ids2.size()==0){
					gameScoreRanks.add(setGameScoreRank(uid,score,GameScoreRank.UserRank_Type_Null,GameScoreRank.UserRank_Mode_Null,statisticsAt));
				}
			}


			List<GameScoreRank> gameScoreRankList = gameScoreRankService.insertList(gameScoreRanks);

			if (gameScoreRankList == null) {
				log.info("insert user game score error");
			}else {
				log.info("insert user game score success  " );
			}
			List<Long> idList = new ArrayList<>();

			for (GameScoreRank item:gameScoreRankList){
				idList.add(item.getId());
			}
			//更新用户总积分内容

			Map<String,Object> param1 =  DynamicUtil.getGameScoreRank(uid,statisticsAt,GameScoreRank.UserRank_Type_Null,null,null);
			List<Long> ids1 = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,param1,0,Integer.MAX_VALUE);
			if(!idList.contains(ids1.get(0))){
				GameScoreRank gameScoreRank1 = gameScoreRankService.getObjectsByIds(ids1).get(0);
				gameScoreRank1.setGameScore(gameScoreRank1.getGameScore()+score);
				gameScoreRankService.update(gameScoreRank1);
			}

		}

		/*设置排行信息*/

		//获取所有数据
		Map<String,Object> allParam =  DynamicUtil.getGameScoreRankByScoreNotZore(null,statisticsAt,null,null,null);
		List<Long> rankIds = gameScoreRankService.getIdsByDynamicCondition(GameScoreRank.class,allParam,0,Integer.MAX_VALUE);

		//处理积分排行
		log.info("rankIds size is " + rankIds.size());
		if (rankIds.size()>0) {
			log.info("===update  game rank start===");
			List<GameScoreRank> gameScoreRanks = gameScoreRankService.getObjectsByIds(rankIds);
			//设置排行
			Long lastScore = 0L;
			Long lastScoreTypeNull = 0L;
			Long lastScoreModeNull = 0L;
			Long i = 0L;
			Long iTypeNull = 0L;
			Long iModeNull = 0L;
			for (GameScoreRank gameScoreRankItem:gameScoreRanks) {
				//总排序
				if(gameScoreRankItem.getType() == null){//无限制
					if ( gameScoreRankItem.getGameScore().equals(lastScoreTypeNull)) {
						gameScoreRankItem.setRank(iTypeNull);
					}else {
						iTypeNull++;
						gameScoreRankItem.setRank(iTypeNull);
					}
				}else if (gameScoreRankItem.getType().equals(type) && gameScoreRankItem.getMode()==null){//不限制模式排序
					if ( gameScoreRankItem.getGameScore().equals(lastScoreModeNull)) {
						gameScoreRankItem.setRank(iModeNull);
					}else {
						iModeNull++;
						gameScoreRankItem.setRank(iModeNull);
					}
				}else if (gameScoreRankItem.getType().equals(type) && gameScoreRankItem.getMode().equals(mode)){//限制类型、模式
					if ( gameScoreRankItem.getGameScore().equals(lastScore)) {
						gameScoreRankItem.setRank(i);
					}else {
						i++;
						gameScoreRankItem.setRank(i);
					}
				}

			}
			boolean update = gameScoreRankService.updateList(gameScoreRanks);
			if (update) {
				log.info("update  game rank success by " + statisticsAt);
			}else {
				log.info("update  game rank error by "+statisticsAt);
			}
		}


	}
	//是否用户提交积分最大值
	private boolean bestScore (Long userId,Integer type,Integer mode,Long score)throws Exception {

		boolean bl = false;
		Map<String,Object> param = DynamicUtil.getUserGameScoreIdsOrderByScore(userId,type,mode,null,true);
		List<Long> userRecordsIds = gameScoreRecordsService.getIdsByDynamicCondition(GameScoreRecords.class,param,0,Integer.MAX_VALUE);
		List<GameScoreRecords> gameScoreRecordsList = gameScoreRecordsService.getObjectsByIds(userRecordsIds);
		Long maxScore = null;
		try {
			//清除旧的记录
			if (userRecordsIds.size()>0){
				maxScore = gameScoreRecordsList.get(0).getScore();
				log.info("this user best score is " + maxScore +" type is " +type + " mode is " + mode);
				bl = score>=maxScore;

				Map<String,Object> paramOld = DynamicUtil.getUserGameScoreIdsOrderByScore(userId,type,mode,maxScore,true);
				List<Long> maxScoresOld = gameScoreRecordsService.getIdsByDynamicCondition(GameScoreRecords.class,paramOld,0,Integer.MAX_VALUE);
				List<GameScoreRecords> gameScoreRecordsListBest = gameScoreRecordsService.getObjectsByIds(maxScoresOld);
				log.info("gameScoreRecordsListBest is " +gameScoreRecordsListBest);
				for (GameScoreRecords item : gameScoreRecordsListBest){
					item.setBest(null);
					item.setRank(null);
				}
				boolean updateList =  gameScoreRecordsService.updateList(gameScoreRecordsListBest);
				if (updateList) {
					log.info("update user best records success " );
				}else {
					log.info("update user best records error " );
				}
			}else {
				bl = true;
			}

		}catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("clear user best score error ");
		}


		return bl;
	}


	/*更新用户信息*/
	private void updateUserMsg(Long uid,Long score) throws Exception{
		User user = userService.getObjectById(uid);
		//更新总积分
		user.setGameScore(user.getGameScore()+score);
		userService.update(user);

		//总积分排序---积分为0不参与排序
		Map<String,Object> rankParam = new HashMap<>();
		rankParam.put(" game_score & !=","0");
		rankParam.put("@order", " game_score desc ");
		rankParam.put("@query", " id");
		rankParam.put("@table", " user ");

		List<Long> userIds = userService.getIdsByDynamicCondition(User.class,rankParam,0,Integer.MAX_VALUE);
		if (userIds.size()>0){
			log.info("===update user game rank start===");
			List<User> users = userService.getObjectsByIds(userIds);
			Long lastScore = null;
			Long i = 0L;
			for (User item:users) {
				if ( item.getGameScore().equals(lastScore)) {
					item.setGameRank(i);
				}else {
					i++;
					item.setGameRank(i);
				}
				lastScore = item.getGameScore();
			}
			boolean update = userService.updateList(users);
			if (update) {
				log.info("update user game rank success");
			}else {
				log.info("update user game rank error");
			}
		}
	}
	private GameScoreRank  setGameScoreRank(Long uid,Long score,Integer type,Integer mode,Long statisticsAt)throws Exception {
		GameScoreRank gameScoreRank = new GameScoreRank();
		if (type == GameScoreRank.UserRank_Type_Null) {
			type = null;
		}
		if (mode == GameScoreRank.UserRank_Mode_Null) {
			mode = null;
		}
		if (statisticsAt == GameScoreRank.UserRank_NotWeek) {
			statisticsAt = null;
		}
		gameScoreRank.setStasticsAt(statisticsAt);
		gameScoreRank.setUserId(uid);
		gameScoreRank.setType(type);
		gameScoreRank.setMode(mode);
		gameScoreRank.setCreateBy(uid);
		gameScoreRank.setUpdateBy(uid);
		gameScoreRank.setGameScore(score);
		gameScoreRank.setRank(1L);
		return gameScoreRank;
	}
}

