package com.ptteng.course.home.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.learn.course.model.Unit;
import com.ptteng.learn.course.service.UnitService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * Unit  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UnitController {
	private static final Log log = LogFactory.getLog(UnitController.class);

	@Autowired
	private UnitService unitService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/unit", method = RequestMethod.GET)
	public String getunitList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/unit  to /unit/view/unitList");

		return "/learn-course-service/unit/view/unitList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/unit1 ", method = RequestMethod.GET)
	public String getUnitIdsByTaskIDOrderBySortList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long taskID) throws Exception {

		log.info("/unit  to /unit/view/unitList");

		return "/learn-course-service/unit/view/unitList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/unit/{id}", method = RequestMethod.GET)
	public String getUnit(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/unit/" + id + "  to /unit/view/unitDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/learn-course-service/unit/view/unitDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/unit1 ", method = RequestMethod.GET)
	public String getUnitIdsByTaskIDOrderBySortJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long taskID) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= unitService.getUnitIdsByTaskIDOrderBySort(taskID,start,size);
		log.info("get countUnitIdsByTaskIDOrderBySort size is " + ids.size());

			List<Unit> unitList = unitService.getObjectsByIds(ids);
			log.info("get unit data is " + unitList.size());

			Integer total = unitService. countUnitIdsByTaskIDOrderBySort(taskID);
			log.info("get unit count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("unitList", unitList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get unit list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/unit/json/unitListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/unit/{id}", method = RequestMethod.GET)
	public String getUnitJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Unit unit = unitService.getObjectById(id);
			log.info("get unit data is " + unit);

			model.addAttribute("code", 0);

			model.addAttribute("unit", unit);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get unit error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/unit/json/unitDetailJson";
	}

	@RequestMapping(value = "/a/unit/{id}", method = RequestMethod.PUT)
	public String updateUnitJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Unit unit) throws Exception {
		
		log.info("update unit : unit= " + unit);
		
		try {
			
			unitService.update(unit);

			model.addAttribute("code", 0);

			model.addAttribute("unit", unit);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update unit error,id is  " + unit.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/unit", method = RequestMethod.POST)
	public String addUnitJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Unit unit) throws Exception {
		
		log.info("update unit : unit= " + unit);
		
		try { 
			unit.setId(null);

			unitService.insert(unit);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add unit error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/unit/{id}", method = RequestMethod.DELETE)
	public String deleteUnitJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete unit : id= " + id);
		try {
			unitService.delete(id);

			log.info("add unit success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete unit error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/unit", method = RequestMethod.GET)
	public String getMultiUnitJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Unit> unitList = unitService.getObjectsByIds(idList);
			log.info("get  unit data is " + unitList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",unitList.size());

			model.addAttribute("unitList", unitList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get unit error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/learn-course-service/unit/json/unitListJson";
	}
	
	
	
	
	
}

