package com.ptteng.course.home.controller;

import java.text.DecimalFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.course.util.DynamicUtil;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Period  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class PeriodController {
    private static final Log log = LogFactory.getLog("period");

    @Autowired
    private PeriodService periodService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private LocksService locksService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private BookService bookService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private ProgressService progressService;
    @Autowired
    private PaperService paperService;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private UserPaperRelationService userPaperRelationService;
    @Autowired
    private BookVersionService bookVersionService;
    @Autowired UnitService unitService;
    @Autowired AnswerService answerService;

    /**
     * @Description 分享课时详情
     * @param pid 课时id
     * @Author: PeiyuFeng
     * @Time 2017/2/16 17:31
     */
    @RequestMapping(value = "/a/period/detail/{pid}", method = RequestMethod.GET)
    public String getSharePeriodJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long pid,
                                Integer page, Integer size)
            throws Exception {

        log.info("get data : id= " + pid);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        Progress progress = new Progress();
        Long progressID = 0L;

        try {

            Period period = periodService.getObjectById(pid);
            if (period == null) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

//            if(Period.Lock.equals(period.getLocked())){
//                model.addAttribute("code", -4047);
//                return "/common/success";
//            }

            if (period.getType() == 1) {
                Long sub = period.getSubjectID();
                Long les = period.getLessonID();
                Subject subject = subjectService.getObjectById(sub);
                Lesson lesson = lessonService.getObjectById(les);

                if (subject != null) {
                    period.setSubjectName(subject.getName());

                }
                if (lesson != null) {
                    period.setLessonName(lesson.getName());
                }
            }

            if (period.getType() == 2) {
                Long bookId = period.getBookID();

                Book book = bookService.getObjectById(bookId);
                if (book != null) {
                    period.setBookName(book.getName());
                    BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
                    if(bookVersion == null){
                        log.info("bookVersion : " + book.getPress() + " not exist");
                    }else {
                        period.setBookPress(bookVersion.getVersionName());
                    }
                }
            }

            log.info("get period data is " + period);

            List<Long> taskIds = taskService.getTaskIdsByPeriodIDOrderBySort(pid, 0, Integer.MAX_VALUE);
            List<Long> count = taskService.getTaskIdsByPeriodIDOrderBySort(pid, 0, Integer.MAX_VALUE);

            if (taskIds == null) {
                log.info("taskIds is " + taskIds);
            } else {
                List<Task> taskList = taskService.getObjectsByIds(taskIds);

                model.addAttribute("taskList", taskList);
            }

            List<Long> periodIds = new LinkedList<>();
            List<Period> periodList = new LinkedList<>();
            //计算总价
            if (period.getType() == 1) {
                Long lessonId = period.getLessonID();
                periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lessonId, Period.status_normal, 0, Integer.MAX_VALUE);
                periodList = periodService.getObjectsByIds(periodIds);
            } else {
                Long bookId = period.getBookID();
                periodIds = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(bookId, Period.status_normal, 0, Integer.MAX_VALUE);
                periodList = periodService.getObjectsByIds(periodIds);
            }

            model.addAttribute("code", 0);
            model.addAttribute("period", period);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get period error,id is  " + pid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/period/json/periodDetailJson";
    }


    /**
     * 课时详情
     *
     * @param request
     * @param response
     * @param model
     * @param pid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/detail/{pid}", method = RequestMethod.GET)
    public String getPeriodJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long pid, Integer page, Integer size)
            throws Exception {

        log.info("get data : id= " + pid);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        Progress progress = new Progress();
        Long progressID = 0L;

        try {

            Boolean memberStatus = false;
            Integer member = user.getMember();
            log.info("user member status : " + member);
            if(User.IS_MEMBER == member){
                log.info("user is member");
                memberStatus = true;
            }

            Period period = periodService.getObjectById(pid);
            if (period == null) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

//            if (period.getStatus() == 2) {
//                model.addAttribute("code", -5050);
//                return "/common/success";
//            }
            if (period.getType() == 1) {
                Long sub = period.getSubjectID();
                Long les = period.getLessonID();
                Subject subject = subjectService.getObjectById(sub);
                Lesson lesson = lessonService.getObjectById(les);
                //验证学习进度是否存在，如果存在是否被下架，如果被下架就上架
                Long progressId= progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, lesson.getId(), Progress.TYPE_LESSON);
                log.info(" progressId = "+progressId);
                Progress progressUp = progressService.getObjectById(progressId);
                if (progressUp != null) {
                    log.info(" process is not null deletestatus = "+progressUp.getDeleteStatus());
                    if(Progress.bedelete.equals(progressUp.getDeleteStatus())){
                        progressUp.setDeleteStatus(Progress.unbedelete);
                        progressService.update(progressUp);

                        log.info("progress be delete and up success");
                    }
                }
                if (subject != null) {
                    period.setSubjectName(subject.getName());

                }
                if (lesson != null) {
                    period.setLessonName(lesson.getName());
                }
            }

            if (period.getType() == 2) {
                Long bookId = period.getBookID();

                Book book = bookService.getObjectById(bookId);
                if (book != null) {
                    period.setBookName(book.getName());
                    BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
                    if(bookVersion == null){
                        log.info("bookVersion : " + book.getPress() + " not exist");
                    }else {
                        period.setBookPress(bookVersion.getVersionName());
                    }
                }
            }

            log.info("get period data is " + period);

            List<Long> taskIds = taskService.getTaskIdsByPeriodIDOrderBySort(pid, 0, Integer.MAX_VALUE);
            List<Long> count = taskService.getTaskIdsByPeriodIDOrderBySort(pid, 0, Integer.MAX_VALUE);


            List<Long> exerciseIds=new ArrayList<>();



            if (taskIds == null) {
//				model.addAttribute("code", 2);
//				return "/common/success";
                log.info("taskIds is " + taskIds);
            } else {
                List<Task> taskList = taskService.getObjectsByIds(taskIds);
                for (Task task : taskList) {
                    progressID = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, task.getId(), Progress.TYPE_TASK);
                    progress = progressService.getObjectById(progressID);
                    if (progress!=null) {

                        task.setOver(progress.getStatus());
                    }
                    if (task.getType().equals(Task.exercise_type_lesson) || task.getType().equals(Task.exercise_type_book)) {
                        exerciseIds.add(task.getId());
                        log.info("exerciseIds , add taskID IS " + task.getId());
                    }

                }
                List<Unit> unitList = new ArrayList<>();
                List<Answer> answerList = new ArrayList<>();
                log.info("exerciseIds is " +exerciseIds);
                if (exerciseIds.size()>0) {
                    Map<String,Object> param = DynamicUtil.getUnitListByTaskIds(exerciseIds,null);
                    List<Long> unitIds = unitService.getIdsByDynamicCondition(Unit.class,param,0,Integer.MAX_VALUE);
                    unitList = unitService.getObjectsByIds(unitIds);

                    Map<String,Object> param2 = DynamicUtil.getAnswerListByTaskIds(exerciseIds,null);
                    List<Long> answerIds = answerService.getIdsByDynamicCondition(Unit.class,param2,0,Integer.MAX_VALUE);
                    answerList = answerService.getObjectsByIds(answerIds);
                }

                model.addAttribute("taskList", taskList);
                model.addAttribute("unitList", unitList);
                model.addAttribute("answerList", answerList);

            }
            log.info("=====验证是否收藏，学习进度=====");

            progressID = userFavoriteRelationService.getUserFavoriteRelationIdByUserIDAndTypeAndTargetID(uid, UserFavoriteRelation.TYPE_PERIOD, period.getId());

            if (progressID != null) {
                period.setFavorite(UserFavoriteRelation.STATUS_LIKE);

            }

            progressID = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, pid, Progress.TYPE_PERIOD);
            progress = progressService.getObjectById(progressID);
            if (null!=progress) {
                period.setOver(progress.getStatus());
            }

            Integer totalTask = count.size();

            if (null != progress) {
                Long pro = progress.getSort();

                if (pro != 0) {
                    if (pro <= totalTask) {
                        period.setProgress(pro.intValue());
                    } else {
                        progress.setStatus(Progress.STATUS_OVER);
                        progress.setSort(Long.valueOf(totalTask));
                        progressService.update(progress);
                    }
                } else {
                    period.setProgress(0);
                }
            } else {
                period.setProgress(null);
            }
            Long paperId = period.getPaperID();

            if (paperId!=null) {
                Paper paper = paperService.getObjectById(paperId);
                if (paper != null) {
                    period.setPaperPrice(paper.getPrice());
                    period.setPaperIosId(paper.getIosId());
                }
                Long userPaperId = userPaperRelationService.getUserTargetRelationIdsByTypeAndUidAndTargetId(UserPaperRelation.TYPE_PPAPER, uid, period.getId());

                if (userPaperId != null) {
                    period.setBuy(Paper.Buy);
                    Long orderId=userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid,UserOrder.ORDER_PPAPER,period.getId());
                    if (orderId == null) {
                        if (period.getType() == 1) {
                            orderId = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_LPAPER, period.getLessonID());
                            period.setOrderId(orderId);
                        } else {
                            orderId = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_BPAPER, period.getBookID());
                            period.setOrderId(orderId);
                        }
                    } else {
                        period.setOrderId(orderId);
                    }
                } else {
                    period.setBuy(Paper.NotBuy);
                }
            }

            Long periodOrderId = null;
            UserOrder userOrder = new UserOrder();
            log.info(uid+"===="+Locks.TYPE_PERIOD+"===="+period.getId());
            periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());

            if (period.getLocked() == 2) {
                period.setUserLock(2);
            } else  {
                if (periodOrderId != null) {
                    period.setUserLock(2);
                }
            }
            Long lessonLocksId = null;
            if (period.getType() == 1) {
                lessonLocksId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_LESSON, period.getLessonID());
            }
//            else {
//                Long lessonLocksId= locksService.getLocksIdByUserIDAndTypeAndTargetID(uid,Locks.TYPE_PERIOD,)
//            }

            if (lessonLocksId != null) {
                period.setUserLock(2);
            }

            if (memberStatus){
                if(period.getOver() == 3 || period.getOver() == null){
                    model.addAttribute("continue", 2);
                }else {
                    model.addAttribute("continue", 3);
                }
            }else {
                if (period.getUserLock() == 1) {
                    model.addAttribute("continue", 1);
                } else if (period.getUserLock() == 2 && period.getOver() == 3) {
                    model.addAttribute("continue", 2);
                } else if (period.getOver() == null) {
                    model.addAttribute("continue", 2);
                } else {
                    model.addAttribute("continue", 3);
                }
            }

            List<Long> periodIds = new LinkedList<>();
            List<Period> periodList = new LinkedList<>();
            //计算总价
            if (period.getType() == 1) {
                Long lessonId = period.getLessonID();
                periodIds = periodService.getPeriodIdsByLessonIDAndStatusOrderBySort(lessonId, Period.status_normal, 0, Integer.MAX_VALUE);
                periodList = periodService.getObjectsByIds(periodIds);
            } else {
                Long bookId = period.getBookID();
                periodIds = periodService.getPeriodIdsByBookIDAndStatusOrderBySort(bookId, Period.status_normal, 0, Integer.MAX_VALUE);
                periodList = periodService.getObjectsByIds(periodIds);
            }

            Long orderId = null;
            Double price = 0D;
            String moneyPrice = "0";
            if (periodList != null) {
                for (Period periodl : periodList) {
                    log.info(" period id = "+periodl.getId());
                    paperId=periodl.getPaperID();
                    if (paperId!=null) {
                        Paper paper = paperService.getObjectById(paperId);
                        if (paper!=null){
                            orderId = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, UserOrder.ORDER_PPAPER, periodl.getId());
                            log.info(" user buy paper id = "+paper.getId()+" order id = "+orderId);
                            if (orderId == null) {
                                price=Double.valueOf(moneyPrice) + Double.valueOf(paper.getPrice());
                                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                                price = new Double(decimalFormat.format(price));
                                moneyPrice =price.toString();
                            }
                        }
                    }
                }
            }

            period.setLessonPaperPrice(moneyPrice);
            //验证是否直接解锁课程

            if (period.getType() == 1) {
                periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_LESSON, period.getLessonID());
                if (periodOrderId != null&&period.getUserLock()==1) {
                    locksService.delete(periodOrderId);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("period", period);

            model.addAttribute("totalTask", totalTask);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get period error,id is  " + pid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/period/json/periodDetailJson";
    }


    /**
     * 开始继续学习课时
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/period/learn/{pid}", method = RequestMethod.POST)
    public String updatePeriodJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long pid) throws Exception {

        List<Long> taskIds = new ArrayList<>();
        List<Task> tasks = new ArrayList<>();
        Long unlockPeriodId = 0L;
        Long lockedId = 0L;
        Long taskProgressId = 0L;
        Progress learnTaskProgress = new Progress();
        Integer sort = null;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        log.info("user : " + uid + " get start learn period : " + pid);
        log.info("User is :"+user);
        try {

            Boolean memberStatus = false;
            Integer member = user.getMember();
            log.info("user member status : " + member);
            if(User.IS_MEMBER == member){
                log.info("user is member");
                memberStatus = true;
            }

            log.info("=====课时是否存在=====");
            Period period = periodService.getObjectById(pid);
            if (null == period) {
                log.info("period is not exist");
                model.addAttribute("code", -4012);
                return "/common/success";
            }
            log.info("period exist");

            log.info("=====课时是否上锁=====");
            if(Period.Lock.equals(period.getLocked())){
                lockedId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, pid);
                String loginType = "school";
                if(loginType.equals(user.getPlatform())){
                    //用户是和校园
                    log.info("user is school");
                } else if (null == lockedId && !memberStatus) {
                    //用户非会员且课时未解锁
                    log.info("period is locked");
                    model.addAttribute("code", -4029);
                    return "/common/success";
                }else if (memberStatus){
                    //用户为会员
                    log.info("user is member");
                }else {
                    //用户非会员但课时已解锁
                    log.info("user is not member but period is unlocked");
                }
            }else {
                log.info("period unlock ");
            }

            //课时任务是否存在
            Long tid = taskService.getTaskIdsByPeriodIDAndSort(pid, 1);
            if (null == tid) {
                log.info("the period have no task");
                model.addAttribute("code", -4028);
                return "/common/success";
            }

            log.info("=====判断是开始学习还是继续学习=====");
            Long progressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, pid, Progress.TYPE_PERIOD);
            if (null != progressId) {

                log.info("=====继续学习=====");
                Progress progress = progressService.getObjectById(progressId);
                if (Progress.STATUS_ING.equals(progress.getStatus())) {

                    log.info("=====课程学习中，获取最后一个学习中任务id=====");
                    sort = Integer.valueOf(progress.getSort().toString());
                    tid = taskService.getTaskIdsByPeriodIDAndSort(pid,sort);

                } else {
                    log.info("=====课时已完成，获取第一个可学课时id:"+tid+"=====");
                }

                log.info("=====判断是否为课程课时=====");

                Long bid = period.getBookID();
                log.info("bid : " + bid);

                if(null != bid) {
                    Long bookProgressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid,bid,Progress.TYPE_BOOK);
                    log.info("period belong book");
                    if(bookProgressId == null){
                        log.info("=====教材未开始、添加教材记录=====");
                        //记录课程进度
                        Progress bookProgress = new Progress();
                        bookProgress.setStatus(Progress.STATUS_ING);
                        bookProgress.setType(Progress.TYPE_BOOK);
                        bookProgress.setTargetID(bid);
                        bookProgress.setUserID(uid);
                        bookProgress.setSort(pid);
                        progressService.insert(bookProgress);
                        log.info("insert book progress success");

                        //添加课程学习人数
                        Book book = bookService.getObjectById(bid);
                        Integer bookCount = book.getStudyCount();
                        book.setStudyCount(bookCount + 1);
                        bookService.update(book);
                        log.info("update book studyCount success");
                    }else {
                        Progress bookProgress = progressService.getObjectById(bookProgressId);
                        bookProgress.setTargetID(bid);
                        bookProgress.setSort(pid);
                        progressService.update(bookProgress);
                        log.info("update book progress success");
                    }
                }

            } else {
                log.info("=====开始学习=====");

                //记录课时进度
                Progress periodProgress = new Progress();
                periodProgress.setStatus(Progress.STATUS_ING);
                periodProgress.setType(Progress.TYPE_PERIOD);
                periodProgress.setTargetID(pid);
                periodProgress.setUserID(uid);
                periodProgress.setSort(1L);
                progressService.insert(periodProgress);
                log.info("insert period progress success");

                //添加课时学习人数
                Integer periodCount = period.getStudyCount();
                period.setStudyCount(periodCount + 1);
                periodService.update(period);
                log.info("update period studyCount success");

                Long lid = period.getLessonID();
                log.info("lid : " + lid);

                log.info("=====判断是否为课程课时=====");
                if(null != lid){
                    log.info("period belong lesson");
                    log.info("=====判断是否开始所属课程=====");
                    Long lessonProgressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid,lid,Progress.TYPE_LESSON);
                    if(null == lessonProgressId){
                        log.info("=====课程未开始、添加课程记录=====");
                        //记录课程进度
                        Progress lessonProgress = new Progress();
                        lessonProgress.setStatus(Progress.STATUS_ING);
                        lessonProgress.setType(Progress.TYPE_LESSON);
                        lessonProgress.setTargetID(lid);
                        lessonProgress.setUserID(uid);
                        lessonProgress.setSort(pid);
                        progressService.insert(lessonProgress);
                        log.info("insert lesson progress success");

                        //添加课程学习人数
                        Lesson lesson = lessonService.getObjectById(lid);
                        Integer lessonCount = lesson.getStudyCount();
                        lesson.setStudyCount(lessonCount + 1);
                        lessonService.update(lesson);
                        log.info("update lesson studyCount success");
                    }else {
                        Progress lessonProgress = progressService.getObjectById(lessonProgressId);
                        lessonProgress.setSort(pid);
                        progressService.update(lessonProgress);
                        log.info("update lesson progress success");
                    }
                }else{
                    Long bid = period.getBookID();
                    log.info("bid : " + bid);

                    log.info("period belong book");
                    log.info("=====判断是否开始所属教材=====");
                    Long bookProgressId = progressService.getProgressIdsByUserIDAndTargetIDAndType(uid, bid, Progress.TYPE_BOOK);
                    if(null == bookProgressId){
                        log.info("=====教材未开始、添加教材记录=====");
                        //记录课程进度
                        Progress bookProgress = new Progress();
                        bookProgress.setStatus(Progress.STATUS_ING);
                        bookProgress.setType(Progress.TYPE_BOOK);
                        bookProgress.setTargetID(bid);
                        bookProgress.setUserID(uid);
                        bookProgress.setSort(pid);
                        progressService.insert(bookProgress);
                        log.info("insert book progress success");

                        //添加课程学习人数
                        Book book = bookService.getObjectById(bid);
                        Integer bookCount = book.getStudyCount();
                        book.setStudyCount(bookCount + 1);
                        bookService.update(book);
                        log.info("update book studyCount success");
                    }else {
                        Progress bookProgress = progressService.getObjectById(bookProgressId);
                        bookProgress.setTargetID(bid);
                        bookProgress.setSort(pid);
                        progressService.update(bookProgress);
                        log.info("update book progress success");
                    }
                }

            }

            Task task = taskService.getObjectById(tid);

            model.addAttribute("code", 0);
            model.addAttribute("tid", tid);
            model.addAttribute("tname", task.getName());

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("user : " + uid + " get start learn period wrong , pid : " + pid);
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/period/json/learnPeriod";
    }



    /**
     * 根据条件搜索period列表
     *
     * @param request
     * @param response
     * @param model
     * @param name
     * @param lessonId
     * @param size
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/period/list", method = RequestMethod.GET)
    public String getMultiPeriodJson(HttpServletRequest request,
                                     HttpServletResponse response, Integer page, ModelMap model, Integer level, String name, Long subjectId, Long lessonId, Long bookId, Integer type, Integer size)
            throws Exception {
        if (type == null) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }
        log.info("get  period data is " + name + "lessonId" + lessonId);
        if (type != 1 && type != 2) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        Map<String, Object> param = DynamicUtil.getPeriodList(level, name, lessonId, subjectId, type, bookId, null);
        try {
            List<Long> ids = periodService.getIdsByDynamicCondition(Period.class, param, start, size);
            List<Long> count = periodService.getIdsByDynamicCondition(Period.class, param, 0, Integer.MAX_VALUE);
            Integer total = count.size();
            List<Period> periodList = periodService.getObjectsByIds(ids);

            if (type == 1) {
                for (Period period : periodList) {
                    Long sub = period.getSubjectID();
                    Long les = period.getLessonID();
                    Subject subject = subjectService.getObjectById(sub);
                    Lesson lesson = lessonService.getObjectById(les);
                    if (subject != null) {
                        period.setSubjectName(subject.getName());
                    }
                    if (period != null) {
                        period.setLessonName(lesson.getName());
                    }

                }
            }
            if (type == 2) {
                for (Period period : periodList) {
                    Long boId = period.getBookID();
                    Book book = bookService.getObjectById(boId);
                    if (book != null) {
                        period.setBookName(book.getName());
                        BookVersion bookVersion = bookVersionService.getObjectById(book.getPress());
                        if(bookVersion == null){
                            log.info("bookVersion : " + book.getPress() + " not exist");
                        }else {
                            period.setBookPress(bookVersion.getVersionName());
                        }
                    }

                }
            }
            model.addAttribute("code", 0);
            boolean next = false;
            if (ids.size() + start + 1 <= total) {
                next = true;
            }
            //资料价格
            Long periodOrderId = null;
            UserOrder userOrder = new UserOrder();
            for (Period period : periodList) {
            //验证用户是否解锁
                periodOrderId = locksService.getLocksIdByUserIDAndTypeAndTargetID(uid, Locks.TYPE_PERIOD, period.getId());
                if (period.getLocked() == 2) {
                    period.setUserLock(2);
                } else if (periodOrderId != null) {
                            period.setUserLock(2);
                }else {
                    period.setUserLock(1);
                }
            }
            Integer totalPage = total / size + 1;
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("periodList", periodList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get period error,id is  ");
            model.addAttribute("code", -1);
        }

        return "/learn-course-service/period/json/periodListJson";
    }


}

