package com.ptteng.course.home.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.course.constant.AlipayConstantConfig;
import com.ptteng.course.util.Base64;
import com.ptteng.course.util.aliPayUtil.util.AlipaySubmit;
import com.ptteng.learn.course.model.*;
import com.ptteng.learn.course.service.*;
import com.qding.common.util.HttpClientUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Map;

/**
 * Created by asus on 2016/8/8.
 */
@Controller
public class AlipayController {

    private static final Log log = LogFactory.getLog("alipay");

    public static final String  SIGN_ALGORITHMS = "SHA1WithRSA";

    @Autowired
    private HttpClientUtil httpClientUtil;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private BookService bookService;
    @Autowired
    private MemberService memberService;


    //获取私钥
    @RequestMapping(value = "/a/u/order/alipay/key/{oid}", method = RequestMethod.GET)
    public String getPrivateKey(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid) throws Exception {
        String subject = "";
        String body = "";

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        try {
            log.info("==========检验是否拥有本订单==========");
            UserOrder userOrder = userOrderService.getObjectById(oid);
            if (null == userOrder) {
                log.info("already pay the order");
                model.addAttribute("code", -3007);
                return "/common/success";
            }


            if (!uid.equals(userOrder.getUid())) {
                log.info("not your order");
                model.addAttribute("code", -4016);
                return "/common/success";
            }

            log.info("==========生成sign==========");

            if(UserOrder.ORDER_LPAPER == userOrder.getBuyType()){
                Lesson lesson = lessonService.getObjectById(userOrder.getTargetId());
                subject = "回家学习课程资料";
                body = lesson.getName()+"课程资料";

            }else if(UserOrder.ORDER_LESSON == userOrder.getBuyType()){
                Lesson lesson = lessonService.getObjectById(userOrder.getTargetId());
                subject = "回家学习解锁课程";
                body = "解锁课程"+lesson.getName();

            }else if(UserOrder.ORDER_PPAPER == userOrder.getBuyType()){
                Period period = periodService.getObjectById(userOrder.getTargetId());
                subject = "回家学习课时资料";
                body = period.getName()+"课时资料";

            }else if(UserOrder.ORDER_PERIOD == userOrder.getBuyType()){
                Period period = periodService.getObjectById(userOrder.getTargetId());
                subject = "回家学习解锁课时";
                body = "解锁课时"+period.getName();

            }else if(UserOrder.ORDER_BPAPER == userOrder.getBuyType()){
                Book book = bookService.getObjectById(userOrder.getTargetId());
                subject = "回家学习教材资料";
                body = book.getName()+"教材资料";
            }else if(UserOrder.ORDER_MEMBER == userOrder.getBuyType()){
                Member member = memberService.getObjectById(userOrder.getTargetId());
                subject = "回家学习会员订单";
                body = member.getName()+"订单";
            }

            String perSign = "partner=\""+ AlipayConstantConfig.partner
                    +"\"&seller_id=\""+ AlipayConstantConfig.seller_id
                    +"\"&out_trade_no=\""+userOrder.getOrderId()
                    +"\"&subject=\""+subject
                    +"\"&body=\""+body
                    +"\"&total_fee=\""+ userOrder.getPrice()
                    +"\"&notify_url=\"http://www.xxx.com\"&service=\"mobile.securitypay.pay\"&payment_type=\"1\"&_input_charset=\"utf-8\"&it_b_pay=\"30m\"&show_url=\"m.alipay.com\"";

            String sign = sign(perSign,
                    "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJRAolCITRXK7EuhrZZsvf9SDfYqNHY97THCx/9vVYPRx1WTYEzk4geA9E2mEFgbdDoRf5jQ5kVu5pKm7BRr1ctck7gGDIlu74S4RGPIG5pfGsvZYI//MDy2Q7zbBWaaG52zANSlQ2ELZ+A4lh86Tp+KLIDewPNSYZdRhPirR3P5AgMBAAECgYBAOnRX4YVMALs41RXoiroR6JHF6WkLJS8jFNki8DAjSPpMN+pLxgmq6JJvJZgFI/fJxJT8Ntzcjfx04r565nEb3fUUcuWvmzzU/hpe3tgzCpyulCz2NjnDrIFP1v1uAopIKXeMxnV9KnRBKidv9/ArKUgFWCWBKMilI2GhivSbRQJBAMLlimomgBVQ812xnWXuRLsG3OSC8DcD2iRL3hQjvjAzYD4bs4uTkjw2y2tU5tYoCuzbE74AM++XI2xASEOxyhMCQQDCu2thQVuwC7eVYijEezNMrSC1s50aNoUwvIyAF46uck84lBtI5MzRN3NAv4vxIzCC7PqejL9v+XSW780dxEtDAkEApTY1zmQSoX88vgjpd1Wyt6RKrf79KHXAfpI9kG74Mx3qENwkqEYRaa+9Yp/XCmVpVX0k0CSV4h0JryMS3yegNwJAbOJpL29hOjXDCDdjvkF5NMWVhaQSE0crAE5dbX4+nNJz85n1C7RLxixwOGMid8oKZRrnI+JlZNIiXAdoNN2+iwJABi0to6f8o1PmqjDNiraQdgcSnN2HwUMmuyONltoIPhgBYVhu/Z0F84+4ZRCgi4rJVqD+NlPDCMn0k5y0egwbPA==",
                    "UTF-8");
            log.info("sign : " + sign);
            sign = URLEncoder.encode(sign);
            log.info("encode sign : " + sign);

            model.addAttribute("code", 0);
            model.addAttribute("sign",sign);
            model.addAttribute("privateKey", AlipayConstantConfig.private_key);
            model.addAttribute("sellerId", AlipayConstantConfig.seller_id);
            model.addAttribute("partner", AlipayConstantConfig.partner);
            model.addAttribute("orderSpec", perSign);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update pay way error, oid is  " + oid);
            model.addAttribute("code", -1);
        }

        return "/alipay/tradeQuery";
    }




    /**
     * RSA签名
     * @param content 待签名数据
     * @param privateKey 商户私钥
     * @param input_charset 编码格式
     * @return 签名值
     */
    public static String sign(String content, String privateKey, String input_charset)
    {
        try
        {
            PKCS8EncodedKeySpec priPKCS8 	= new PKCS8EncodedKeySpec( Base64.decode(privateKey) );
            KeyFactory keyf 				= KeyFactory.getInstance("RSA");
            PrivateKey priKey 				= keyf.generatePrivate(priPKCS8);

            java.security.Signature signature = java.security.Signature
                    .getInstance(SIGN_ALGORITHMS);

            signature.initSign(priKey);
            signature.update( content.getBytes(input_charset) );

            byte[] signed = signature.sign();

            return Base64.encode(signed);
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        return null;
    }
}
