/**
 * 
 */
package com.ptteng.sca.learn.course.client;

import java.util.List;
import java.util.Map;

import com.ptteng.learn.course.model.Subject;
import com.ptteng.learn.course.service.SubjectService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class SubjectSCAClient implements SubjectService {

    private SubjectService subjectService;

	public SubjectService getSubjectService() {
		return subjectService;
	}
	
	
	public void setSubjectService(SubjectService subjectService) {
		this.subjectService =subjectService;
	}
	
	
			   
		@Override
		public Long insert(Subject subject)throws ServiceException, ServiceDaoException{
		
		return subjectService.insert(subject);
		          
		
		}	
		  
    	   
		@Override
		public List<Subject> insertList(List<Subject> subjectList)throws ServiceException, ServiceDaoException{
		
		return subjectService.insertList(subjectList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return subjectService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Subject subject)throws ServiceException, ServiceDaoException{
		
		return subjectService.update(subject);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Subject> subjectList)throws ServiceException, ServiceDaoException{
		
		return subjectService.updateList(subjectList);
		          
		
		}	
		  
    	   
		@Override
		public Subject getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return subjectService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Subject> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return subjectService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSubjectIdsByNameAndClassId(String name,Long classId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return subjectService.getSubjectIdsByNameAndClassId(name,classId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSubjectIdsByNameAndType(String name,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return subjectService.getSubjectIdsByNameAndType(name,type,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSubjectIdsByGradeNameAndClassId(String gradeName,Long classId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return subjectService.getSubjectIdsByGradeNameAndClassId(gradeName,classId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSubjectIdsByNameAndClassId(String name,Long classId)throws ServiceException, ServiceDaoException{
		
		return subjectService.countSubjectIdsByNameAndClassId(name,classId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSubjectIdsByNameAndType(String name,Integer type)throws ServiceException, ServiceDaoException{
		
		return subjectService.countSubjectIdsByNameAndType(name,type);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSubjectIdsByGradeNameAndClassId(String gradeName,Long classId)throws ServiceException, ServiceDaoException{
		
		return subjectService.countSubjectIdsByGradeNameAndClassId(gradeName,classId);
	
	
	}
	
		
	
		@Override
	public List<Long> getSubjectIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return subjectService.getSubjectIds(start, limit);
	}

	@Override
	public List<Long> getSubjectIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return subjectService.getSubjectIdsByStatus(status,start,limit);
	}

//	@Override
//	public List<Long> getSubjectIdsBySubject(Long subjectId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
//		return subjectService.getSubjectIdsBySubject(subjectId, start, limit);
//	}

	@Override
	public List<Long> getSubjectIdsByName(String name,Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return subjectService.getSubjectIdsByName(name,start,limit);
	}

	@Override
	public List<Long> getSubjectIdsOrderBySort(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return subjectService.getSubjectIdsOrderBySort(start,limit);
	}

	@Override
	public List<Long> getSubjectIdsByStatusOrderBySort(Integer status,Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return subjectService.getSubjectIdsByStatusOrderBySort(status,start,limit);
	}

	@Override
	public List<Long> getSubjectIdsByStatusAndTypeOrderBySort(Integer status, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return subjectService.getSubjectIdsByStatusAndTypeOrderBySort(status,type,start,limit);
	}

	@Override
	public List<Long> getSubjectIdsByStatusAndUserTypeOrderBySort(Integer status, Integer userType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return subjectService.getSubjectIdsByStatusAndUserTypeOrderBySort(status, userType, start, limit);
	}

	@Override
	public Integer countSubjectIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return subjectService.countSubjectIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return subjectService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return subjectService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   subjectService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.subjectService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

