package com.ptteng.learn.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.learn.course.model.UserDlessonRelation;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserDlessonRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(UserDlessonRelation userDlessonRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserDlessonRelation> insertList(List<UserDlessonRelation> userDlessonRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserDlessonRelation userDlessonRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserDlessonRelation> userDlessonRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserDlessonRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserDlessonRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;




	/**
	 * @Description 根据用户id获取关系列表id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 12:45
	 */
	public List<Long> getIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

	/**
	 * @Description 根据用户id获取关系列表id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 12:45
	 */
	public Integer countIdsByUid(Long uid) throws ServiceException, ServiceDaoException;

	/**
	 * @Description 根据用户id和听写课程id获取关系id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/17 13:08
	 */
	public Long  getIdsByUserIdAndLessonId(Long userId,Long lessonId)throws ServiceException, ServiceDaoException;
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserDlessonRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserDlessonRelationIds() throws ServiceException, ServiceDaoException;
	

}

