package com.ptteng.learn.course.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.learn.course.model.Subject;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface SubjectService extends BaseDaoService {

	



   		   
		
		public Long insert(Subject subject)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Subject> insertList(List<Subject> subjectList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Subject subject)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Subject> subjectList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Subject getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Subject> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSubjectIdsByNameAndClassId(String name, Long classId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSubjectIdsByNameAndType(String name, Integer type)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countSubjectIdsByGradeNameAndClassId(String gradeName, Long classId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSubjectIdsByNameAndClassId(String name, Long classId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSubjectIdsByNameAndType(String name, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getSubjectIdsByGradeNameAndClassId(String gradeName, Long classId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getSubjectIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

//
//	/**
//	 *
//	 * @param
//	 * @return
//	 * @throws ServiceException
//	 * @throws ServiceDaoException
//	 */
	public List<Long> getSubjectIdsByStatus(Integer status,Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 根据科目名称搜科目
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
     */
	public List<Long> getSubjectIdsByName(String name,Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	public List<Long> getSubjectIdsOrderBySort(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;


	public List<Long> getSubjectIdsByStatusOrderBySort(Integer status,Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;


	public List<Long> getSubjectIdsByStatusAndTypeOrderBySort(Integer status,Integer type, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;


	public List<Long> getSubjectIdsByStatusAndUserTypeOrderBySort(Integer status,Integer userType, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countSubjectIds() throws ServiceException, ServiceDaoException;
	

}

