package com.ptteng.learn.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.learn.course.model.DperiodTypeRelation;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface DperiodTypeRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(DperiodTypeRelation dperiodTypeRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<DperiodTypeRelation> insertList(List<DperiodTypeRelation> dperiodTypeRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(DperiodTypeRelation dperiodTypeRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<DperiodTypeRelation> dperiodTypeRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public DperiodTypeRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<DperiodTypeRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;




	/**
	 * @Description 根据pid获取语言类型id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/19 15:32
	 */
	public List<Long> getIdsByPeriodId(Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;



	/**
	 * @Description 根据语言类型id获取关系id
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/5/26 15:31
	 */
	public List<Long> getIdsByTypeId(Long typeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getDperiodTypeRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countDperiodTypeRelationIds() throws ServiceException, ServiceDaoException;
	

}

