package com.ptteng.learn.course.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.learn.course.model.BookSubject;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface BookSubjectService extends BaseDaoService {

	



   		   
		
		public Long insert(BookSubject bookSubject)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<BookSubject> insertList(List<BookSubject> bookSubjectList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(BookSubject bookSubject)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<BookSubject> bookSubjectList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public BookSubject getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<BookSubject> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;



	/**
	 * @Description 名称获取教材科目id
	 * @param name 教材名称
	 * @Author: PeiyuFeng
	 * @Time 2017/3/31 10:21
	 */
	public Long getIdByName(String name)throws ServiceException, ServiceDaoException;
				
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getBookSubjectIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countBookSubjectIds() throws ServiceException, ServiceDaoException;

	/**
	 * @Description 获取在线教材科目id并按sort排序
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/3/31 11:28
	 */
	List<Long> getSubjectIdsByStatusOrderBySort(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
}

