package com.ptteng.learn.course.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "period")
public class Period implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8646555666912145408L;


	public static final Integer Lock = 1;
	public static final Integer UnLock = 2;

	public static final Integer status_normal = 1;
	public static final Integer status_freeze = 2;

	public static final Integer sort_freeze = -1;
	public static final Integer Lesson = 1;
	public static final Integer Book = 2;


	public static final Integer Buy = 1;
	public static final Integer notBuy = 2;
	public static final Integer noPaper = 3;
	public static final Integer NO = 0;
	public static final Integer YES = 1;




	private String iosId;

	private  Long id;
	
  	 
    private  String name;
	
  	 
    private  String introduce;
	
  	 
    private  Integer level;
	
  	 
    private  String img;
	
  	 
    private  Integer sort;
	
  	 
    private  Integer favoriteCount=0;
	
  	 
    private  Integer taskCount=0;
	
  	 
    private  Integer locked;
	
  	 
    private  Long lessonID;


	private Long subjectID;
	
  	 
    private  Long paperID;


	private Long bookID;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;



	private Integer studyCount=0;
	
  	 
    private  Long createAt;
	//上下架状态
	private  Integer status=Period.status_freeze;

	//星星数量
	private Integer star;
//区分课程课时和教材课时
	private Integer type=1;


	private String subjectName;


	private String lessonName;


	private BigDecimal moneyPrice=new BigDecimal(0);

	private Integer starPrice=0;


	private String bookName;


	private String bookPress;



	private Integer gradeType;


	//用户是否收藏
	private Integer favorite=UserFavoriteRelation.STATUS_DISLIKE;

	//用户学习进度
	private Integer progress=0;

	//判断学习状态
	private Integer over=3;


	private String paperPrice;
	private String paperIosId;
	//用户是否解锁
	private Integer userLock=1;


	private String lessonPaperPrice;

	//用户是否购买过资料  3代表默认无资料
	private Integer buy=3;


	//资料订单id
	private Long orderId;
	private Integer starDisplay=0;//星星是否展示
	private Integer starLevel=0;//星星个数

	private Long unitId;



	@Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
	@Transient
	public String getPaperIosId() {
		return paperIosId;
	}

	public void setPaperIosId(String paperIosId) {
		this.paperIosId = paperIosId;
	}

	@Column(name = "ios_id")
	public String getIosId() {
		return iosId;
	}

	public void setIosId(String iosId) {
		this.iosId = iosId;
	}
		 	@Column(name = "name")
	public String getName() {
		return name;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}
		 	@Column(name = "introduce")
	public String getIntroduce() {
		return introduce;
	}
	
	
	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}
		 	@Column(name = "level")
	public Integer getLevel() {
		return level;
	}
	
	
	public void setLevel(Integer level) {
		this.level = level;
	}
		 	@Column(name = "img")
	public String getImg() {
		return img;
	}
	
	
	public void setImg(String img) {
		this.img = img;
	}
		 	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}
	
	
	public void setSort(Integer sort) {
		this.sort = sort;
	}
		 	@Column(name = "favorite_count")
	public Integer getFavoriteCount() {
		return favoriteCount;
	}
	
	
	public void setFavoriteCount(Integer favoriteCount) {
		this.favoriteCount = favoriteCount;
	}
		 	@Column(name = "task_count")
	public Integer getTaskCount() {
		return taskCount;
	}
	
	
	public void setTaskCount(Integer taskCount) {
		this.taskCount = taskCount;
	}
		 	@Column(name = "locked")
	public Integer getLocked() {
		return locked;
	}
	
	
	public void setLocked(Integer locked) {
		this.locked = locked;
	}
		 	@Column(name = "lesson_id")
	public Long getLessonID() {
		return lessonID;
	}
	
	
	public void setLessonID(Long lessonID) {
		this.lessonID = lessonID;
	}
		 	@Column(name = "paper_id")
	public Long getPaperID() {
		return paperID;
	}
	
	
	public void setPaperID(Long paperID) {
		this.paperID = paperID;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
	@Column(name = "star")
	public Integer getStar() {
		return star;
	}

	public void setStar(Integer star) {
		this.star = star;
	}
	@Column(name = "book_id")
	public Long getBookID() {
		return bookID;
	}

	public void setBookID(Long bookID) {
		this.bookID = bookID;
	}
	@Column(name = "subject_id")
	public Long getSubjectID() {
		return subjectID;
	}

	public void setSubjectID(Long subjectID) {
		this.subjectID = subjectID;
	}
	@Column(name = "type")
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
@Transient
	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}
@Transient
	public String getLessonName() {
		return lessonName;
	}

	public void setLessonName(String lessonName) {
		this.lessonName = lessonName;
	}
	@Column(name = "money_price")

	public BigDecimal getMoneyPrice() {
		return moneyPrice;
	}

	public void setMoneyPrice(BigDecimal moneyPrice) {
		this.moneyPrice = moneyPrice;
	}
	@Column(name = "star_price")
	public Integer getStarPrice() {
		return starPrice;
	}

	public void setStarPrice(Integer starPrice) {
		this.starPrice = starPrice;
	}
	@Transient
	public String getBookName() {
		return bookName;
	}

	public void setBookName(String bookName) {
		this.bookName = bookName;
	}
@Transient
	public String getBookPress() {
		return bookPress;
	}

	public void setBookPress(String bookPress) {
		this.bookPress = bookPress;
	}
@Transient
	public Integer getGradeType() {
		return gradeType;
	}

	public void setGradeType(Integer gradeType) {
		this.gradeType = gradeType;
	}
@Transient
	public Integer getFavorite() {
		return favorite;
	}

	public void setFavorite(Integer favorite) {
		this.favorite = favorite;
	}
@Transient
	public Integer getProgress() {
		return progress;
	}

	public void setProgress(Integer progress) {
		this.progress = progress;
	}
@Transient
	public Integer getOver() {
		return over;
	}

	public void setOver(Integer over) {
		this.over = over;
	}
	@Column(name = "study_count")
	public Integer getStudyCount() {
		return studyCount;
	}

	public void setStudyCount(Integer studyCount) {
		this.studyCount = studyCount;
	}
@Transient
	public String getPaperPrice() {
		return paperPrice;
	}

	public void setPaperPrice(String paperPrice) {
		this.paperPrice = paperPrice;
	}
@Transient
	public Integer getUserLock() {
		return userLock;
	}

	public void setUserLock(Integer userLock) {
		this.userLock = userLock;
	}
@Transient
	public String getLessonPaperPrice() {
		return lessonPaperPrice;
	}

	public void setLessonPaperPrice(String lessonPaperPrice) {
		this.lessonPaperPrice = lessonPaperPrice;
	}
@Transient
	public Integer getBuy() {
		return buy;
	}

	public void setBuy(Integer buy) {
		this.buy = buy;
	}
@Transient
	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}
	@Column(name="star_display")
	public Integer getStarDisplay() {
		return starDisplay;
	}

	public void setStarDisplay(Integer starDisplay) {
		this.starDisplay = starDisplay;
	}

	@Column(name = "star_level")
	public Integer getStarLevel() {
		return starLevel;
	}

	public void setStarLevel(Integer starLevel) {
		this.starLevel = starLevel;
	}

	@Column(name = "unit_id")
	public Long getUnitId() {
		return unitId;
	}

	public void setUnitId(Long unitId) {
		this.unitId = unitId;
	}
}

