package com.ptteng.learn.course.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "lesson")
public class Lesson implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1584522328531636224L;




	public static final Integer Lock = 1;
	public static final Integer UnLock = 2;

	public static final Integer status_normal = 1;
	public static final Integer status_freeze = 2;

	public static final Integer status_recommend = 1;
	public static final Integer status_unRecommend = 2;

	public static final Integer Buy = 1;
	public static final Integer notBuy = 2;
	public static final Integer noPaper = 3;

	/**
	 * 星级是否展示
	 * 0--不展示星星
	 * 1--展示星星
	 */
	public static final Integer STAR_UNDISPLAY = 0;
	public static final Integer STAR_DISPLAY = 1;

	private  Long id;
	
  	 
    private  String name;
	
  	 //简介
    private  String introduce;
	//相关推荐
	private String introduces;
  	 
    private  Integer recommend=2;
	
  	 
    private  String recommendImg;
	
  	 
    private  Integer level;
	private String levelName;
  	 
    private  Long subjectId;


	private String firstImg;
	
  	 
    private  String img;
	
  	 
    private  Integer sort;
	
  	 
    private  Integer studyCount=0;
	
  	 
    private  Integer favoriteCount=0;
	
  	 
    private  Integer periodCount=0;
	
  	 
    private  Integer paperCount=0;


	private Integer locked = Lesson.UnLock;
	
  	 
    private  Long collaborateID;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
//上下架状态
	private Integer status=Lesson.status_freeze;

//课程价格
	private BigDecimal moneyPrice=new BigDecimal(0);


	private Integer starPrice=0;


	private Integer gradeType;


	private String subjectName;


	private String gradeIntroduce;

	//用户是否收藏
	private Integer favorite=UserFavoriteRelation.STATUS_DISLIKE;

	//用户学习进度
	private Integer progress=0;

	//判断学习状态
	private Integer over=3;

	private String paperPrice;

	//用户是否解锁
	private Integer userLock=1;

	//相关推荐前台用
	private String introduceHome;


	private Integer buy=Lesson.Buy;


	private Long orderId;
  
	private Integer starDisplay;
	private Integer starLevel;


	public static final Integer normal_lesson = 1;
	public static final Integer select_lesson = 2;

	/**
	 * 1、非精选
	 * 2、精选
	 */
	private Integer selected = 1;
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}

	@Transient
	public String getLevelName() {
		return levelName;
	}

	public void setLevelName(String levelName) {
		this.levelName = levelName;
	}

	@Column(name = "name")
	public String getName() {
		return name;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}
		 	@Column(name = "introduce")
	public String getIntroduce() {
		return introduce;
	}
	
	
	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}
		 	@Column(name = "recommend")
	public Integer getRecommend() {
		return recommend;
	}
	
	
	public void setRecommend(Integer recommend) {
		this.recommend = recommend;
	}
		 	@Column(name = "recommend_img")
	public String getRecommendImg() {
		return recommendImg;
	}
	
	
	public void setRecommendImg(String recommendImg) {
		this.recommendImg = recommendImg;
	}
		 	@Column(name = "level")
	public Integer getLevel() {
		return level;
	}
	
	
	public void setLevel(Integer level) {
		this.level = level;
	}
		 	@Column(name = "subject_id")
	public Long getSubject() {
		return subjectId;
	}
	
	
	public void setSubject(Long subjectId) {
		this.subjectId = subjectId;
	}
		 	@Column(name = "img")
	public String getImg() {
		return img;
	}
	
	
	public void setImg(String img) {
		this.img = img;
	}
		 	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}
	
	
	public void setSort(Integer sort) {
		this.sort = sort;
	}
		 	@Column(name = "study_count")
	public Integer getStudyCount() {
		return studyCount;
	}
	
	
	public void setStudyCount(Integer studyCount) {
		this.studyCount = studyCount;
	}
		 	@Column(name = "favorite_count")
	public Integer getFavoriteCount() {
		return favoriteCount;
	}
	
	
	public void setFavoriteCount(Integer favoriteCount) {
		this.favoriteCount = favoriteCount;
	}
		 	@Column(name = "period_count")
	public Integer getPeriodCount() {
		return periodCount;
	}
	
	
	public void setPeriodCount(Integer periodCount) {
		this.periodCount = periodCount;
	}
		 	@Column(name = "paper_count")
	public Integer getPaperCount() {
		return paperCount;
	}
	
	
	public void setPaperCount(Integer paperCount) {
		this.paperCount = paperCount;
	}
		 	@Column(name = "locked")
	public Integer getLocked() {
		return locked;
	}
	
	
	public void setLocked(Integer locked) {
		this.locked = locked;
	}
		 	@Column(name = "collaborate_id")
	public Long getCollaborateID() {
		return collaborateID;
	}
	
	
	public void setCollaborateID(Long collaborateID) {
		this.collaborateID = collaborateID;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
	@Column(name = "first_img")
	public String getFirstImg() {
		return firstImg;
	}

	public void setFirstImg(String firstImg) {
		this.firstImg = firstImg;
	}

	@Transient
	public Integer getGradeType() {
		return gradeType;
	}

	public void setGradeType(Integer gradeType) {
		this.gradeType = gradeType;
	}
	@Column(name = "money_price")
	public BigDecimal getMoneyPrice() {
		return moneyPrice;
	}

	public void setMoneyPrice(BigDecimal moneyPrice) {
		this.moneyPrice = moneyPrice;
	}
	@Column(name = "star_price")
	public Integer getStarPrice() {
		return starPrice;
	}

	public void setStarPrice(Integer starPrice) {
		this.starPrice = starPrice;
	}
	@Column(name = "introduces")
	public String getIntroduces() {
		return introduces;
	}

	public void setIntroduces(String introduces) {
		this.introduces = introduces;
	}
@Transient
	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}
@Transient
	public String getGradeIntroduce() {
		return gradeIntroduce;
	}

	public void setGradeIntroduce(String gradeIntroduce) {
		this.gradeIntroduce = gradeIntroduce;
	}
@Transient
	public Integer getFavorite() {
		return favorite;
	}

	public void setFavorite(Integer favorite) {
		this.favorite = favorite;
	}
@Transient
	public Integer getProgress() {
		return progress;
	}

	public void setProgress(Integer progress) {
		this.progress = progress;
	}
@Transient
	public Integer getOver() {
		return over;
	}

	public void setOver(Integer over) {
		this.over = over;
	}
@Transient
	public String getPaperPrice() {
		return paperPrice;
	}

	public void setPaperPrice(String paperPrice) {
		this.paperPrice = paperPrice;
	}
@Transient
	public Integer getUserLock() {
		return userLock;
	}

	public void setUserLock(Integer userLock) {
		this.userLock = userLock;
	}
	@Column(name = "introduce_home")
	public String getIntroduceHome() {
		return introduceHome;
	}

	public void setIntroduceHome(String introduceHome) {
		this.introduceHome = introduceHome;
	}
@Transient
	public Integer getBuy() {
		return buy;
	}

	public void setBuy(Integer buy) {
		this.buy = buy;
	}
@Transient
	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	@Column(name="star_display")
	public Integer getStarDisplay() {
		return starDisplay;
	}

	public void setStarDisplay(Integer starDisplay) {
		this.starDisplay = starDisplay;
	}

	@Column(name = "star_level")
	public Integer getStarLevel() {
		return starLevel;
	}

	public void setStarLevel(Integer starLevel) {
		this.starLevel = starLevel;
	}

	@Column(name = "selected")
	public Integer getSelected() {
		return selected;
	}

	public void setSelected(Integer selected) {
		this.selected = selected;
	}
	//	@Column(name = "subject_id")
//	public Long getSubjectId() {
//		return subjectId;
//	}
//
//	public void setSubjectId(Long subjectId) {
//		this.subjectId = subjectId;
//	}
}

