/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.graship.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.admin.model.Records;
import com.ptteng.graship.admin.service.RecordsService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RecordsServiceImpl
extends BaseDaoServiceImpl
implements RecordsService {
    private static final Log log = LogFactory.getLog(RecordsServiceImpl.class);
    @Autowired
    private Dao dao;

    public Long insert(Records records) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + records));
        if (records == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        records.setCreateAt(Long.valueOf(currentTimeMillis));
        records.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)records);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + records));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Records> insertList(List<Records> recordsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (recordsList == null ? "null" : Integer.valueOf(recordsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(recordsList)) {
            return new ArrayList<Records>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Records records : recordsList) {
            records.setCreateAt(Long.valueOf(currentTimeMillis));
            records.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(recordsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + recordsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Records.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Records records) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (records == null ? "null" : records.getId())));
        boolean result = false;
        if (records == null) {
            return true;
        }
        records.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)records);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + records));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + records));
        }
        return result;
    }

    public boolean updateList(List<Records> recordsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (recordsList == null ? "null" : Integer.valueOf(recordsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(recordsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Records records : recordsList) {
            records.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(recordsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + recordsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + recordsList.size()));
        return result;
    }

    public Records getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Records records = null;
        if (id == null) {
            return records;
        }
        try {
            records = (Records)this.dao.get(Records.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return records;
    }

    public List<Records> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List records = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Records>();
        }
        try {
            records = this.dao.getList(Records.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (records == null ? "null" : Integer.valueOf(records.size()))));
        return records;
    }

    public List<Long> getRecordsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRecordsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRecordsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRecordsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRecordsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

