/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.graship.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.graship.admin.model.Constant;
import com.ptteng.graship.admin.service.ConstantService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConstantServiceImpl
extends BaseDaoServiceImpl
implements ConstantService {
    private static final Log log = LogFactory.getLog(ConstantServiceImpl.class);

    public Long insert(Constant constant) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + constant));
        if (constant == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        constant.setCreateAt(Long.valueOf(currentTimeMillis));
        constant.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)constant);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + constant));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Constant> insertList(List<Constant> constantList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (constantList == null ? "null" : Integer.valueOf(constantList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(constantList)) {
            return new ArrayList<Constant>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Constant constant : constantList) {
            constant.setCreateAt(Long.valueOf(currentTimeMillis));
            constant.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(constantList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + constantList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Constant.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Constant constant) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (constant == null ? "null" : constant.getId())));
        boolean result = false;
        if (constant == null) {
            return true;
        }
        constant.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)constant);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + constant));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + constant));
        }
        return result;
    }

    public boolean updateList(List<Constant> constantList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (constantList == null ? "null" : Integer.valueOf(constantList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(constantList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Constant constant : constantList) {
            constant.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(constantList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + constantList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + constantList.size()));
        return result;
    }

    public Constant getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Constant constant = null;
        if (id == null) {
            return constant;
        }
        try {
            constant = (Constant)this.dao.get(Constant.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return constant;
    }

    public List<Constant> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List constant = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Constant>();
        }
        try {
            constant = this.dao.getList(Constant.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (constant == null ? "null" : Integer.valueOf(constant.size()))));
        return constant;
    }

    public Long getConstantIdByKey(String key) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by key  : " + key));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getConstantIdByKey", new Object[]{key});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by key  : " + key));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getConstantIdsByType(String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getConstantIdsByType", new Object[]{type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,start,limit)  : " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getConstantIdByKeyAndType(String key, String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by key,type  : " + key + " , " + type));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getConstantIdByKeyAndType", new Object[]{key, type});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by key,type  : " + key + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countConstantIdsByType(String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by type  : " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getConstantIdsByType", new Object[]{type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by type)  : " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getConstantIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getConstantIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countConstantIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getConstantIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getConstantIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public String getValue(String key, String type) throws ServiceException, ServiceDaoException {
        log.info((Object)("key:" + key + "type:" + type));
        Long id = this.getConstantIdByKeyAndType(key, type);
        Constant constant = this.getObjectById(id);
        String value = constant.getValue();
        return value;
    }
}

