package com.ptteng.graship.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;

import com.ptteng.graship.admin.constant.InterfaceCodeConstant;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Company;
import com.ptteng.graship.home.model.CompanyServerRelation;
import com.ptteng.graship.home.model.Message;
import com.ptteng.graship.home.model.Moduls;
import com.ptteng.graship.home.model.Order;
import com.ptteng.graship.home.model.Serve;
import com.ptteng.graship.home.model.Sms;
import com.ptteng.graship.home.model.User;
import com.ptteng.graship.home.model.UserCompanyRelation;
import com.ptteng.graship.home.model.UserServerRelation;
import com.ptteng.graship.home.service.CompanyServerRelationService;
import com.ptteng.graship.home.service.CompanyService;
import com.ptteng.graship.home.service.MessageService;
import com.ptteng.graship.home.service.ModulsService;
import com.ptteng.graship.home.service.OrderService;
import com.ptteng.graship.home.service.ServeService;
import com.ptteng.graship.home.service.SmsService;
import com.ptteng.graship.home.service.UserCompanyRelationService;
import com.ptteng.graship.home.service.UserServerRelationService;
import com.ptteng.graship.home.service.UserService;
import com.ptteng.graship.home.vo.ModulsAndOrder;
import com.ptteng.graship.home.vo.ModulsAndUser;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;

import atg.taglib.json.util.JSONArray;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * User crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserController {
	private static final Log log = LogFactory.getLog(UserController.class);

	@Autowired
	private UserService userService;

	@Autowired
	ModulsService modulsService;

	@Autowired
	private SmsService smsService;

	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private OrderService orderService;
    @Autowired
    private CompanyService companyService;
	@Autowired
	private ServeService serveService;
	@Autowired
	private CompanyServerRelationService companyServerRelationService;
	@Autowired
	private UserCompanyRelationService userCompanyRelationService;
	@Resource(name = "accountConfig")
	private Map<String, String> accountConfig;
	@Autowired
	private UserServerRelationService userServerRelationService;
    @Autowired
    private MessageService messageService;
	private boolean isCaptcha = false;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	// ====================================================================================//
	// =============================|---------|============================================//
	// =============================| 后台接口
	// |============================================//
	// =============================|---------|============================================//
	// ====================================================================================//

	// ================================用户列表=========================================

	// 获得用户列表1
	@RequestMapping(value = " /a/user/list", method = RequestMethod.GET)
	public String getuserList(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
			Long endAt, Long startAt, String mobile, Integer page, Integer size) throws Exception {
		log.info("getUserLIst /a/u/user  to /user/view/userList");

		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		// 下一页
		// Boolean next = false;

		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		List<Long> ids = null;
		List<User> users = null;
		List<Long> totals = null;
		log.info("get ids by name=" + name + "mobile=" + mobile + "startAt=" + startAt + "endAt=" + endAt);
		Map<String, Object> param = DynamicUtil.getIdsParam(startAt, endAt, name, mobile, false);
		log.info("param is" + param);

		ids = userService.getIdsByDynamicCondition(User.class, param, start, size);
		log.info("ids====ooo===" + ids);
		totals = userService.getIdsByDynamicCondition(User.class, param, 0, Integer.MAX_VALUE);
		int total = totals.size();
		// userService.getUserIds(start, limit);
		Integer totalPage = (total / size) + 1;
		log.info("Y====totalPage===" + totalPage);
		// 判断下一页是不是可用
		log.info("get countModuleIdsByType size is " + ids.size());
		// if(ids!=null && ids.size()>0){
		//
		// if (size.equals(ids.size())) {
		// next = true;
		// log.info("ss "+ids.subList(0,size-1));
		// model.addAttribute("ids", ids.subList(0,size-1));
		// }else{
		// log.info("ss "+ids.subList(0,ids.size()));
		// model.addAttribute("ids", ids.subList(0, ids.size()));
		// }
		//
		// }
		//
		users = userService.getObjectsByIds(ids);
		model.addAttribute("code", 1);
		model.addAttribute("message", "success");
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", total);
		model.addAttribute("userList", users);

		return "/graship-home-service/user/json/userListJson";
	}

	// 查看用户信息
	@RequestMapping(value = "/a/user/{id}", method = RequestMethod.GET)
	public String userSeeSelf(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
			String mail, String head, @PathVariable Long id) throws Exception {

		// 根据id获取对象
		User user = userService.getObjectById(id);
		log.info("  user is" + user);

		model.addAttribute("code", 1);
		model.addAttribute("message", "success");
		model.addAttribute("user", user);

		return "/graship-home-service/user/json/userDetailmessage";
	}

	// 修改用户的个人信息1
	@RequestMapping(value = "/a/user/{id}", method = RequestMethod.PUT)
	public String updateSelf(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
			String mail, String head, String mobile, @PathVariable Long id) throws Exception {
		if (name == null && mail == null && head == null) {
			log.info("update false can't be null");
			model.addAttribute("code", -1);
			return null;
		}
		log.info("update cpy name=" + name + "mail" + mail + "head" + head);

		try {

			User user = userService.getObjectById(id);
			user.setName(name);
			user.setMail(mail);
			user.setHead(head);
			user.setMobile(mobile);
			log.info("update user and user is" + user);
			Boolean result = userService.update(user);

			model.addAttribute("code", 1);

			model.addAttribute("user", user);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 删除用户
	@RequestMapping(value = "/a/user/{id}", method = RequestMethod.DELETE)
	public String deleteUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete user : id= " + id);
		try {
			userService.delete(id);

			log.info("delete user success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete user error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	// ========================================使用服务申请===============================================

	// 使用服务申请
	@RequestMapping(value = "/a/admin/useorder", method = RequestMethod.GET)
	public String getOrderServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String userName, Integer size, Integer page, Long id, Integer applya, Integer applyb, Long createAt,
			Long endAt, Integer staus, Integer limit, String mobile, Long cpyId, String cpyName, Integer oStage,
			Long pact, Long endPact) throws Exception {

		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		if (limit == null) {
			limit = 1000086;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		log.info("get cpy regist list=" + cpyName + "applya" + applya + "applyb" + applyb);
		List<Long> ids = null;
		List<Order> orderList = null;

		try {
			// 提供服务认证的模糊查询
			Map<String, Object> param = DynamicUtil.getOrderListIds(userName, applya, applyb, createAt, endAt, mobile,
					cpyName, oStage, pact, endPact);

			// 获取serve的ids
			ids = orderService.getIdsByDynamicCondition(Order.class, param, start, size);

			// 获取总数
			log.info("get order ids param is " + param);

			List<Long> fff = orderService.getOrderIds(start, limit);
			log.info("get fff  total is " + fff);
			Integer total = fff.size();
			log.info("get order  total is " + total);

			// 获取了所有的order对象
			orderList = orderService.getObjectsByIds(ids);
			log.info("get regist serveList is " + orderList.toString());

			// 创建一个大的list来获取整个页面的内容
			List<ModulsAndOrder> modulsAndOrderList = new ArrayList<ModulsAndOrder>();

			// 获取父id
			List<Long> modulsApplyaIds = new ArrayList();
			// 获取子id
			List<Long> modulsApplybIds = new ArrayList();

			log.info("是否进入list循环");
			// 将order对象放进list里
			for (Order order : orderList) {

				// 获取子类和父类的id
				modulsApplyaIds.add(order.getApplya());
				modulsApplybIds.add(order.getApplyb());

				ModulsAndOrder modulsAndOrder = new ModulsAndOrder();

				modulsAndOrder.setOrder(order);
				modulsAndOrderList.add(modulsAndOrder);

			}
			log.info("======================== modulsAndUserList is  " + modulsAndOrderList);
			// 根据父类id获取moduls对象

			List<Moduls> modulsServeaList = modulsService.getObjectsByIds(modulsApplyaIds);
			List<Moduls> modulsServebList = modulsService.getObjectsByIds(modulsApplybIds);

			int i = 0;
			for (ModulsAndOrder modulsAndOrder : modulsAndOrderList) {

				try {
					modulsAndOrder.setModulsApplya(modulsServeaList.get(i));
					modulsAndOrder.setModulsApplyb(modulsServebList.get(i));
					i++;

				} catch (Throwable t) {
					log.error(t.getMessage());
					log.error("add profession to professionAndTagsList error,professionId is  "
							+ modulsAndOrderList.get(i));
				}

			}
			log.info("========= modulsServebList is===============  " + modulsServebList);
			model.addAttribute("code", 0);
			model.addAttribute("total", total);

			model.addAttribute("modulsAndOrderList", modulsAndOrderList);
			log.info("add profession to modulsAndUserList is  " + modulsAndOrderList.toString());

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/order/json/userOrderModulsListJson";
	}

	// 查看使用服务认证表
	@RequestMapping(value = " /a/admin/useorder/{id}", method = RequestMethod.GET)
	public String seeCpyOrder(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("cpy regist id=" + id);
		ModulsAndOrder modulsAndOrder = new ModulsAndOrder();
		// 获取认证公司的单条信息
		try {

			Order order = orderService.getObjectById(id);
			// 获取applya和applyb
			Long applya = order.getApplya();
			Long applyb = order.getApplyb();
			Long cpyid = order.getCpyId();

			// 获得moduls对象
			Moduls modulsApplya = modulsService.getObjectById(applya);
			Moduls modulsApplyb = modulsService.getObjectById(applyb);

			User user = userService.getObjectById(cpyid);

			// 将对象放进ModulsAndOrder里面
			modulsAndOrder.setOrder(order);
			modulsAndOrder.setModulsApplya(modulsApplya);
			modulsAndOrder.setModulsApplyb(modulsApplyb);
			modulsAndOrder.setUser(user);

			model.addAttribute("code", 0);

			model.addAttribute("modulsAndOrder", modulsAndOrder);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/order/json/userOrderModuls";
	}

	// 更改公司 使用服务申请
	@RequestMapping(value = "/a/admin/useorder/{id}", method = RequestMethod.PUT)
	public String updateProServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, Integer status, Long preDate) throws Exception {

		log.info("update cpy order id=" + id);

		try {
			UserServerRelation userServerRelation = userServerRelationService.getObjectById(id);

			// Order order = orderService.getObjectById(id);
			Long userId = Long
					.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			if("-1".equals(status+"")){
				//未通过
				Message message=new Message();
				if(DataUtils.isNotNullOrEmpty(userServerRelation.getUid()))
				{
				message.setUid(userServerRelation.getUid());
				}
				message.setIfRead(1);
				message.setTitle("服务申请");
				message.setContent("对不起，由于某些原因，服务申请被拒绝。");
				message.setUpdateAt(System.currentTimeMillis());
				messageService.insert(message);
			}else if("2".equals(status+"")){
				//申请通过
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				Message message=new Message();
				if(DataUtils.isNotNullOrEmpty(userServerRelation.getUid()))
				{
				message.setUid(userServerRelation.getUid());
				}
				message.setIfRead(1);
				message.setTitle("服务申请");
				Date date=new Date(preDate);
				message.setContent("恭喜您！服务申请已受理！预约时间为"+sdf.format(date)+"！");
				message.setUpdateAt(System.currentTimeMillis());
				messageService.insert(message);
				
				//更新申请企业数量
				//获取公司id和服务id
				Long companyId=userServerRelation.getCid();
				Long serverId=userServerRelation.getSid();
				if(DataUtils.isNotNullOrEmpty(companyId)&&DataUtils.isNotNullOrEmpty(serverId)){
					Map<String, Object> map = new HashMap<String, Object>();
					map = DynamicUtil.getCompanyServerByIdAndUid(companyId, serverId);
					List<Long> idList = companyServerRelationService.getIdsByDynamicCondition(CompanyServerRelation.class, map,
							0, Integer.MAX_VALUE);
					List<CompanyServerRelation> ucList = companyServerRelationService.getObjectsByIds(idList);
					if (ucList.size() > 0) {
						CompanyServerRelation companyServerRelation = ucList.get(0);
						if(DataUtils.isNotNullOrEmpty(companyServerRelation.getCountNum()))
						{
							companyServerRelation.setCountNum(companyServerRelation.getCountNum()+1);
						}else{
							companyServerRelation.setCountNum(1);
						}
						companyServerRelationService.update(companyServerRelation);
					}
				}
				
				
			}
			userServerRelation.setStatus(status);
			userServerRelation.setPreDate(preDate);
			Boolean result = userServerRelationService.update(userServerRelation);
			// 判断是否更新成功
			int code = -1;
			if (result) {
				code = 0;
				log.info("update order success");
			} else {
				log.info("update failed");
			}
			model.addAttribute("code", code);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 删除提供服务申请
	@RequestMapping(value = "/a/admin/useorder/{id}", method = RequestMethod.DELETE)
	public String deleteProServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete order : id= " + id);
		try {
			boolean code = userServerRelationService.delete(id);
			if (code == true) {
				log.info("delete order success");

				model.addAttribute("code", 0);
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete order error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	// ==============================公司认证==========================================

	// 获取公司认证列表
	@RequestMapping(value = " /a/admin/cpystatus", method = RequestMethod.GET)
	public String getCpyRegist(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer size,
			Integer page, String cpyName, String industry, String stage, String name, String mobile, Integer status,
			Long startAt, Long endAt) throws Exception {

		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("get cpy regist list=" + cpyName + "startat" + startAt + "endat" + endAt);
		List<Long> ids = null;
		List<User> userList = null;
		try {
			Map<String, Object> param = DynamicUtil.getCpyListIds(cpyName, industry, stage, name, mobile, status,
					startAt, endAt);
			log.info("get regist ids param is " + param);

			ids = userService.getIdsByDynamicCondition(User.class, param, start, size);

			Integer total = ids.size();
			log.info("the total is" + total);
			userList = userService.getObjectsByIds(ids);

			model.addAttribute("code", 0);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("userList", userList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/user/json/userListJson";
	}

	// 查看公司信息

	@RequestMapping(value = "/a/admin/cpystatus/{id}", method = RequestMethod.GET)
	public String cpystatusSeeSelf(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		// 根据id获取对象
		User user = userService.getObjectById(id);
		log.info("  user is" + user);

		model.addAttribute("code", 0);
		model.addAttribute("user", user);

		return "/graship-home-service/user/json/cpyDetailmessage";
	}

	// 更改公司认证状态 2申请1同意0未申请-1拒绝
	@RequestMapping(value = "/a/admin/cpystatus/{id}", method = RequestMethod.PUT)
	public String deleteCpyRegist(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, Integer status,Long cid) throws Exception {

		log.info("update cpy regist id=" + id);

		try {
			Company company=companyService.getObjectById(cid);
			UserCompanyRelation userCompanyRelation = userCompanyRelationService.getObjectById(id);
			userCompanyRelation.setStatus(status); 
			company.setStatus(status);
			Long userId = Long
					.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			if ("2".equals(status+"")) {
				//更新等级为L1
				log.info(status+":status");
				company.setGrade(1);
				//发送同意消息通知 
				Message message=new Message();
				if(DataUtils.isNotNullOrEmpty(company.getUid()))
				{
				message.setUid(company.getUid());
				}
				message.setIfRead(1);
				message.setTitle("合作入驻");
				message.setContent("恭喜您！合作入驻申请已通过，合作等级为L1！您可以填写并提交贵企支持的服务，审核通过后其它企业将能在本站申请到贵公司提供的服务！");
				message.setUpdateAt(System.currentTimeMillis());
				messageService.insert(message);
				
			}else if("-1".equals(status+""))
			{
				//发送审核不通通知
				Message message=new Message();
				if(DataUtils.isNotNullOrEmpty(company.getUid()))
				{
				message.setUid(company.getUid());
				}
				message.setIfRead(1);
				message.setTitle("合作入驻");
				message.setContent("对不起，贵公司提供的信息有误，合作入驻申请未能通过。");
				message.setUpdateAt(System.currentTimeMillis());
				messageService.insert(message);
			}
			userCompanyRelationService.update(userCompanyRelation);
			Boolean result = companyService.update(company);
			int code = -1;
			if (result) {
				code = 0;
				log.info("update company success");
			} else {
				log.info("update false because update false");
			}
			model.addAttribute("code", code);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 删除认证公司列表

	@RequestMapping(value = "/a/admin/cpystatus/{id}", method = RequestMethod.DELETE)
	public String deleteCpyRegist(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete user : id= " + id);
		try {
			userService.delete(id);

			log.info("delete cpy success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete user error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	// ==================================公司列表==================================================

	// 获得公司列表1
	@RequestMapping(value = "/a/admin/cpy", method = RequestMethod.GET)
	public String getCpyList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer status,
			String name, String mobile, String cpyName, String phone, String grade, boolean count, Integer page,
			Integer size, Integer limit) throws Exception {
		log.info("getCpyLIst  /a/u/cpy  to /user/view/userList");

		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		if (limit == null) {
			limit = 1000086;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		List<Long> ids = null;
		List<User> users = null;
		Integer total = null;

		Map<String, Object> param = DynamicUtil.getCpyIdsParam(cpyName, phone, name, mobile, grade, status, false);
		log.info("param is" + param);

		ids = userService.getIdsByDynamicCondition(User.class, param, start, size);
		total = ids.size();
		users = userService.getObjectsByIds(ids);
		model.addAttribute("code", 0);
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", total);
		model.addAttribute("userList", users);

		return "/graship-home-service/user/json/userListJson";
	}

	// 查看公司信息

	@RequestMapping(value = "/a/admin/cpy/{id}", method = RequestMethod.GET)
	public String cpySeeSelf(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
			String mail, String head, @PathVariable Long id) throws Exception {

		// 根据id获取对象
		User user = userService.getObjectById(id);
		log.info("  user is" + user);

		model.addAttribute("code", 0);
		model.addAttribute("user", user);

		return "/graship-home-service/user/json/cpyDetailmessage";
	}

	// 更新公司信息1
	@RequestMapping(value = "/a/admin/cpy/{uid}", method = RequestMethod.PUT)
	public String updateMyCpy(HttpServletRequest request, HttpServletResponse response, ModelMap model, String logo,
			String cpyName, String webside, String phone, String industry, Integer stage, String profile,
			String details, String name, String servers, String advantage, String advertising, @PathVariable Long uid)
			throws Exception {

		log.info("update cpyname=" + cpyName + "webside" + webside + "phone" + phone);
		try {
			User user = userService.getObjectById(uid);
			user.setName(name);
			/*
			 * user.setCpyName(cpyName); user.setWebside(webside);
			 * user.setPhone(phone); user.setIndustry(industry);
			 * user.setStage(stage); user.setProfile(profile);
			 * user.setDetails(details); user.setServers(servers);
			 * user.setAdvantage(advantage); user.setAdvertising(advertising);
			 */
			log.info("update user and user is" + user);
			Boolean result = userService.update(user);

			int code = -1;
			if (result) {
				code = 0;
				log.info("update cpy success");
				model.addAttribute("code", 0);
			} else {
				log.info("update false because update false");
				model.addAttribute("code", -1);
			}

			model.addAttribute("user", user);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 删除公司列表

	@RequestMapping(value = "/a/admin/cpy/{id}", method = RequestMethod.DELETE)
	public String deleteCpyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete user : id= " + id);
		try {
			companyService.delete(id);

			log.info("delete cpy success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete cpy error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	// ==================================提供服务认证=============================================

	// 提供服务认证表
	@RequestMapping(value = " /a/admin/proserve", method = RequestMethod.GET)
	public String getCpyServer(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer size,
			Integer page, String cpyName, Long servea, Long serveb, Long createAt, Long endAt, Integer staus,
			Integer limit) throws Exception {

		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		if (limit == null) {
			limit = 1000086;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		log.info("get cpy regist list=" + cpyName + "applya" + servea + "applyb" + serveb);
		List<Long> ids = null;
		List<Serve> serveList = null;

		try {
			// 模糊搜索（sql语句拼接）
			Map<String, Object> param = DynamicUtil.getSeaveListIds(cpyName, servea, serveb, staus, createAt, endAt);

			// 提供服务认证的模糊查询
			ids = serveService.getIdsByDynamicCondition(Serve.class, param, start, size);
			// 获取总数
			Integer total = ids.size();
			log.info("get regist total is " + ids.toArray());
			log.info("get regist ids param is " + param);
			// 获取了所有的serve对象
			serveList = serveService.getObjectsByIds(ids);
			log.info("get regist serveList is " + serveList.toString());
			// 创建一个大的list来获取整个页面的内容
			List<ModulsAndUser> modulsAndUserList = new ArrayList<ModulsAndUser>();

			// 获取serve中cpy的id
			List<User> userList = new ArrayList();
			List<Long> cpyIds = new ArrayList();
			// 获取父id
			List<Long> modulsServeaIds = new ArrayList();
			// 获取子id
			List<Long> modulsServebIds = new ArrayList();
			// 循环的将serve对象add到ModulsAndUser中
			for (Serve serve : serveList) {
				ModulsAndUser modulsAndUser = new ModulsAndUser();
				try {
					// 获取公司的id
					cpyIds.add(serve.getCpyId());
					// 获取父类id，子类id
					modulsServeaIds.add(serve.getServea());
					modulsServebIds.add(serve.getServeb());
					modulsAndUser.setServe(serve);
					modulsAndUserList.add(modulsAndUser);
				} catch (Throwable t) {
					log.error(t.getMessage());

				}

			}

			List<Moduls> modulsServea = modulsService.getObjectsByIds(modulsServeaIds);
			List<Moduls> modulsServeb = modulsService.getObjectsByIds(modulsServebIds);

			userList = userService.getObjectsByIds(cpyIds);

			// 循环的将user对象add到ModulsAndUser中
			int i = 0;
			for (ModulsAndUser modulsAndUser : modulsAndUserList) {
				//
				try {
					modulsAndUser.setModulsServea(modulsServea.get(i));
					modulsAndUser.setModulsServeb(modulsServeb.get(i));

					modulsAndUser.setUser(userList.get(i));
					i++;

				} catch (Throwable t) {
					log.error(t.getMessage());
					log.error("add profession to professionAndTagsList error,professionId is  " + userList.get(i));
				}

			}

			model.addAttribute("code", 0);
			model.addAttribute("total", total);

			model.addAttribute("modulsAndUserList", modulsAndUserList);
			log.info("add profession to modulsAndUserList is  " + modulsAndUserList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/user/json/userServeModulsListJson";
	}

	// 查看提供服务认证表
	@RequestMapping(value = " /a/admin/proserve/{id}", method = RequestMethod.GET)
	public String seeCpyServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("cpy regist id=" + id);
		ModulsAndUser modulsAndUser = new ModulsAndUser();
		// 获取认证公司的单条信息
		try {
			Serve serve = serveService.getObjectById(id);
			Long cpyid = serve.getCpyId();
			Long servea = serve.getServea();
			Long serveb = serve.getServeb();
			// 根据servea和serveb来获取moduls的name
			Moduls modulsA = modulsService.getObjectById(servea);
			Moduls modulsB = modulsService.getObjectById(serveb);
			User user = userService.getObjectById(cpyid);

			// 将信息放入modulsAndUser里面
			modulsAndUser.setModulsServea(modulsA);
			modulsAndUser.setModulsServeb(modulsB);
			modulsAndUser.setUser(user);
			modulsAndUser.setServe(serve);

			model.addAttribute("code", 0);

			model.addAttribute("modulsAndUser", modulsAndUser);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/user/json/userServeModuls";
	}

	// 更改公司提供服务认证状态 2申请1同意0未申请-1拒绝
	@RequestMapping(value = "/a/admin/proserve/{id}", method = RequestMethod.PUT)
	public String updateCpyRegist(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, Integer staus) throws Exception {

		log.info("update cpy regist id=" + id);

		try {
			Serve serve = serveService.getObjectById(id);
			serve.setStaus(staus);
			Boolean result = serveService.update(serve);
			// 判断是否更新成功
			int code = -1;
			if (result) {
				code = 0;
				log.info("delete regist success");
			} else {
				log.info("delete false because update false");
			}
			model.addAttribute("code", code);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 删除提供服务认证表
	@RequestMapping(value = "/a/admin/proserve/{id}", method = RequestMethod.DELETE)
	public String deleteCpyServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete serve : id= " + id);
		try {
			serveService.delete(id);

			log.info("delete serve success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete user error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	// ============================服务列表=====================================

	//
	// 点开父类应用
	@RequestMapping(value = "/a/admin/serve/servea", method = RequestMethod.GET)
	public String getOrderServera(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long parentId) throws Exception {

		try {

			Map<String, Object> param = DynamicUtil.getSucSeaveaList(parentId);
			// 获取serve的ids
			List<Long> serveaList = serveService.getIdsByDynamicCondition(Serve.class, param, 0, Integer.MAX_VALUE);
			log.error("serveaList  000" + serveaList.toString());

			List<Moduls> modulsList = modulsService.getObjectsByIds(serveaList);

			model.addAttribute("code", 0);
			model.addAttribute("modulsList", modulsList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("servea  error");
			model.addAttribute("code", -1);

		}

		return "/graship-home-service/serve/json/serveaListJson";
	}

	// 点开子类应用

	@RequestMapping(value = "/a/admin/serve/serveb", method = RequestMethod.POST)
	public String getOrderServerb(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long modulsA_id) throws Exception {

		try {

			// Moduls moduls = modulsService.getObjectById(parentId);

			// 拼接得到sql语句
			Map<String, Object> param = DynamicUtil.getSucSeavebList(modulsA_id);
			// 获取musuls中子类服务的id
			List<Long> modulsServebList = modulsService.getIdsByDynamicCondition(Serve.class, param, 0,
					Integer.MAX_VALUE);
			log.error("serveaList  000" + modulsServebList.toString());
			// 获取父类服务的名字
			List<Moduls> modulsList = modulsService.getObjectsByIds(modulsServebList);

			model.addAttribute("code", 0);
			model.addAttribute("modulsList", modulsList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("servea  error");
			model.addAttribute("code", -1);

		}

		return "/graship-home-service/serve/json/servebListJson";
	}

	// 获取服务商列表

	@RequestMapping(value = "/a/admin/serve", method = RequestMethod.GET)
	public String getOrderServer(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer size,
			Integer page, Long servea, Long serveb, Integer staus, Integer limit, String cpyName, Long createAt,
			Long endAt) throws Exception {

		if (page == null) {
			page = 1;

		}
		if (size == null) {
			size = 10;
		}
		if (limit == null) {
			limit = 1000086;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		List<Long> ids = null;
		List<Serve> serveList = null;

		try {
			// 提供服务认证的模糊查询
			Map<String, Object> param = DynamicUtil.getSucSeaveListIds(servea, serveb, cpyName);
			log.info(" param = " + param);
			ids = serveService.getIdsByDynamicCondition(Serve.class, param, start, size);

			if (ids.size() > 0) {
				serveList = serveService.getObjectsByIds(ids);

				List<ModulsAndUser> modulsAndUserList = new ArrayList<ModulsAndUser>();
				log.info("进入for循环");
				for (Serve serve : serveList) {

					ModulsAndUser modulsAndUser = new ModulsAndUser();
					modulsAndUser.setServe(serve);
					Moduls modulsa = modulsService.getObjectById(serve.getServea());
					modulsAndUser.setModulsServea(modulsa);
					Moduls modulsb = modulsService.getObjectById(serve.getServeb());
					modulsAndUser.setModulsServeb(modulsb);
					User user = userService.getObjectById(serve.getCpyId());
					modulsAndUser.setUser(user);
					modulsAndUserList.add(modulsAndUser);
				}
				model.addAttribute("modulsAndUserList", modulsAndUserList);
				log.info("add profession to modulsAndUserList is  " + modulsAndUserList.size());

			}
			List<Long> totalIds = serveService.getIdsByDynamicCondition(Serve.class, param, 0, Integer.MAX_VALUE);

			Integer total = totalIds.size();
			log.info("get order total is " + total);
			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get  error ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/user/json/userSuccServeModulsListJson";
	}

	// 查看提供服务认证表
	@RequestMapping(value = " /a/admin/serve/{id}", method = RequestMethod.GET)
	public String seeServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("cpy regist id=" + id);

		ModulsAndUser modulsAndUser = new ModulsAndUser();
		// 获取认证公司的单条信息
		try {

			Serve serve = serveService.getObjectById(id);
			// 获取applya和applyb
			Long servea = serve.getServea();
			Long serveb = serve.getServeb();
			Long cpyid = serve.getCpyId();

			// 获得moduls对象
			Moduls modulsApplya = modulsService.getObjectById(servea);
			Moduls modulsApplyb = modulsService.getObjectById(serveb);

			User user = userService.getObjectById(cpyid);

			// 将对象放进ModulsAndOrder里面
			modulsAndUser.setServe(serve);
			modulsAndUser.setModulsServea(modulsApplya);
			modulsAndUser.setModulsServeb(modulsApplyb);
			modulsAndUser.setUser(user);

			model.addAttribute("code", 0);
			model.addAttribute("modulsAndUser", modulsAndUser);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/graship-home-service/user/json/userServeModuls";
	}

	// 更改服务列表中的服务政策
	@RequestMapping(value = "/a/admin/favoserve/{id}", method = RequestMethod.PUT)
	public String updateFavoServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, String favo) throws Exception {

		log.info("update cpy order id=" + id);

		try {
			Serve serve = serveService.getObjectById(id);
			serve.setFavo(favo);
			Boolean result = serveService.update(serve);
			// 判断是否更新成功
			int code = -1;
			if (result) {
				code = 0;
				log.info("update favo success");
			} else {
				log.info("update false because update false");
			}
			model.addAttribute("code", code);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update  error,id is  ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	// 删除服务商列表
	@RequestMapping(value = " /a/admin/deleteserve/{uid}", method = RequestMethod.DELETE)
	public String deleteServer(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete order : id= " + id);
		try {
			serveService.delete(id);

			log.info("delete serveService success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete order error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/common/success";
	}

	// =======================================================================================

}
