package com.ptteng.graship.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.graship.admin.util.DynamicUtil;
import com.ptteng.graship.home.model.Component;
import com.ptteng.graship.home.model.Product;
import com.ptteng.graship.home.service.ProductService;
import com.ptteng.graship.home.service.UserService;
import com.qding.common.util.DataUtils;
import com.ptteng.graship.home.service.ComponentService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Product  crud
 * 
 * @author shixing
 * @Date 2017-4-5 09:01
 * 
 */
@Controller
public class ProductController {
	private static final Log log = LogFactory.getLog(ProductController.class);

	@Autowired
	private ProductService productService;

	@Autowired
	private ComponentService componentService;




    /**
	 * @descrption
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	//查询产品列表接口
	@RequestMapping(value = "/a/product/search", method = RequestMethod.GET)
	public String getproductList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size ) throws Exception {



		log.info("the url is :get to /a/u/product/search");
//		int page = 1;
//		int size = 9;
//		int start = 1;
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		List<Long> ids = null;
		List<Product> productList = new ArrayList<>();
		List<Long> totals = null;
		try {
			log.info("pageList : page= " + start + " , size=" + size);
			//拼接sql到params
			Map<String, Object> params = DynamicUtil.getproductListIds();
			log.info("the params is :" + params);
			//执行sql得到ids
			ids = productService.getIdsByDynamicCondition(Product.class, params, start, size);
			log.info("the ids is :" + ids);
			totals = productService.getIdsByDynamicCondition(Product.class, params, 0, Integer.MAX_VALUE);
			int total = totals.size();
			//通过ids得到产品列表
			productList = productService.getObjectsByIds(ids);
			model.addAttribute("code", 0);
			model.addAttribute("page",page);
			model.addAttribute("size",size);
			model.addAttribute("total",total);
			model.addAttribute("productList", productList);
		}catch (Throwable t){
			log.error(t.getMessage());
			log.error("get productList error-----------------------------");
			model.addAttribute("code",-1);
		}
		return "/graship-home-service/product/json/productListJson";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	//更改产品上下架的状态
		 @RequestMapping(value = "/a/u/product/status/{status}/{id}", method = RequestMethod.PUT)
	public String updateProductStatus(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id,@PathVariable Integer status) throws Exception {
			 log.info("id is :" + id);
			 log.info("status is :" + status);
			 //入参校验
			 if(id == null) {
				 log.error("id is null");
				 model.addAttribute("code",-1);
				 return "/common/success";
			 }
			 if(status != 0 && status != 1){
				log.error("status is not right,please checkout the incoming parameter");
				 model.addAttribute("code",-10201);
				 return "/common/success";
			 }
			 Product product = productService.getObjectById(id);
			 //检测传入id所属的产品是否存在
			 if(product == null) {
			 	log.error("the id :" + id + "product doesn't exist");
				 model.addAttribute("code",-10202);
				 return "/common/success";
			 }
			List<Long> componentIds = new ArrayList<>();
			 //更新产品状态
			try {
				//通过产品id得到组件的id
				Map<String, Object> componentParams = DynamicUtil.getComponentIdsByProductId(id);
				log.info("componentParams is :" + componentParams);
				componentIds = componentService.getIdsByDynamicCondition(Component.class, componentParams, 0,
					Integer.MAX_VALUE);
				log.info("idList size is :" + componentIds.size());
				List<Long> childComponentIdList = new ArrayList<>();
				for(Long cid : componentIds) {
					Component component = componentService.getObjectById(cid);
					List<Component> childComponentList = new ArrayList<>();
					if (component == null) {
						log.error("组件不存在");
						model.addAttribute("code", -10112);
					}
					//父类的组件状态更改，子组件的状态也跟着改变，如果组件状态是0，更改为1后，所有子组件也是变为1，反之同。
					//更改子组件的状态
					if (component.getParentId() == -1) {
						Map<String, Object> params = DynamicUtil.getChildComponentIdsByComponentId(component.getId());
						log.info("params  is :" + params);
						childComponentIdList = componentService.getIdsByDynamicCondition(Component.class, params, 0,
							Integer.MAX_VALUE);
						log.info("idList size is :" + childComponentIdList.size());
						log.info("childComponentIdList are :" + childComponentIdList);
						childComponentList = componentService.getObjectsByIds(childComponentIdList);
						log.info("componentList size is :" + childComponentList.size());
						for (Component childComponent : childComponentList) {
							childComponent.setStatus(status);
							log.info("childComponent status is :" + childComponent.getStatus());
						}
						boolean result = componentService.updateList(childComponentList);
						if (result) {
							log.info("update childComponent status success");
							model.addAttribute("code", 0);
						} else {
							log.error("update  childComponent status failed");
							model.addAttribute("code", -1);
						}
					}
					component.setStatus(status);
					boolean result1 = componentService.update(component);
					if (result1) {
						log.info("update component status success");
						model.addAttribute("code", 0);
					} else {
						log.error("update  component status failed");
						model.addAttribute("code", -1);
					}

						log.info("the product is :" + product);
						product.setStatus(status);
						boolean productResult = productService.update(product);
						if (productResult) {
							model.addAttribute("code", 0);
						} else {
							model.addAttribute("code", -1);
						}


				}
			}catch (Throwable t){
				 log.error("update product status error,and the error message is :"+t.getMessage());
				model.addAttribute("code",-1);
			 }



		log.info(" put /a/u/product  to /product/view/productList");

//		return "/graship-home-service/product/view/productList";
			 return "/common/success";
	}


	
	
	
	
	
	
	@RequestMapping(value = "/c/product/{id}", method = RequestMethod.GET)
	public String getProduct(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/product/" + id + "  to /product/view/productDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/graship-home-service/product/view/productDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/product1 ", method = RequestMethod.GET)
	public String getProductIdsByStatusOrderByCreateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Integer status) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= productService.getProductIdsByStatusOrderByCreateAt(status,start,size);
		log.info("get countProductIdsByStatusOrderByCreateAt size is " + ids.size());

			List<Product> productList = productService.getObjectsByIds(ids);
			log.info("get product data is " + productList.size());

			Integer total = productService. countProductIdsByStatusOrderByCreateAt(status);
			log.info("get product count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("productList", productList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get product list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/product/json/productListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/product/{id}", method = RequestMethod.GET)
	public String getProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Product product = productService.getObjectById(id);
			log.info("get product data is " + product);

			model.addAttribute("code", 0);

			model.addAttribute("product", product);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get product error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/product/json/productDetailJson";
	}

	@RequestMapping(value = "/a/product/{id}", method = RequestMethod.PUT)
	public String updateProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Product product) throws Exception {
		
		log.info("update product : product= " + product);
		
		try {
			
			productService.update(product);

			model.addAttribute("code", 0);

			model.addAttribute("product", product);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update product error,id is  " + product.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/product", method = RequestMethod.POST)
	public String addProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Product product) throws Exception {
		
		log.info("update product : product= " + product);
		
		try { 
			product.setId(null);

			productService.insert(product);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add product error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/product/{id}", method = RequestMethod.DELETE)
	public String deleteProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete product : id= " + id);
		try {
			productService.delete(id);

			log.info("add product success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete product error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/product", method = RequestMethod.GET)
	public String getMultiProductJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Product> productList = productService.getObjectsByIds(idList);
			log.info("get  product data is " + productList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",productList.size());

			model.addAttribute("productList", productList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get product error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/graship-home-service/product/json/productListJson";
	}
	
	
	
	
	
}

