/*
 * Decompiled with CFR 0.152.
 */
package com.qding.community.common.weixin.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.qding.common.util.TimeUtil;
import com.qding.community.common.weixin.vo.pay.CertificateList;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JsonUtils {
    private static GsonBuilder builder = new GsonBuilder();
    private static Gson gson = builder.registerTypeAdapter(Date.class, (Object)new OffsetDateTimeTypeAdapter()).create();

    public static CertificateList convertJsonToCertList(String target) {
        return (CertificateList)gson.fromJson(target, CertificateList.class);
    }

    public static void main(String[] args) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        Date date = null;
        try {
            date = df.parse("2021-01-05T17:04:28+08:00");
            System.out.println(TimeUtil.convertLong2String((Long)date.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static class OffsetDateTimeTypeAdapter
    implements JsonSerializer,
    JsonDeserializer {
        public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            try {
                String oldDate = jsonElement.getAsJsonPrimitive().getAsString();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
                Date date = df.parse(oldDate);
                return date;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }

        public JsonElement serialize(Object o, Type type, JsonSerializationContext jsonSerializationContext) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return new JsonPrimitive(sdf.format(o));
        }
    }
}

