/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import com.qding.common.util.MyMathUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeUtil {
    private static final Log log = LogFactory.getLog(TimeUtil.class);
    private static final String dateFormat1 = "yyyy-MM-dd HH:mm:ss";

    public static Date getDatebyString(String day, String dataFormat) {
        if (StringUtils.isBlank((CharSequence)day)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)dataFormat)) {
            dataFormat = dateFormat1;
        }
        SimpleDateFormat format = new SimpleDateFormat(dataFormat);
        Date date = null;
        try {
            date = format.parse(day);
        }
        catch (ParseException var5) {
            log.error((Object)"error@parse date", (Throwable)var5);
            var5.printStackTrace();
        }
        return date;
    }

    public static String convertLong2String(Long time, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date myDate = new Date(time);
        return formatter.format(myDate);
    }

    public static Integer convertHour(Long createAt) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(createAt);
        return cal.get(10);
    }

    public static Integer convertHHHour(Long createAt) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(createAt);
        return cal.get(11);
    }

    public static Long convertString2Long(String time, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = formatter.parse(time);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    public static Long convertDate2Long(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        return calendar.getTimeInMillis();
    }

    public static int getUnit(String time, String format, int circle) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = formatter.parse(time);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(circle);
    }

    public static Date convertLong2Date(Long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar.getTime();
    }

    public static Long stringToTimeMillions(String string, Locale locale) {
        if (locale == null) {
            locale = Locale.CHINA;
        }
        String[] possibleDateFormats = new String[]{dateFormat1, "yyyy-MM-dd HH:mm", "MM-dd-yyyy HH:mm:ss", "MM-dd-yyyy HH:mm:", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy HH:mm:"};
        try {
            return DateUtils.parseDate((String)string, (Locale)locale, (String[])possibleDateFormats).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getYearByCurrentTime() {
        String lastYear = "0000";
        lastYear = TimeUtil.convertLong2String(System.currentTimeMillis(), "yyyy");
        return lastYear;
    }

    public static Long getPreZeroTimeMillions(int preday) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -preday);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static Long getPreEndTimeMillions(int preday) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -preday);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis();
    }

    public static Date getDateZeroTimeMillions(Long begin) {
        Calendar calendar = Calendar.getInstance();
        Date value = new Date(begin);
        try {
            calendar.setTime(value);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        catch (Exception var4) {
            log.error((Object)"getDateZeroTimeMillions error", (Throwable)var4);
        }
        return calendar.getTime();
    }

    public static Date getYearEndDate(Long time) {
        if (null != time && !time.equals(0)) {
            Calendar calendar = Calendar.getInstance();
            Date value = new Date(time);
            try {
                calendar.setTime(value);
                calendar.set(2, 11);
                calendar.set(5, 31);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            catch (Exception var4) {
                log.error((Object)"getYearEndDate error", (Throwable)var4);
            }
            return calendar.getTime();
        }
        return null;
    }

    public static Integer getYearEndInteger(Long time) {
        if (null != time && !time.equals(0)) {
            SimpleDateFormat formate = new SimpleDateFormat("yyyyMMdd");
            Calendar calendar = Calendar.getInstance();
            Date value = new Date(time);
            try {
                calendar.setTime(value);
                calendar.set(2, 11);
                calendar.set(5, 31);
                calendar.set(11, 12);
            }
            catch (Exception var5) {
                log.error((Object)"getYearEndInteger error", (Throwable)var5);
            }
            return MyMathUtil.getInteger(formate.format(calendar.getTime()));
        }
        return null;
    }

    public static Date get2YearsAgoDate(Long time) {
        String day = TimeUtil.convertLong2String(time, "yyyy") + "0101";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        Date date = null;
        try {
            date = formatter.parse(day);
            calendar.setTime(date);
            calendar.add(1, -2);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        catch (ParseException var6) {
            log.error((Object)"get2YearsAgoDate error", (Throwable)var6);
        }
        return calendar.getTime();
    }

    public static Date getYearBeginDayZeroTimeDate(Long time) {
        if (null != time && !time.equals(0)) {
            Calendar calendar = Calendar.getInstance();
            Date value = new Date(time);
            try {
                calendar.setTime(value);
                calendar.set(2, 0);
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            catch (Exception var4) {
                log.error((Object)"getDateZeroTimeMillions error", (Throwable)var4);
            }
            return calendar.getTime();
        }
        return null;
    }

    public static Date getYearEndDayZeroTimeDate(Long time) {
        if (null != time && !time.equals(0)) {
            Calendar calendar = Calendar.getInstance();
            Date value = new Date(time);
            try {
                calendar.setTime(value);
                calendar.set(2, 11);
                calendar.set(5, 31);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            catch (Exception var4) {
                log.error((Object)"getDateZeroTimeMillions error", (Throwable)var4);
            }
            return calendar.getTime();
        }
        return null;
    }

    public static Date getDateEndTimeMillions(Long end) {
        Calendar calendar = Calendar.getInstance();
        Date value = new Date(end);
        try {
            calendar.setTime(value);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        catch (Exception var4) {
            log.error((Object)"getLongEndTimeMillions error", (Throwable)var4);
        }
        return calendar.getTime();
    }

    public static String convertDate2String(Date date, String pattern) {
        if (date == null) {
            log.error((Object)("date is null; pattern = " + pattern));
            return "";
        }
        return TimeUtil.convertLong2String(date.getTime(), pattern);
    }

    public static String cutDate(String time, String format, int circle) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = formatter.parse(time);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (circle) {
            case 1: {
                return String.valueOf(calendar.get(1));
            }
            case 2: {
                String month = calendar.get(2) < 9 ? "0" + (calendar.get(2) + 1) : "" + (calendar.get(2) + 1);
                return calendar.get(1) + month;
            }
            default: {
                return null;
            }
            case 5: 
        }
        String month = calendar.get(2) < 9 ? "0" + (calendar.get(2) + 1) : "" + (calendar.get(2) + 1);
        String day = calendar.get(5) < 10 ? "0" + calendar.get(5) : "" + calendar.get(5);
        return calendar.get(1) + month + day;
    }

    public static Date getDateZeroTime(String date) {
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        Date value = new Date();
        try {
            value = formate.parse(date);
        }
        catch (ParseException var4) {
            log.error((Object)"got error when parse dateString:", (Throwable)var4);
        }
        return value;
    }

    public static Date getDateEndTime(String date) {
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        new Date();
        try {
            Date value = formate.parse(date);
            calendar.setTime(value);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        catch (ParseException var5) {
            log.error((Object)"got error when parse dateString:", (Throwable)var5);
        }
        return calendar.getTime();
    }

    public static Long getTimeInyyyyMMddHHmmss() {
        SimpleDateFormat fullDate = new SimpleDateFormat("yyyyMMddHHmmss");
        Long updateTime = MyMathUtil.getLong(fullDate.format(new Date()));
        return updateTime;
    }

    public static Long getTimeInyyyyMMdd() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Long updateTime = MyMathUtil.getLong(dateFormat.format(date));
        return updateTime;
    }

    public static Long getTimesTodayZoreMillis() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTimeInMillis() / 1000L * 1000L;
    }

    public static Long getTimesTodayHourInMillis(Integer hour) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, hour);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTimeInMillis() / 1000L * 1000L;
    }

    public static Long getTimesTodayLastMillis() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTimeInMillis() / 1000L * 1000L;
    }

    public static Long getTimesFirstInMillisByMillis(Long times) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(times);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTimeInMillis() / 1000L * 1000L;
    }

    public static Long getDayTimesLastInMillis(Long times) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(times);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTimeInMillis() / 1000L * 1000L;
    }

    public static Long getTimesWeekmorningInMillis() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTimeInMillis() / 1000L * 1000L;
    }

    public static Long getTimesWeeknightInMillis() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(TimeUtil.getTimesWeekmorning());
        cal.add(7, 7);
        return cal.getTimeInMillis() / 1000L * 1000L;
    }

    public static Date getTimesWeekmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getTimesWeeknight() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(TimeUtil.getTimesWeekmorning());
        cal.add(7, 7);
        return cal.getTime();
    }

    public static Long getTimesMonthStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime().getTime();
    }

    public static Long getTimesMonthEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis() / 1000L * 1000L;
    }

    public static int getWeekDay() {
        Date today = new Date();
        int[] weekDays = new int[]{7, 1, 2, 3, 4, 5, 6};
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int w = c.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static int getTimeSecond(String time) {
        String[] times = time.split(":");
        return Integer.valueOf(times[0]) * 60 * 60 + Integer.valueOf(times[1]) * 60;
    }

    public static int getCurrentSecond() {
        Long zero = TimeUtil.getTimesTodayZoreMillis();
        Long ms = (System.currentTimeMillis() - zero) / 1000L;
        return ms.intValue();
    }

    public static String toDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat1);
        return sdf.format(new Date(Long.parseLong(time)));
    }

    public static boolean isSameDay(long firstTime, long secondTime) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat1);
        boolean result = false;
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTimeInMillis(firstTime);
        int y1 = calendar.get(1);
        int d1 = calendar.get(6);
        calendar2.setTimeInMillis(secondTime);
        int y2 = calendar2.get(1);
        int d2 = calendar2.get(6);
        result = y1 == y2 && d1 == d2;
        return result;
    }

    public static Long calculateTimeZone(double currentLon) {
        long t8 = System.currentTimeMillis();
        int shangValue = (int)(currentLon / 15.0);
        double yushuValue = Math.abs(currentLon % 15.0);
        int timeZone = yushuValue <= 7.5 ? shangValue : shangValue + (currentLon > 0.0 ? 1 : -1);
        return (long)((timeZone - 8) * 3600000) + t8;
    }

    public static List<Date> getDatesBetweenTwoDate(Date beginDate, Date endDate) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(beginDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!endDate.after(cal.getTime()) || DateUtils.isSameDay((Date)endDate, (Date)cal.getTime())) break;
            lDate.add(cal.getTime());
        }
        lDate.add(endDate);
        return lDate;
    }

    public static List<String> getDatesBetweenTwoDate(Long begin, Long end, String dataFormat) {
        List<Date> dateList = TimeUtil.getDatesBetweenTwoDate(new Date(begin), new Date(end));
        ArrayList<String> dateStrList = new ArrayList<String>();
        for (Date date : dateList) {
            String dateStr = TimeUtil.convertLong2String(date.getTime(), dataFormat);
            if (dateStrList.contains(dateStr)) continue;
            dateStrList.add(TimeUtil.convertLong2String(date.getTime(), dataFormat));
        }
        return dateStrList;
    }

    public static void main(String[] args) {
        Long first = System.currentTimeMillis();
        long second = first - 86400000L + 36000000L;
        boolean result = TimeUtil.isSameDay(first, second);
        log.info((Object)result);
    }
}

