/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"FileUploadUtil");
    private static final int UPLOAD_SLICE_INITIAL_CAPACITY = 128;
    private static final String SAMPLING_MD5_FILE_NAME = "JOY-LEARNING-SAMPLING-FILE-NAME";

    public static List<String> uploadedList(String sliceFileRootFolderPath) {
        ArrayList<String> uploadSliceList = new ArrayList<String>(128);
        File sliceFileRootFolder = new File(sliceFileRootFolderPath);
        if (sliceFileRootFolder.exists() && sliceFileRootFolder.isDirectory()) {
            log.info("uploadedList->sliceFileRootFolderPath={},get sliceFileRootFolder success", (Object)sliceFileRootFolderPath);
            File[] sliceFilePathArray = sliceFileRootFolder.listFiles();
            if (null != sliceFilePathArray) {
                log.info("uploadedList->sliceFileRootFolderPath={},get sliceFilePathArray success,size={}", (Object)sliceFileRootFolderPath, (Object)sliceFilePathArray.length);
                for (File sliceFile : sliceFilePathArray) {
                    if (sliceFile.isFile()) {
                        log.info("uploadedList->sliceFileRootFolderPath={},slice:[{}] is file", (Object)sliceFileRootFolderPath, (Object)sliceFile.getName());
                        uploadSliceList.add(sliceFile.getName());
                        continue;
                    }
                    log.info("uploadedList->sliceFileRootFolderPath={}", (Object)sliceFileRootFolderPath);
                }
            } else {
                log.info("uploadedList->sliceFileRootFolderPath={},get sliceFilePathArray is null", (Object)sliceFileRootFolderPath);
            }
        } else {
            log.info("uploadedList->sliceFileRootFolderPath={},get sliceFileRootFolder fail", (Object)sliceFileRootFolderPath);
        }
        return uploadSliceList;
    }

    private static boolean isFolderExists(String fileFolderPath) {
        File fileRootFolder = new File(fileFolderPath);
        if (!fileRootFolder.exists() || !fileRootFolder.isDirectory()) {
            boolean hasMkdirs = fileRootFolder.mkdirs();
            if (hasMkdirs) {
                log.info("isFolderExists->fileFolderPath={},[hasMkdirs]create dir success", (Object)fileFolderPath);
                return true;
            }
            log.info("isFolderExists->fileFolderPath={},[hasMkdirs]create dir fail", (Object)fileFolderPath);
            return false;
        }
        log.info("isFolderExists->fileFolderPath={},fileRootFolder[exists=true,isDirectory=true]", (Object)fileFolderPath);
        return true;
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean saveSliceFile(InputStream inputStream, String fileMD5RootFolderPath, String sliceFileMD5Path) {
        boolean isFolderExists = FileUploadUtil.isFolderExists(fileMD5RootFolderPath);
        if (!isFolderExists) {
            log.error("saveSliceFile->fileMD5RootFolderPath={},folder not exists,folder create fail.", (Object)fileMD5RootFolderPath);
            return false;
        }
        log.info("saveSliceFile->fileMD5RootFolderPath={},folder exists", (Object)fileMD5RootFolderPath);
        File uploadFile = new File(sliceFileMD5Path);
        try {
            byte[] data = FileUploadUtil.readInputStream(inputStream);
            try (FileOutputStream outputStream = new FileOutputStream(uploadFile);){
                outputStream.write(data);
                outputStream.flush();
            }
            catch (Exception e) {
                log.error("saveSliceFile->fileMD5RootFolderPath={},uploadFile [outputStream] write data fail", (Object)fileMD5RootFolderPath, (Object)e);
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            log.error("saveSliceFile->fileMD5RootFolderPath={},uploadFile [readInputStream] fail", (Object)fileMD5RootFolderPath, (Object)e);
            e.printStackTrace();
        }
        if (uploadFile.exists()) {
            log.info("saveSliceFile->fileMD5RootFolderPath={},uploadFile[{}] success", (Object)fileMD5RootFolderPath, (Object)sliceFileMD5Path);
            return true;
        }
        log.info("saveSliceFile->fileMD5RootFolderPath={},uploadFile[{}] fail", (Object)fileMD5RootFolderPath, (Object)sliceFileMD5Path);
        return false;
    }

    public static boolean mergeFiles(String[] sliceFilePaths, String mergeResultPath) {
        log.info("mergeFiles->sliceFilePaths size={},mergeResultPath={}", (Object)sliceFilePaths.length, (Object)mergeResultPath);
        File[] files = new File[sliceFilePaths.length];
        for (int i = 0; i < sliceFilePaths.length; ++i) {
            files[i] = new File(sliceFilePaths[i]);
            if (files[i].exists() && files[i].isFile()) continue;
            return false;
        }
        File mergeResultFile = FileUploadUtil.combineMultipleFiles(mergeResultPath, sliceFilePaths);
        if (null == mergeResultFile || mergeResultFile.length() <= 0L) {
            log.info("mergeFiles->sliceFilePaths size={},mergeResultPath={},mergeResultFile fail", (Object)sliceFilePaths.length, (Object)mergeResultPath);
            return false;
        }
        log.info("mergeFiles->sliceFilePaths size={},mergeResultPath={},mergeResultFile success", (Object)sliceFilePaths.length, (Object)mergeResultPath);
        for (int i = 0; i < sliceFilePaths.length; ++i) {
            boolean hasDel = files[i].delete();
            if (hasDel) {
                log.info("mergeFiles->files[{}]\uff0cname={} del success", (Object)i, (Object)files[i].getName());
                continue;
            }
            log.info("mergeFiles->files[{}]\uff0cname={} del fail", (Object)i, (Object)files[i].getName());
        }
        return true;
    }

    public static String[] sliceSortArray(String sliceFileRootFolderPath, String fileMD5) {
        String slicePath = sliceFileRootFolderPath + "/" + fileMD5 + "-";
        List<String> sliceList = FileUploadUtil.uploadedList(sliceFileRootFolderPath);
        if (CollectionUtils.isEmpty(sliceList)) {
            log.info("samplingMD5->sliceFileRootFolderPath={},file does not exist", (Object)sliceFileRootFolderPath);
            return null;
        }
        int sliceSize = 0;
        if (CollectionUtils.isNotEmpty(sliceList)) {
            sliceSize = sliceList.size();
        }
        String[] slicePathArray = new String[sliceSize];
        for (int i = 0; i < sliceSize; ++i) {
            slicePathArray[i] = slicePath + i;
        }
        return slicePathArray;
    }

    public static File combineMultipleFiles(String outputPath, String[] filePathArray) {
        File[] files = new File[filePathArray.length];
        for (int i = 0; i < filePathArray.length; ++i) {
            files[i] = new File(filePathArray[i]);
            if (files[i].exists() && files[i].isFile()) continue;
            return null;
        }
        File outputFile = new File(outputPath);
        try {
            FileChannel mergeOutputFileChannel = new FileOutputStream(outputFile, true).getChannel();
            for (int i = 0; i < filePathArray.length; ++i) {
                FileChannel sliceFileChannel = new FileInputStream(files[i]).getChannel();
                mergeOutputFileChannel.transferFrom(sliceFileChannel, mergeOutputFileChannel.size(), sliceFileChannel.size());
                sliceFileChannel.close();
            }
            mergeOutputFileChannel.close();
        }
        catch (IOException e) {
            log.error("combineMultipleFiles->filePathArray={},combineMultipleFiles append file fail.error={}", (Object)filePathArray, (Object)e);
            e.printStackTrace();
        }
        if (outputFile.exists() && outputFile.length() > 0L) {
            log.info("combineMultipleFiles->outputPath={} merge output file success.", (Object)outputPath);
            return outputFile;
        }
        log.info("combineMultipleFiles->outputPath={} merge output file fail.", (Object)outputPath);
        return null;
    }

    public static boolean samplingMD5(String sliceFileRootFolderPath, String fileMD5) {
        String[] slicePathArray = FileUploadUtil.sliceSortArray(sliceFileRootFolderPath, fileMD5);
        if (slicePathArray == null) {
            return false;
        }
        int slicePathArrayLength = slicePathArray.length;
        log.info("samplingMD5->fileMD5={},slicePathArray length={}", (Object)fileMD5, (Object)slicePathArrayLength);
        String[] fullAmountSlicePathArray = new String[]{slicePathArray[0]};
        if (slicePathArray.length > 1) {
            fullAmountSlicePathArray = Arrays.copyOf(fullAmountSlicePathArray, fullAmountSlicePathArray.length + 1);
            fullAmountSlicePathArray[1] = slicePathArray[slicePathArrayLength - 1];
        }
        for (String fullAmountSlicePath : fullAmountSlicePathArray) {
            log.info("samplingMD5->fileMD5={},slicePathArray fullAmountSlicePath={}", (Object)fileMD5, (Object)fullAmountSlicePath);
        }
        int middleSliceLength = Math.max(slicePathArray.length - 2, 0);
        String[] middleSlicePathArray = new String[middleSliceLength];
        if (slicePathArray.length > 2) {
            middleSlicePathArray = Arrays.copyOfRange(slicePathArray, 1, slicePathArrayLength - 1);
        }
        if (middleSlicePathArray.length > 0) {
            for (String middleSlicePath : middleSlicePathArray) {
                log.info("samplingMD5->fileMD5={},slicePathArray middleSlicePath={}", (Object)fileMD5, (Object)middleSlicePath);
            }
        }
        boolean hasFolderExists = FileUploadUtil.isFolderExists(sliceFileRootFolderPath + "/SAMPLING_MD5_FILE_FOLDER");
        log.info("samplingMD5-> slice file root folder path hasFolderExists={}", (Object)hasFolderExists);
        File samplingMD5File = new File(sliceFileRootFolderPath + "/SAMPLING_MD5_FILE_FOLDER/" + SAMPLING_MD5_FILE_NAME);
        try {
            FileChannel samplingMD5FileChannel = new FileOutputStream(samplingMD5File, true).getChannel();
            FileChannel firstSliceFileChannel = new FileInputStream(fullAmountSlicePathArray[0]).getChannel();
            samplingMD5FileChannel.transferFrom(firstSliceFileChannel, samplingMD5FileChannel.size(), firstSliceFileChannel.size());
            if (middleSlicePathArray.length > 0) {
                for (String middleSlicePath : middleSlicePathArray) {
                    FileInputStream in = new FileInputStream(middleSlicePath);
                    byte[] firstBytes = new byte[2];
                    in.read(firstBytes);
                    byte[] middleBytes = new byte[2];
                    int middleOffset = Math.toIntExact(in.getChannel().size() / 2L - 2L);
                    in.skip(middleOffset);
                    in.read(middleBytes);
                    in.skip(in.available() - 2);
                    byte[] endOffset = new byte[2];
                    in.read(endOffset);
                    samplingMD5FileChannel.write(ByteBuffer.wrap(firstBytes));
                    samplingMD5FileChannel.write(ByteBuffer.wrap(middleBytes));
                    samplingMD5FileChannel.write(ByteBuffer.wrap(endOffset));
                }
            }
            if (slicePathArrayLength > 1) {
                FileChannel lastSliceFileChannel = new FileInputStream(fullAmountSlicePathArray[1]).getChannel();
                samplingMD5FileChannel.transferFrom(lastSliceFileChannel, samplingMD5FileChannel.size(), lastSliceFileChannel.size());
            }
            samplingMD5FileChannel.close();
        }
        catch (IOException e) {
            log.error("combineMultipleFiles->filePathArray={},combineMultipleFiles append file fail.error={}", (Object)middleSlicePathArray, (Object)e);
            e.printStackTrace();
        }
        boolean samplingMD5Flag = false;
        try {
            log.info("samplingMD5->fileMD5={},samplingMD5={}", (Object)fileMD5, (Object)FileUploadUtil.getFileMD5(samplingMD5File));
            String samplingMD5 = FileUploadUtil.getFileMD5(samplingMD5File);
            if (fileMD5.equals(samplingMD5)) {
                log.info("samplingMD5->fileMD5={},samplingMD5 is same", (Object)fileMD5);
                samplingMD5Flag = true;
            } else {
                log.info("samplingMD5->fileMD5={},samplingMD5 is different", (Object)fileMD5);
            }
        }
        catch (Exception e) {
            log.error("calculation samplingMD5 error,fileMD5={}", (Object)fileMD5, (Object)e);
            e.printStackTrace();
        }
        return samplingMD5Flag;
    }

    public static String getFileMD5(File file) {
        if (!file.isFile()) {
            return null;
        }
        String md5 = null;
        try {
            HashCode hashCode = Files.hash((File)file, (HashFunction)Hashing.md5());
            md5 = hashCode.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return md5;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("/Users/rick/IdeaProjects/old/Joylearning-apiserver/tmp4upload/\u4f0a\u85e4\u8ce2\u6cbb - \u30e1\u30a4\u30f3\u30c6\u30fc\u30de\u300c\u6c38\u9060\u306e\u4e00\u77ac\u300d.mp3");
        System.out.println(FileUploadUtil.getFileMD5(file));
        FileInputStream stream = new FileInputStream(file);
    }
}

