/*
 * Decompiled with CFR 0.152.
 */
package com.qding.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static final Log log = LogFactory.getLog(FileUtil.class);

    public static Boolean validatePath(String path) {
        Boolean ret = false;
        File file = new File(path);
        if (!file.exists()) {
            ret = file.mkdirs();
        }
        return ret;
    }

    public static void writeFile(String path, boolean append, String content) {
        File myFilePath = new File(path);
        try {
            if (!myFilePath.exists()) {
                myFilePath.createNewFile();
            }
            FileWriter resultFile = new FileWriter(myFilePath, append);
            PrintWriter myFile = new PrintWriter(resultFile);
            myFile.println(content);
            resultFile.close();
        }
        catch (Exception e) {
            System.out.println("\u65b0\u5efa\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public static List<String> readFileAsList(String path) throws IOException {
        ArrayList<String> ls = new ArrayList<String>();
        FileInputStream in = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        String line = "";
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()) == null || "".equals(line)) continue;
            ls.add(line);
        }
        reader.close();
        return ls;
    }

    public static Set<String> readFileAsSet(String path) throws IOException {
        HashSet<String> set = new HashSet<String>();
        FileInputStream in = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        String line = "";
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()) == null || "".equals(line) || set.contains(line)) continue;
            set.add(line);
        }
        reader.close();
        return set;
    }

    public static String readFileAsString(String path) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileInputStream in = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        String line = "";
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()) == null || "".equals(line)) continue;
            sb.append(line);
        }
        reader.close();
        return sb.toString();
    }

    public static String readFileAsString(File file) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileInputStream in = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        String line = "";
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()) == null || "".equals(line)) continue;
            sb.append(line);
        }
        reader.close();
        return sb.toString();
    }

    public static String[] readFileAsArray(String path) throws IOException {
        String[] result = new String[]{};
        FileInputStream in = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        String line = "";
        int i = 0;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()) == null || "".equals(line)) continue;
            result[i] = line;
        }
        reader.close();
        return result;
    }

    public static List<String> readFileAsList(String path, String encode) throws IOException {
        ArrayList<String> ls = new ArrayList<String>();
        FileInputStream in = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, encode));
        String line = "";
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()) == null || "".equals(line)) continue;
            ls.add(line);
        }
        reader.close();
        return ls;
    }

    public static String readFileByCharAsString(String path, String encode) throws IOException {
        FileInputStream in = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, encode));
        StringBuffer contentbuffer = new StringBuffer();
        char[] temp = new char[1024];
        int size = 0;
        while ((size = reader.read(temp, 0, 1024)) != -1) {
            String tempstr = new String(temp, 0, size);
            contentbuffer.append(tempstr);
        }
        String content = contentbuffer.toString();
        reader.close();
        return content;
    }

    public static boolean InputStreamToFile(InputStream in, String pathname) {
        try {
            int len;
            File f = new File(pathname);
            FileOutputStream out = FileUtils.openOutputStream((File)f);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
            return true;
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    public static boolean byteArrayToFile(byte[] in, String pathname) {
        if (null == in || in.length <= 0) {
            return false;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(in);
        return FileUtil.InputStreamToFile(stream, pathname);
    }

    public static void writeFile(String path, String name, boolean append, String content) {
        File myFilePath = new File(path + "/" + name);
        try {
            boolean e = new File(path).mkdirs();
            if (e) {
                System.out.println("Directories: " + path + " created");
            }
            if (!myFilePath.exists()) {
                myFilePath.createNewFile();
            }
            FileWriter resultFile = new FileWriter(myFilePath, append);
            PrintWriter myFile = new PrintWriter(resultFile);
            myFile.println(content);
            resultFile.close();
        }
        catch (Exception var8) {
            System.out.println("\u65b0\u5efa\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            var8.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            String strDirectoy = "test";
            String strManyDirectories = "dir1/dir2/dir3";
            boolean success = new File(strDirectoy).mkdir();
            if (success) {
                System.out.println("Directory: " + strDirectoy + " created");
            }
            if (success = new File(strManyDirectories).mkdirs()) {
                System.out.println("Directories: " + strManyDirectories + " created");
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void saveImage(String imageUrl, String destinationFile) throws IOException {
        int length;
        URL url = new URL(imageUrl);
        InputStream is = url.openStream();
        FileOutputStream os = new FileOutputStream(destinationFile);
        byte[] b = new byte[2048];
        while ((length = is.read(b)) != -1) {
            ((OutputStream)os).write(b, 0, length);
        }
        is.close();
        ((OutputStream)os).close();
    }

    public static String getFileExtension(String fileName) {
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }
}

