package com.ptteng.sca.common.takeout.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.takeout.model.TakeoutComment;
import com.ptteng.common.takeout.model.TakeoutShop;
import com.ptteng.common.takeout.service.TakeoutStoreService;

import java.util.List;

/**
 * Created by Master on 2018/3/14.
 */
public class TakeoutStoreSCAClient implements TakeoutStoreService {
    private TakeoutStoreService takeoutStoreService;
    public TakeoutStoreService getTakeoutStoreService() {return takeoutStoreService; }
    public void setTakeoutStoreService (TakeoutStoreService takeoutStoreService) { this.takeoutStoreService = takeoutStoreService;}


    @Override
    public TakeoutShop getStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
      return   takeoutStoreService.getStore(mchId, storeId);
    }
    @Override
   public void updateStore(Long mchId, Long storeId, TakeoutShop takeoutShop,String platform) throws ServiceException, ServiceDaoException {
        takeoutStoreService.updateStore(mchId, storeId, takeoutShop,platform);
    }

    @Override
   public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        takeoutStoreService.onlineStore(mchId, storeId);
    }
    @Override
   public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        takeoutStoreService.offlineStore(mchId, storeId);
    }
    @Override
   public void onlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException {
        takeoutStoreService.onlineStoreByPlatform(mchId, storeId,platform);
    }
    @Override
   public void offlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException {
        takeoutStoreService.offlineStoreByPlatform(mchId, storeId,platform);
    }
    @Override
   public List<TakeoutComment> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize, int offset) throws ServiceException, ServiceDaoException {
      return  takeoutStoreService.getStoreComment(mchId, storeId,startTime,endTime,pageSize,offset);
    }
    @Override
   public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {
        takeoutStoreService.replyStoreComment(mchId, storeId,commentId,replyContent);
    }
}
