package com.ptteng.common.takeout.model.meituan;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.List;

/**
 * Author shaobo
 * 美团EPR订单
 * Created on 17-11-15
 */
public class OrderEPR implements Serializable {

    private static final long serialVersionUID = 6569865771931834147L;
    private Long orderId; //订单Id 订单长度最少20位
    private Long orderIdView;  //订单展示Id 用户下单时看到的订单号
    private String caution;  //备注
    private Long cityId;//城市id 目前暂时用不到此信息
    private Long ctime;//订单创建时间-1476160863-unix_timestamp
    private Long utime;//订单更新时间-1476160863-unix_timestamp
    private Integer daySeq;//门店当天的订单流水号 每天流水号从1开始
    private Long deliveryTime;//用户预计送达时间，“立即送达”时为0-单位:秒, 如取餐类型为到店自取，则该时间为用户自选的到店自取时间
    private String detail;//
    private Long ePoiId;// 三方的门店Id 最大长度100
    private Long poiId;// 外卖的门店id 最大长度100
    private String extras;//订单扩展信息-指的是订单所参加的优惠等信息- 参考 extras-由于赠送的菜品在外卖业务中是通过自定义文字的方式来处理的，所以可能无法直接按字段样式返回赠送菜品信息
    private Integer hasInvoiced;//是否需要发票 0-不需要， 1-需要
    private String invoiceTitle;//发票抬头
    private String taxpayerId;//发票税号
    private Boolean isFavorites;//用户是否收藏此门店
    private Boolean isPoiFirstOrder;//用户是否第一次在此门店点餐
    private Integer isThirdShipping;//是否第三方配送 	0-否，1-是
    private Double latitude;//订餐地址纬度
    private Double longitude;//订餐地址经度 	0-否，1-是
    private Integer logisticsCode;//配送方式码
    private Integer payType;//支付类型 1：货到付款；2：在线支付
    private Integer pickType;//取餐类型 0：普通取餐；1：到店取餐 该信息默认不推送，如有需求可联系开放平台工作人员开通
    private BigDecimal originalPrice;//订单原价
    private String poiAddress;//门店地址
    private String poiName;//门店名称
    private String poiPhone;//商家电话
    private String poiReceiveDetail;//商家对账详情
    private String recipientAddress	;//收货人地址
    private String recipientName	;//收货人姓名
    private String recipientPhone	;//收货人电话
    private String shipperPhone	;//配送员电话
    private BigDecimal shippingFee	;//配送费
    private Integer status	;//订单状态 字段含义：1-用户已提交订单；2-可推送到App方平台也可推送到商家；4-商家已确认；6-已配送；8-已完成；9-已取消
    private Integer quantity	;//菜品份数
    private BigDecimal total	;//订单总价 用户实际支付金额
    private String avgSendTime;//餐厅平均送餐时间，单位为分钟
    private Integer dinnersNumber;//就餐人数



    public Long getOrderId () {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }


    public Long getOrderIdView() {
        return orderIdView;
    }

    public void setOrderIdView(Long orderIdView) {
        this.orderIdView = orderIdView;
    }




    public String getCaution () {
        return caution;
    }

    public void setCaution(String caution) {
        this.caution = caution;
    }



    public Long getCityId () {
        return cityId;
    }

    public void setCityId(Long cityId) {
        this.cityId = cityId;
    }




    public Long getCtime() {
        return ctime;
    }

    public void setCtime(Long ctime) {
        this.ctime = ctime;
    }



    public Long getUtime() {
        return utime;
    }


    public void setUtime(Long utime) {
        this.utime = utime;
    }




    public Integer getDaySeq() {
        return daySeq;
    }


    public void setDaySeq(Integer daySeq) {
        this.daySeq = daySeq;
    }




    public Long getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Long deliveryTime) {
        this.deliveryTime = deliveryTime;
    }




    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getExtras() {
        return extras;
    }

    public void setExtras(String extras) {
        this.extras = extras;
    }


    public Integer getHasInvoiced() {
        return hasInvoiced;
    }

    public void setHasInvoiced(Integer hasInvoiced) {
        this.hasInvoiced = hasInvoiced;
    }



    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getTaxpayerId() {
        return taxpayerId;
    }

    public void setTaxpayerId(String taxpayerId) {
        this.taxpayerId = taxpayerId;
    }


    public Long getePoiId() {
        return ePoiId;
    }

    public void setePoiId(Long ePoiId) {
        this.ePoiId = ePoiId;
    }


    public Long getPoiId() {
        return poiId;
    }

    public void setPoiId(Long poiId) {
        this.poiId = poiId;
    }




    public Boolean getIsFavorites() {
        return isFavorites;
    }

    public void setIsFavorites(Boolean isFavorites) {
        this.isFavorites = isFavorites;
    }


    public Boolean getIsPoiFirstOrder() {
        return isPoiFirstOrder;
    }

    public void setIsPoiFirstOrder(Boolean isPoiFirstOrder) {
        this.isPoiFirstOrder = isPoiFirstOrder;
    }


    public Integer getIsThirdShipping() {
        return isThirdShipping;
    }

    public void setIsThirdShipping(Integer isThirdShipping) {
        this.isThirdShipping = isThirdShipping;
    }


    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }


    public Integer getLogisticsCode() {
        return logisticsCode;
    }

    public void setLogisticsCode(Integer logisticsCode) {
        this.logisticsCode = logisticsCode;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }


    public Integer getPickType() {
        return pickType;
    }

    public void setPickType(Integer payTypickTypepe) {
        this.pickType = pickType;
    }


    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public String getPoiAddress() {
        return poiAddress;
    }

    public void setPoiAddress(String poiAddress) {
        this.poiAddress = poiAddress;
    }

    public String getPoiName() {
        return poiName;
    }

    public void setPoiName(String poiName) {
        this.poiName = poiName;
    }

    public String getPoiPhone() {
        return poiPhone;
    }

    public void setPoiPhone(String poiPhone) {
        this.poiPhone = poiPhone;
    }

    public String getPoiReceiveDetail() {
        return poiReceiveDetail;
    }

    public void setPoiReceiveDetail(String poiReceiveDetail) {
        this.poiReceiveDetail = poiReceiveDetail;
    }

    public String getRecipientAddress() {
        return recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public String getRecipientName() {
        return recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public String getRecipientPhone() {
        return recipientPhone;
    }

    public void setRecipientPhone(String recipientPhone) {
        this.recipientPhone = recipientPhone;
    }

    public String getShipperPhone() {
        return shipperPhone;
    }

    public void setShipperPhone(String shipperPhone) {
        this.shipperPhone = shipperPhone;
    }

    public BigDecimal getShippingFee () {
        return shippingFee;
    }

    public void setShippingFee(BigDecimal shippingFee) {
        this.shippingFee = shippingFee;
    }

    public Integer getStatus () {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getQuantity () {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getDinnersNumber () {
        return dinnersNumber;
    }

    public void setDinnersNumber(Integer dinnersNumber) {
        this.dinnersNumber = dinnersNumber;
    }

    public BigDecimal getTotal () {
        return total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public String getAvgSendTime () {
        return avgSendTime;
    }

    public void setAvgSendTime(String avgSendTime) {
        this.avgSendTime = avgSendTime;
    }


}
