package com.ptteng.common.takeout.model.ele;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.BiConsumer;

public class OShop implements Serializable {

    private static final long serialVersionUID = 6569861111331225136L;
    private Long id;//店铺Id
    private String addressText;//店铺地址
    private BigDecimal agentFee;//店铺默认配送费
    private String busyLevel;//店铺营业状态
    private int cityId;//城市Id
    private String cityCode;//城市区号
    private String closeDescription;//店铺关闭的原因
    private BigDecimal deliverAmount;//起送价
    private String deliverDescription;//配送区域详情
    private String deliverGeoJson;//配送范围
    private int deliverSpent;//2周内的平均送餐时间
    private String description;//店铺描述
    private String flavors;//店铺口味
    private String imageUrl;//店铺Logo地址
    private int invoice;//是否支持开发票
    private BigDecimal invoiceMinAmount;//支持的最小发票金额
    private int isBookable;//是否支持预定(n=0表示不支持预定,7>n>=1表示支持n天内的预定）
    private String openTimeBitmap;//营业时间bitmap
    private String bookTimeBitmap;//预定时间bitmap
    private List<String> deliverTimes;//预定时间选项
    private int isOpen;//是否正在营业
    private int isPhoneHidden;//是否隐藏电话号码
    private int isPremium;//是否品牌馆餐厅
    private int isTimeEnsure;//是否支持超时赔付
    private String timeEnsureFullDescription;//超时赔付详细信息
    private BigDecimal latitude;//店铺地址坐标-纬度
    private BigDecimal longitude;//店铺地址坐标-经度
    private String mobile;//店铺接收饿了么短信的手机号码
    private BigDecimal noAgentFeeTotal;//免配送费的最低消费额度
    private List<Short> numRatings;//店铺评价的列表
    private int onlinePayment;//是否支持在线支付，0:不支持，1:支持
    private List<String> phones;//店铺的联系电话的列表
    private String promotionInfo;//店铺促销文案信息
    private int recentFoodPopularity;//最近一个月美食销量
    private String name;//店铺名称
    private String mobileUrl;//店铺手机站url
    private List<String> servingTime;//营业时间的列表
    private Boolean supportOnline;//是否支持在线订餐
    private BigDecimal packingFee;//订单打包费
    private String openId;//店铺绑定的外部ID

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAddressText() {
        return addressText;
    }

    public void setAddressText(String addressText) {
        this.addressText = addressText;
    }

    public BigDecimal getAgentFee() {
        return agentFee;
    }

    public void setAgentFee(BigDecimal agentFee) {
        this.agentFee = agentFee;
    }

    public String getBusyLevel() {
        return busyLevel;
    }

    public void setBusyLevel(String busyLevel) {
        this.busyLevel = busyLevel;
    }

    public int getCityId() {
        return cityId;
    }

    public void setCityId(int cityId) {
        this.cityId = cityId;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCloseDescription() {
        return closeDescription;
    }

    public void setCloseDescription(String closeDescription) {
        this.closeDescription = closeDescription;
    }

    public BigDecimal getDeliverAmount() {
        return deliverAmount;
    }

    public void setDeliverAmount(BigDecimal deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public String getDeliverDescription() {
        return deliverDescription;
    }

    public void setDeliverDescription(String deliverDescription) {
        this.deliverDescription = deliverDescription;
    }

    public int getDeliverSpent() {
        return deliverSpent;
    }

    public void setDeliverSpent(int deliverSpent) {
        this.deliverSpent = deliverSpent;
    }

    public String getDeliverGeoJson() {
        return deliverGeoJson;
    }

    public void setDeliverGeoJson(String deliverGeoJson) {
        this.deliverGeoJson = deliverGeoJson;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFlavors() {
        return flavors;
    }

    public void setFlavors(String flavors) {
        this.flavors = flavors;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public int getInvoice() {
        return invoice;
    }

    public void setInvoice(int invoice) {
        this.invoice = invoice;
    }

    public BigDecimal getInvoiceMinAmount() {
        return invoiceMinAmount;
    }

    public void setInvoiceMinAmount(BigDecimal invoiceMinAmount) {
        this.invoiceMinAmount = invoiceMinAmount;
    }

    public int getIsBookable() {
        return isBookable;
    }

    public void setIsBookable(int isBookable) {
        this.isBookable = isBookable;
    }

    public String getOpenTimeBitmap() {
        return openTimeBitmap;
    }

    public void setOpenTimeBitmap(String openTimeBitmap) {
        this.openTimeBitmap = openTimeBitmap;
    }

    public String getBookTimeBitmap() {
        return bookTimeBitmap;
    }

    public void setBookTimeBitmap(String bookTimeBitmap) {
        this.bookTimeBitmap = bookTimeBitmap;
    }

    public List<String> getDeliverTimes() {
        return deliverTimes;
    }

    public void setDeliverTimes(List<String> deliverTimes) {
        this.deliverTimes = deliverTimes;
    }

    public int getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(int isOpen) {
        this.isOpen = isOpen;
    }

    public int getIsPhoneHidden() {
        return isPhoneHidden;
    }

    public void setIsPhoneHidden(int isPhoneHidden) {
        this.isPhoneHidden = isPhoneHidden;
    }

    public int getIsPremium() {
        return isPremium;
    }

    public void setIsPremium(int isPremium) {
        this.isPremium = isPremium;
    }

    public int getIsTimeEnsure() {
        return isTimeEnsure;
    }

    public void setIsTimeEnsure(int isTimeEnsure) {
        this.isTimeEnsure = isTimeEnsure;
    }

    public String getTimeEnsureFullDescription() {
        return timeEnsureFullDescription;
    }

    public void setTimeEnsureFullDescription(String timeEnsureFullDescription) {
        this.timeEnsureFullDescription = timeEnsureFullDescription;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public List<Short> getNumRatings() {
        return numRatings;
    }

    public void setNumRatings(List<Short> numRatings) {
        this.numRatings = numRatings;
    }

    public BigDecimal getNoAgentFeeTotal() {
        return noAgentFeeTotal;
    }

    public void setNoAgentFeeTotal(BigDecimal noAgentFeeTotal) {
        this.noAgentFeeTotal = noAgentFeeTotal;
    }

    public int getOnlinePayment() {
        return onlinePayment;
    }

    public void setOnlinePayment(int onlinePayment) {
        this.onlinePayment = onlinePayment;
    }

    public List<String> getPhones() {
        return phones;
    }

    public void setPhones(List<String> phones) {
        this.phones = phones;
    }

    public String getPromotionInfo() {
        return promotionInfo;
    }

    public void setPromotionInfo(String promotionInfo) {
        this.promotionInfo = promotionInfo;
    }

    public int getRecentFoodPopularity() {
        return recentFoodPopularity;
    }

    public void setRecentFoodPopularity(int recentFoodPopularity) {
        this.recentFoodPopularity = recentFoodPopularity;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMobileUrl() {
        return mobileUrl;
    }

    public void setMobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public List<String> getServingTime() {
        return servingTime;
    }

    public void setServingTime(List<String> servingTime) {
        this.servingTime = servingTime;
    }

    public Boolean getSupportOnline() {
        return supportOnline;
    }

    public void setSupportOnline(Boolean supportOnline) {
        this.supportOnline = supportOnline;
    }

    public BigDecimal getPackingFee() {
        return packingFee;
    }

    public void setPackingFee(BigDecimal packingFee) {
        this.packingFee = packingFee;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }
}