package com.ptteng.common.takeout.model.ele;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


public class OOrder implements Serializable {

    private static final long serialVersionUID = 6569865771931225136L;
    private String address; //顾客送餐地址
    private LocalDateTime createdAt; //下单时间
    private LocalDateTime activeAt; //订单生效时间
    private BigDecimal deliverFee; //配送费
    private BigDecimal vipDeliveryFeeDiscount; //会员减配送费
    private LocalDateTime deliverTime; //预计送达时间
    private String description; //订单备注
    private List<OGoodsGroup> groups; //订单详细类目的列表
    private String invoice; //发票抬头
    private boolean book; //是否预订单
    private boolean onlinePaid; //是否在线支付
    private String id; //订单Id
    private Array phoneList; //顾客联系电话
    private Long shopId; //店铺Id
    private String openId; //店铺绑定的外部ID
    private String shopName; //店铺名称
    private int daySn; //店铺当日订单流水号
    private List<OOrderStatus> status; //订单状态
    private List<OOrderRefundStatus> refundStatus; //退单状态
    private int userId; //下单用户的Id
    private BigDecimal totalPrice; //订单总价，用户实际支付的金额，单位：元
    private BigDecimal originalPrice; //订单原始价格
    private String consignee; //订单收货人姓名
    private String deliveryGeo; //订单收货地址经纬度(高德地图坐标系)
    private String deliveryPoiAddress; //送餐地址
    private Boolean invoiced; //顾客是否需要发票
    private BigDecimal income; //店铺实收
    private BigDecimal serviceRate; //饿了么服务费率
    private BigDecimal serviceFee; //饿了么服务费
    private BigDecimal hongbao; //订单中红包金额
    private BigDecimal packageFee; //餐盒费
    private BigDecimal activityTotal; //订单活动总额
    private BigDecimal shopPart; //店铺承担活动费用
    private BigDecimal elemePart; //饿了么承担活动费用
    private Boolean downgraded; //降级标识
    private LocalDateTime secretPhoneExpireTime; //保护小号失效时间
    private List<OActivity> orderActivities; //订单参加活动信息
    private String invoiceType; //发票类型
    private String taxpayerId; //纳税人识别号
    private BigDecimal coldBoxFee; //冷链加价费
    private String cancelOrderDescription; //用户取消原因
    private LocalDateTime cancelOrderCreatedAt; //用户申请取消时间

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getActiveAt() {
        return activeAt;
    }

    public void setActiveAt(LocalDateTime activeAt) {
        this.activeAt = activeAt;
    }

    public BigDecimal getDeliverFee() {
        return deliverFee;
    }

    public void setDeliverFee(BigDecimal deliverFee) {
        this.deliverFee = deliverFee;
    }

    public BigDecimal getVipDeliveryFeeDiscount() {
        return vipDeliveryFeeDiscount;
    }

    public void setVipDeliveryFeeDiscount(BigDecimal vipDeliveryFeeDiscount) {
        this.vipDeliveryFeeDiscount = vipDeliveryFeeDiscount;
    }

    public LocalDateTime getDeliverTime() {
        return deliverTime;
    }

    public void setDeliverTime(LocalDateTime deliverTime) {
        this.deliverTime = deliverTime;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }



    public String getInvoice() {
        return invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public boolean isBook() {
        return book;
    }

    public void setBook(boolean book) {
        this.book = book;
    }

    public boolean isOnlinePaid() {
        return onlinePaid;
    }

    public void setOnlinePaid(boolean onlinePaid) {
        this.onlinePaid = onlinePaid;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Array getPhoneList() {
        return phoneList;
    }

    public void setPhoneList(Array phoneList) {
        this.phoneList = phoneList;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public int getDaySn() {
        return daySn;
    }

    public void setDaySn(int daySn) {
        this.daySn = daySn;
    }



    public int getUserId() {
        return userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public String getConsignee() {
        return consignee;
    }

    public void setConsignee(String consignee) {
        this.consignee = consignee;
    }

    public String getDeliveryGeo() {
        return deliveryGeo;
    }

    public void setDeliveryGeo(String deliveryGeo) {
        this.deliveryGeo = deliveryGeo;
    }

    public String getDeliveryPoiAddress() {
        return deliveryPoiAddress;
    }

    public void setDeliveryPoiAddress(String deliveryPoiAddress) {
        this.deliveryPoiAddress = deliveryPoiAddress;
    }

    public Boolean getInvoiced() {
        return invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    public BigDecimal getServiceRate() {
        return serviceRate;
    }

    public void setServiceRate(BigDecimal serviceRate) {
        this.serviceRate = serviceRate;
    }

    public BigDecimal getServiceFee() {
        return serviceFee;
    }

    public void setServiceFee(BigDecimal serviceFee) {
        this.serviceFee = serviceFee;
    }

    public BigDecimal getHongbao() {
        return hongbao;
    }

    public void setHongbao(BigDecimal hongbao) {
        this.hongbao = hongbao;
    }

    public BigDecimal getPackageFee() {
        return packageFee;
    }

    public void setPackageFee(BigDecimal packageFee) {
        this.packageFee = packageFee;
    }

    public BigDecimal getActivityTotal() {
        return activityTotal;
    }

    public void setActivityTotal(BigDecimal activityTotal) {
        this.activityTotal = activityTotal;
    }

    public BigDecimal getShopPart() {
        return shopPart;
    }

    public void setShopPart(BigDecimal shopPart) {
        this.shopPart = shopPart;
    }

    public BigDecimal getElemePart() {
        return elemePart;
    }

    public void setElemePart(BigDecimal elemePart) {
        this.elemePart = elemePart;
    }

    public Boolean getDowngraded() {
        return downgraded;
    }

    public void setDowngraded(Boolean downgraded) {
        this.downgraded = downgraded;
    }

    public LocalDateTime getSecretPhoneExpireTime() {
        return secretPhoneExpireTime;
    }

    public void setSecretPhoneExpireTime(LocalDateTime secretPhoneExpireTime) {
        this.secretPhoneExpireTime = secretPhoneExpireTime;
    }


    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getTaxpayerId() {
        return taxpayerId;
    }

    public void setTaxpayerId(String taxpayerId) {
        this.taxpayerId = taxpayerId;
    }

    public BigDecimal getColdBoxFee() {
        return coldBoxFee;
    }

    public void setColdBoxFee(BigDecimal coldBoxFee) {
        this.coldBoxFee = coldBoxFee;
    }

    public String getCancelOrderDescription() {
        return cancelOrderDescription;
    }

    public void setCancelOrderDescription(String cancelOrderDescription) {
        this.cancelOrderDescription = cancelOrderDescription;
    }

    public LocalDateTime getCancelOrderCreatedAt() {
        return cancelOrderCreatedAt;
    }

    public void setCancelOrderCreatedAt(LocalDateTime cancelOrderCreatedAt) {
        this.cancelOrderCreatedAt = cancelOrderCreatedAt;
    }

    public List<OGoodsGroup> getGroups() {
        return groups;
    }

    public void setGroups(List<OGoodsGroup> groups) {
        this.groups = groups;
    }

    public List<OActivity> getOrderActivities() {
        return orderActivities;
    }

    public void setOrderActivities(List<OActivity> orderActivities) {
        this.orderActivities = orderActivities;
    }

    public List<OOrderStatus> getStatus() {
        return status;
    }

    public void setStatus(List<OOrderStatus> status) {
        this.status = status;
    }

    public List<OOrderRefundStatus> getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(List<OOrderRefundStatus> refundStatus) {
        this.refundStatus = refundStatus;
    }
}
