package com.ptteng.common.storage.util;

import com.aliyuncs.exceptions.ClientException;
import com.qcloud.cos.*;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.*;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


/**
 * Created by liangxj on 2016/7/13.
 * 腾讯云存储
 */
public class ImgStorageTencentServiceImpl implements  ImgStorageUtil{


    private static final Log log = LogFactory
            .getLog(ImgStorageTencentServiceImpl.class);

    private String APP_ID;
    private String SECRET_ID;
    private String SECRET_KEY;
    private String bucketName;
    private String region;
    private COSClient cosClient;

    public ImgStorageTencentServiceImpl(String APP_ID, String SECRET_ID, String SECRET_KEY, String bucketName, String region){
        super();
        this.APP_ID = APP_ID;
        this.SECRET_ID = SECRET_ID;
        this.SECRET_KEY = SECRET_KEY;
        this.bucketName = bucketName;
        this.region = region;

        initClient();
    }
    public ImgStorageTencentServiceImpl(){
        super();

    }

    public void initClient(){
        log.info(" init start ");
        if(null != APP_ID){
            COSCredentials cred = new BasicCOSCredentials(SECRET_ID, SECRET_KEY);
            Region regions = new Region(region);
            ClientConfig clientConfig = new ClientConfig(regions);
            cosClient = new COSClient(cred, clientConfig);
            log.info(" init cos success: " + cosClient);



        } else {
            log.info(" init cos error: " + cosClient);
        }

    }


    /**
     *
     * @param dir 只传module
     * @param yunFileName 传文件名称
     * @param picFile 本地路径
     * @return
     * @throws IOException
     */
    @Override
    public String imgStorage(String dir, String yunFileName, String picFile) throws IOException {
        String url = null;
        log.info("dir: " + dir + ". yunFileName: " + yunFileName + ". picFile: " + picFile);
        try {
            // 指定要上传的文件
            File localFile = new File(picFile);
            // 指定要上传到 COS 上对象键
            String key = dir + yunFileName;
            log.info("bucketName: " + bucketName + ". key: " + key);
            log.info("file: " + localFile);
            // 方法1  将本地文件上传到 COS
//            PutObjectResult putObjectResult = cosClient.putObject(bucketName, key, localFile);
//            String etag = putObjectResult .getETag();  // 获取文件的 etag
//            log.info("etag : " + etag);

            // 方法2
            // 线程池大小，建议在客户端与 COS 网络充足(如使用腾讯云的 CVM，同地域上传 COS)的情况下，设置成16或32即可, 可较充分的利用网络资源
            // 对于使用公网传输且网络带宽质量不高的情况，建议减小该值，避免因网速过慢，造成请求超时。
            ExecutorService threadPool = Executors.newFixedThreadPool(16);
            // 传入一个 threadpool, 若不传入线程池, 默认 TransferManager 中会生成一个单线程的线程池。
            TransferManager transferManager = new TransferManager(cosClient, threadPool);
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
            // 本地文件上传
            Upload upload = transferManager.upload(putObjectRequest);
            // 等待传输结束（如果想同步的等待上传结束，则调用 waitForCompletion）
            UploadResult uploadResult = upload.waitForUploadResult();
            // 关闭 TransferManger
            transferManager.shutdownNow(false);

            url = "https://" + bucketName + ".cos." + region + ".myqcloud.com/" + key;
            log.info("url : " + url);
        } catch (CosServiceException serverException) {
            serverException.printStackTrace();
            log.info("CosServiceException error.");
        } catch (CosClientException clientException) {
            clientException.printStackTrace();
            log.info("CosClientException error.");
        } catch (InterruptedException interException) {
            interException.printStackTrace();
            log.info("InterruptedException error.");
        }
        return url;
    }

    @Override
    public String imgStorage(String url, int timeOneHour) throws IOException {
        return null;
    }

    @Override
    public String imgGmkerl(String dir, String yunFileName, String picFile, Map<String, String> params) throws IOException {
        return null;
    }

    @Override
    public String imgRotate(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public String imgCrop(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public Map<String, Object> getOptions(Map<String, String> options) throws IOException {
        return null;
    }

    @Override
    public Map<String, Object> getVodOptions(Map<String, String> options,boolean transcoding) throws ClientException {
        return null;
    }


    public String getAPP_ID() {
        return APP_ID;
    }

    public void setAPP_ID(String APP_ID) {
        this.APP_ID = APP_ID;
    }

    public String getSECRET_ID() {
        return SECRET_ID;
    }

    public void setSECRET_ID(String SECRET_ID) {
        this.SECRET_ID = SECRET_ID;
    }

    public String getSECRET_KEY() {
        return SECRET_KEY;
    }

    public void setSECRET_KEY(String SECRET_KEY) {
        this.SECRET_KEY = SECRET_KEY;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }


    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }


    public COSClient getCosClient() {return cosClient;}

    public void setCosClient(COSClient cosClient) {this.cosClient = cosClient;}


    public static void main(String[] args) {
        System.out.println(" start  ");

        // 1 初始化用户身份信息（secretId, secretKey）。
        String appId = "1258752615";
        String secretId = "AKIDYzd5Kb5WDoETXUlBPExVt56weGj35D2J";
        String secretKey = "KNG3f5KNI7ckhT3StCOQp3nM4bDetreG";
        String region = "ap-beijing";
        COSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region regions = new Region("ap-beijing");
        ClientConfig clientConfig = new ClientConfig(regions);
        COSClient cosClient = new COSClient(cred, clientConfig);
        String bucket = "gene-1258752615"; //存储桶名称，格式：BucketName-APPID


        try {
            // 指定要上传的文件
            File localFile = new File("/data/webs/gene-admin-web/pdf/1a4a6d07-e05b-46e9-a1e3-e0651967a800.pdf");
            // 指定要上传到 COS 上对象键
            String key = "file/test.pdf";
            // 方法1  将本地文件上传到 COS
            PutObjectResult putObjectResult = cosClient.putObject(bucket, key, localFile);
            String etag = putObjectResult .getETag();  // 获取文件的 etag


            String url = "\thttps://" + bucket + ".cos." + region + ".myqcloud.com/" + key;
            System.out.println(url);
        } catch (CosServiceException serverException) {
            serverException.printStackTrace();
        } catch (CosClientException clientException) {
            clientException.printStackTrace();
        }

    }
}
