package com.ptteng.common.storage.util;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoResponse;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoResponse;
import com.ksyun.ks3.utils.StringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;



/**
 * Created by liangxj on 2016/8/2.
 */
public class ImgStorageAliServiceImpl implements ImgStorageUtil {
    private static final Log log = LogFactory
            .getLog(ImgStorageTencentServiceImpl.class);

    //http://zhhd.oss-cn-beijing.aliyuncs.com/dd.png
    private String endpoint ;
    // accessKey请登录https://ak-console.aliyun.com/#/查看
    private String accessKeyId ;
    private String accessKeySecret;
    private String bucketName;
    private String callbackUrl;
    private OSSClient ossClient ;
    // 点播接入地域
    private String regionId  ;
    //转码模板
    private String templateGroupId;
    private DefaultAcsClient vodClient  ;


    public ImgStorageAliServiceImpl(String endpoint,String accessKeyId,String accessKeySecret,String bucketName,String url) {
        super();
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.bucketName  = bucketName;
        ossClient = new OSSClient(endpoint,accessKeyId,accessKeySecret);

        log.info(" init cos success ");
    }
    public ImgStorageAliServiceImpl(String endpoint,String accessKeyId,String accessKeySecret,String bucketName,String url,String regionId,String callbackUrl,String templateGroupId) {
        super();
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.bucketName  = bucketName;
        this.callbackUrl  = callbackUrl;
        this.regionId  = regionId;
        this.templateGroupId  = templateGroupId;
        ossClient = new OSSClient(endpoint,accessKeyId,accessKeySecret);
        log.info(" init cos success ");
    }
    public ImgStorageAliServiceImpl() {
        super();

      //  ossClient = new OSSClient(endpoint,accessKeyId,accessKeySecret);

        log.info(" init cos success ");
    }
    //每次重新初始化即可
    public void initClient(){
        log.info(" init start ");
        String regionId = this.regionId;  // 点播服务接入地域
        DefaultProfile profile = DefaultProfile.getProfile(regionId, accessKeyId, accessKeySecret);
        DefaultAcsClient vodClient = new DefaultAcsClient(profile);
        this.vodClient = vodClient;
//        ossClient = new OSSClient(endpoint,accessKeyId,accessKeySecret);

               log.info(" init cos success ");

    }

    @Override
    public String imgStorage(String dir, String yunFileName, String picFile) throws IOException {

        log.info(" bucketName = "+bucketName);
        OSSClient ossClient = new OSSClient(endpoint,accessKeyId,accessKeySecret);
        // 上传文件
        PutObjectResult putObjectResult =  ossClient.putObject(new PutObjectRequest(bucketName,yunFileName,new File(picFile)));
        log.info("  putObjectResult eTag =  " + putObjectResult.getETag());
       // System.out.println("  putObjectResult = "+putObjectResult);
        System.out.println("  eTag = " + putObjectResult.getETag());
       // System.out.println("  callbackResponseBody = "+putObjectResult.getCallbackResponseBody());


//        OSSObject object = ossClient.getObject(new GetObjectRequest(bucketName, yunFileName));
//         System.out.println("Content-Type: " + object.getObjectMetadata().getContentType());
//        displayTextInputStream(object.getObjectContent());

        String fileUrl = "http://"+bucketName+"."+endpoint+"/"+yunFileName;
        log.info(" fileUrl = "+fileUrl);
        ossClient.shutdown();
        return fileUrl;
    }

    @Override
    public String imgStorage(String url, int timeOneHour) throws IOException {
        return null;
    }

    @Override
    public String imgGmkerl(String dir, String yunFileName, String picFile, Map<String, String> params) throws IOException {
        return null;
    }

    @Override
    public String imgRotate(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public String imgCrop(String dir, String yunFileName, String picFile, String params) throws IOException {
        return null;
    }

    @Override
    public Map<String, Object> getOptions(Map<String, String> options) throws IOException {
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        long expireTime = 30;
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000;
        Date expiration = new Date(expireEndTime);
        // PostObject请求最大可支持的文件大小为5 GB，即CONTENT_LENGTH_RANGE为5*1024*1024*1024。
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem(PolicyConditions.COND_CONTENT_LENGTH_RANGE, 0, 1048576000);
        policyConds.addConditionItem(MatchMode.StartWith, PolicyConditions.COND_KEY,"");

        String postPolicy = ossClient.generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes("utf-8");
        String encodedPolicy = BinaryUtil.toBase64String(binaryData);
        String postSignature = ossClient.calculatePostSignature(postPolicy);

        Map<String, Object> respMap = new LinkedHashMap<String, Object>();
        respMap.put("accessid", accessKeyId);
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        if (options.containsKey("dir")) {
            respMap.put("dir", options.get("dir"));
        } else {
            respMap.put("dir", "");
        }

        respMap.put("host", "https://"+bucketName+"."+endpoint);
        respMap.put("expire", String.valueOf(expireEndTime / 1000));
        if (!StringUtils.isBlank(callbackUrl)) {
            JSONObject jasonCallback = new JSONObject();
            jasonCallback.put("callbackUrl", callbackUrl);
            jasonCallback.put("callbackBody","bucket=${bucket}&object=${object}&etag=${etag}&size=${size}&mimeType=${mimeType}&imageInfo.height=${imageInfo.height}&imageInfo.width=${imageInfo.width}&imageInfo.format=${imageInfo.format}");
            jasonCallback.put("callbackBodyType", "application/x-www-form-urlencoded");
            String base64CallbackBody = BinaryUtil.toBase64String(jasonCallback.toString().getBytes());
            respMap.put("callback", base64CallbackBody);
        }
        ossClient.shutdown();
        return respMap;
    }

    @Override
    public Map<String, Object> getVodOptions(Map<String, String> options,boolean transcoding) throws  ClientException {
        Map<String, Object> objectMap = new HashMap<>();
        //是否刷新
        if (org.apache.commons.lang.StringUtils.isNotBlank(MapUtils.getString(options,"videoId"))) {
            RefreshUploadVideoRequest request = new RefreshUploadVideoRequest();
            request.setVideoId(MapUtils.getString(options, "videoId"));

            RefreshUploadVideoResponse response = this.vodClient.getAcsResponse(request);
            objectMap.put("requestId", response.getRequestId());
            objectMap.put("uploadAddress", response.getUploadAddress());
            objectMap.put("uploadAuth", response.getUploadAuth());
            objectMap.put("videoId", response.getVideoId());
        }else {
            CreateUploadVideoRequest request = new CreateUploadVideoRequest();
            request.setTitle(MapUtils.getString(options, "title"));
            request.setFileName(MapUtils.getString(options, "fileName"));
            if (transcoding) {
                request.setTemplateGroupId(templateGroupId);
            }
            //UserData回调部分设置
            //消息回调设置，指定时以此为准，否则以全局设置的事件通知为准
            if (!StringUtils.isBlank(callbackUrl)) {
                //UserData，用户自定义设置参数，用户需要单独回调URL及数据透传时设置(非必须)
                JSONObject userData = new JSONObject();
                JSONObject messageCallback = new JSONObject();
                //设置回调地址
                messageCallback.put("CallbackURL", callbackUrl);
                //设置回调方式，默认为http
                messageCallback.put("CallbackType", "http");
                userData.put("MessageCallback", messageCallback.toString());
                //UserData透传数据部分设置
                //用户自定义的扩展字段，用于回调时透传返回
                //JSONObject extend = new JSONObject();
                //extend.put("MyId", "user-defined-id");
                //userData.put("Extend", extend.toJSONString());
                request.setUserData(userData.toString());
            }
            CreateUploadVideoResponse response = this.vodClient.getAcsResponse(request);
            objectMap.put("requestId", response.getRequestId());
            objectMap.put("uploadAddress", response.getUploadAddress());
            objectMap.put("uploadAuth", response.getUploadAuth());
            objectMap.put("videoId", response.getVideoId());
        }

        return objectMap;
    }


    public String getRegionId() {
        return regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public OSSClient getOssClient() {
        return ossClient;
    }

    public void setOssClient(OSSClient ossClient) {
        this.ossClient = ossClient;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getTemplateGroupId() {
        return templateGroupId;
    }

    public void setTemplateGroupId(String templateGroupId) {
        this.templateGroupId = templateGroupId;
    }

    private static void displayTextInputStream(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input,"utf-8"));
        while (true) {
            String line = reader.readLine();
            if (line == null) break;

            System.out.println("\t" + line);
        }
        System.out.println();

        reader.close();
    }

    public static void main(String[] args) {
        log.info(" start  ");
        ImgStorageAliServiceImpl tensent = new ImgStorageAliServiceImpl();
        tensent.setEndpoint("oss-cn-shanghai.aliyuncs.com");
        tensent.setAccessKeyId("LTAIEPMkD80uYm0p");
        tensent.setAccessKeySecret("vMFgog16wRsTnmbFtwBnbgJ8hcRfi6");
        tensent.setBucketName("jinxin-uk");
//        tensent.setEndpoint("zhhdoss.5818cp.cn");
//        tensent.setAccessKeyId("xCvqFmfvaySHQP1P");
//        tensent.setAccessKeySecret("1o1w4iy1FgJMJQQMmiVeyGdDzokY0m");
//        tensent.setBucketName("zhhd");
        tensent.initClient();
        try {
            String url = tensent.imgStorage("article","test5.png","C:\\Users\\liangxj\\Desktop\\hahahha.png");
            System.out.println(url);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
