/*
 * Decompiled with CFR 0.152.
 */
package com.dify.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dify.client.IDifyWorkFlowClient;
import com.dify.client.impl.DifyBaseClientImpl;
import com.dify.client.params.ParamMessage;
import com.dify.client.types.DifyWorkFlowResult;
import com.dify.client.types.WorkflowStatus;
import com.dify.routes.DifyRoutes;
import com.dify.routes.HttpMethod;
import com.dify.types.DifyException;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DifyWorkFlowClientImpl
extends DifyBaseClientImpl
implements IDifyWorkFlowClient {
    private static final Log log = LogFactory.getLog(DifyWorkFlowClientImpl.class);

    public DifyWorkFlowClientImpl(String server, String apiKey) {
        super(server, apiKey);
    }

    @Override
    public CompletableFuture<Void> runStreaming(ParamMessage message, final Consumer<DifyWorkFlowResult> consumer) {
        return this.sendStreaming(DifyRoutes.WORKFLOW_RUN, message.toMap(), new Consumer<String>(){

            @Override
            public void accept(String line) {
                JSONObject json = JSON.parseObject((String)line);
                consumer.accept(DifyWorkFlowResult.builder().event(json.getString("event")).payload(json).build());
            }
        });
    }

    @Override
    public JSONObject runBlocking(ParamMessage message) {
        try {
            String result = this.sendBlocking(DifyRoutes.WORKFLOW_RUN, message.toMap());
            return JSON.parseObject((String)result);
        }
        catch (DifyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"sendMessages", (Throwable)e);
            throw new DifyException("\u6d88\u606f\u53d1\u9001\u5f02\u5e38", 500);
        }
    }

    @Override
    public JSONObject getWorkFlowStatus(String workFlowId) {
        try {
            String result = this.requestJson(DifyRoutes.WORKFLOW_RUN.getUrl() + "/" + workFlowId, HttpMethod.GET, null, null);
            return JSON.parseObject((String)result);
        }
        catch (DifyException e) {
            log.error((Object)"getWorkFlowStatus: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"getWorkFlowStatus", (Throwable)e);
        }
        return null;
    }

    @Override
    public Boolean stopWorkFlow(String taskId, String user) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("user", user);
            String result = this.requestJson(String.format("%s/%s/stop", DifyRoutes.WORKFLOW_TASK.getUrl(), taskId), HttpMethod.POST, null, params);
            JSONObject json = JSON.parseObject((String)result);
            return "success".equals(json.getString("result"));
        }
        catch (DifyException e) {
            log.error((Object)"stopWorkFlow: {}", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"stopWorkFlow", (Throwable)e);
        }
        return false;
    }

    @Override
    public JSONObject getWorkFlowLog(String keyword, WorkflowStatus status, Integer page, Integer limit) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("keyword", keyword);
            params.put("status", status.name());
            params.put("page", page);
            params.put("limit", limit);
            String result = this.requestJson(DifyRoutes.WORKFLOW_LOGS, params, null);
            if (result == null) {
                return null;
            }
            return JSON.parseObject((String)result);
        }
        catch (DifyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"history", (Throwable)e);
            throw new DifyException("\u83b7\u53d6workflow\u65e5\u5fd7\u5f02\u5e38", 500);
        }
    }
}

