/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.admin.model.School;
import com.ptteng.academy.admin.service.SchoolService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchoolServiceImpl
extends BaseDaoServiceImpl
implements SchoolService {
    private static final Log log = LogFactory.getLog(SchoolServiceImpl.class);

    public Long insert(School school) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + school));
        if (school == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        school.setCreateAt(Long.valueOf(currentTimeMillis));
        school.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)school);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + school));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<School> insertList(List<School> schoolList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (schoolList == null ? "null" : Integer.valueOf(schoolList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(schoolList)) {
            return new ArrayList<School>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (School school : schoolList) {
            school.setCreateAt(Long.valueOf(currentTimeMillis));
            school.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(schoolList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + schoolList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(School.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(School school) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (school == null ? "null" : school.getId())));
        boolean result = false;
        if (school == null) {
            return true;
        }
        school.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)school);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + school));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + school));
        }
        return result;
    }

    public boolean updateList(List<School> schoolList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (schoolList == null ? "null" : Integer.valueOf(schoolList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(schoolList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (School school : schoolList) {
            school.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(schoolList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + schoolList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + schoolList.size()));
        return result;
    }

    public School getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        School school = null;
        if (id == null) {
            return school;
        }
        try {
            school = (School)this.dao.get(School.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return school;
    }

    public List<School> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List school = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<School>();
        }
        try {
            school = this.dao.getList(School.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (school == null ? "null" : Integer.valueOf(school.size()))));
        return school;
    }

    public List<Long> getSchoolIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSchoolIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSchoolIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSchoolIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSchoolIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

