package com.ptteng.academy.admin.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "article")
public class Article implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 8751915544773635072L;


    /**
     * 上架
     */
    public static final Integer SHELF = 1;

    /**
     * 下架
     */
    public static final Integer DROP_OFF = 2;

    /**
     * 上架banner每个年级每个平台不能超过九个
     */
    public static final Integer SHELF_NO_MORE_THAN_NINE = 8;

    /**
     * 上架商品banner最多5个
     */
    public static final Integer GOODS_SHELF_NO_MORE_THAN_FIVE = 5;


    /**
     * 推送设备，年级部已勾选
     */
    public static final Integer CHECK = 1;

    /**
     * 已删除
     */
    public static final Integer Publish_Now = 1;
    public static final Integer Publish_Future = 2;
    public static final Long Status_Deleted = 0L;

    /*
    banner类型 链接、教材, 七期下新增：商品,链接
    * */
    public static final Integer hyperLink = 1;
    public static final Integer textBook = 2;

    public static final Integer GOODS = 5;
    public static final Integer LINK = 6;


    //article类型，banner，教材
    public static final Integer banner = 1;
    public static final Integer help = 2;
    public static final Integer advertising = 3;
    //商城特殊banner 7期（下）新增
    public static final Integer storeBanner = 4;
    public static final Integer campaignBanner = 5;

    public static final Integer PLATFORM_DOUNIXUE = 1;
    public static final Integer PLATFORM_JS_CMCC = 2;

    private Long id;

    /**
     * 类型 1 banner   2 帮助信息    3 广告
     */
    private Integer type;
    /**
     * 展示位置  1学习记录   2作业    3综合测验
     */
    private String position;

    /**
     * 封面 7期 -> web封面
     */
    private String img;

    /**
     * app 首页封面 7期 -> ios封面
     */
    private String appImg;

    /**
     * 标题，新增banner没用这个入参
     */
    private String title;


    private Integer orderBy;

    /**
     * 作者，新增banner没用这个入参
     */
    private String author;

    /**
     * 来源，新增banner没用这个入参
     */
    private String source;

    /**
     * 内容
     */
    private String content;

    /**
     *
     */
    private String summary;


    private Long createBy;


    private Long updateBy;


    private Long publishat;


    private Long updateAt;


    private Long createAt;


    private Integer status = Article.DROP_OFF;

    /**
     * 推送类型
     */
    private Integer publishType = Article.Publish_Now;

    /**
     * 2 教材同步,1 链接 ,5商城类型
     */
    private Integer bannerType;


    /**
     * 设备类型 默认逗你学
     */
    private Integer platform = PLATFORM_DOUNIXUE;

    /**
     * url地址 -> android端链接
     */
    private String url;

    /**
     * 7期新增
     */

    /**
     * 小程序端链接
     */
    private String appletUrl;

    /**
     * H5对接平台链接
     */
    private String htmlFiveUrl;

    /**
     * PC对接平台链接
     */
    private String pcUrl;

    /**
     * ios端链接
     */
    private String urlIOS;


    /**
     * web端链接
     */
    private String webUrl;

    /**
     * 推送年级部 小学
     */
    private Integer primarySchool;

    /**
     * 初中
     */
    private Integer juniorHighSchool;

    /**
     * 高中
     */
    private Integer highSchool;

    /**
     * 留学
     */
    private Integer studyAbroad;

    /**
     * 推送平台web
     */
    private Integer web;

    /**
     * 推送平台ios
     */
    private Integer ios;

    /**
     * 推送平台android
     */
    private Integer android;

    /**
     * 推送平台PC
     */
    private Integer pc;

    /**
     * 推送平台H5
     */
    private Integer htmlFive;

    /**
     * 推送平台小程序
     */
    private Integer applet;

    /**
     * android 封面
     */
    private String androidImg;

    @Column(name = "url_ios")
    public String getUrlIOS() {
        return urlIOS;
    }

    public void setUrlIOS(String urlIOS) {
        this.urlIOS = urlIOS;
    }

    //阅读量，七期下新增
    private Integer readCount = 0;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "banner_type")
    public Integer getBannerType() {
        return bannerType;
    }


    public void setBannerType(Integer bannerType) {
        this.bannerType = bannerType;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "title")
    public String getTitle() {
        return title;
    }


    public void setTitle(String title) {
        this.title = title;
    }


    @Column(name = "author")
    public String getAuthor() {
        return author;
    }


    @Column(name = "orderBy")
    public Integer getOrderBy() {
        return orderBy;
    }


    public void setOrderBy(Integer orderBy) {
        this.orderBy = orderBy;
    }


    public void setAuthor(String author) {
        this.author = author;
    }

    @Column(name = "source")
    public String getSource() {
        return source;
    }


    public void setSource(String source) {
        this.source = source;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "summary")
    public String getSummary() {
        return summary;
    }


    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "publish_at")
    public Long getPublishat() {
        return publishat;
    }


    public void setPublishat(Long publishat) {
        this.publishat = publishat;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }


    @Column(name = "url")
    public String getUrl() {
        return url;
    }


    public void setUrl(String url) {
        this.url = url;
    }


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "read_count")
    public Integer getReadCount() {
        return readCount;
    }

    public void setReadCount(Integer readCount) {
        this.readCount = readCount;
    }

    @Column(name = "publish_type")
    public Integer getPublishType() {
        return publishType;
    }

    public void setPublishType(Integer publishType) {
        this.publishType = publishType;
    }

    @Column(name = "app_img")
    public String getAppImg() {
        return appImg;
    }

    public void setAppImg(String appImg) {
        this.appImg = appImg;
    }

    @Column(name = "platform")
    public Integer getPlatform() {
        return platform;
    }

    public void setPlatform(Integer platform) {
        this.platform = platform;
    }

    @Column(name = "applet_url")
    public String getAppletUrl() {
        return appletUrl;
    }

    @Column(name = "html_five_url")
    public String getHtmlFiveUrl() {
        return htmlFiveUrl;
    }

    @Column(name = "pc_url")
    public String getPcUrl() {
        return pcUrl;
    }

    @Column(name = "web_url")
    public String getWebUrl() {
        return webUrl;
    }

    @Column(name = "primary_school")
    public Integer getPrimarySchool() {
        return primarySchool;
    }

    @Column(name = "junior_high_school")
    public Integer getJuniorHighSchool() {
        return juniorHighSchool;
    }

    @Column(name = "high_school")
    public Integer getHighSchool() {
        return highSchool;
    }

    @Column(name = "study_abroad")
    public Integer getStudyAbroad() {
        return studyAbroad;
    }

    @Column(name = "web")
    public Integer getWeb() {
        return web;
    }


    @Column(name = "ios")
    public Integer getIos() {
        return ios;
    }

    @Column(name = "android")
    public Integer getAndroid() {
        return android;
    }

    @Column(name = "pc")
    public Integer getPc() {
        return pc;
    }

    @Column(name = "html_five")
    public Integer getHtmlFive() {
        return htmlFive;
    }

    @Column(name = "applet")
    public Integer getApplet() {
        return applet;
    }

    @Column(name = "android_img")
    public String getAndroidImg() {
        return androidImg;
    }

    public void setAppletUrl(String appletUrl) {
        this.appletUrl = appletUrl;
    }

    public void setHtmlFiveUrl(String htmlFiveUrl) {
        this.htmlFiveUrl = htmlFiveUrl;
    }


    public void setPcUrl(String pcUrl) {
        this.pcUrl = pcUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public void setPrimarySchool(Integer primarySchool) {
        this.primarySchool = primarySchool;
    }

    public void setJuniorHighSchool(Integer juniorHighSchool) {
        this.juniorHighSchool = juniorHighSchool;
    }

    public void setHighSchool(Integer highSchool) {
        this.highSchool = highSchool;
    }

    public void setStudyAbroad(Integer studyAbroad) {
        this.studyAbroad = studyAbroad;
    }

    public void setWeb(Integer web) {
        this.web = web;
    }

    public void setIos(Integer ios) {
        this.ios = ios;
    }

    public void setAndroid(Integer android) {
        this.android = android;
    }

    public void setPc(Integer pc) {
        this.pc = pc;
    }

    public void setHtmlFive(Integer htmlFive) {
        this.htmlFive = htmlFive;
    }

    public void setApplet(Integer applet) {
        this.applet = applet;
    }

    public void setAndroidImg(String androidImg) {
        this.androidImg = androidImg;
    }

    @Column(name = "position")
    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }
}


