package com.ptteng.academy.home.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.TimeUtil;
import com.ptteng.academy.admin.model.Constant;
import com.ptteng.academy.admin.service.ConstantService;
import com.ptteng.academy.common.model.Message;
import com.ptteng.academy.common.service.MessageService;
import com.ptteng.academy.document.model.Document;
import com.ptteng.academy.document.model.Posts;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.model.Video;
import com.ptteng.academy.document.service.DocumentService;
import com.ptteng.academy.document.service.PostsService;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.ptteng.academy.document.service.VideoService;
import com.ptteng.academy.user.model.Sign;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.model.UserOpenidRelation;
import com.ptteng.academy.user.service.SignService;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.academy.user.service.UserService;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserController {

    private static final Log userLog = LogFactory.getLog("user");

    @Resource(name = "accountConfig")
    private Map<String, String> accountConfig;
    @Autowired
    private UserService userService;
    @Autowired
    private SignService signService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private VideoService videoService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ConstantService constantService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;
    @Autowired
    private PostsService postsService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;

    //1、用户信息
    @RequestMapping(value = "/a/u/user/detail", method = RequestMethod.GET)
    public String userDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        userLog.info("get user detail");

        User user = (User) request.getAttribute("user");
        userLog.info("get uid " + user.getId());

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            //获取用户是否有新回复状态
            List<Long> allPostIds = postsService.getPostsIdsByUidOrderByCreateAt(user.getId(), 0, Integer.MAX_VALUE);
            List<Posts> allPostList = postsService.getObjectsByIds(allPostIds);
            Boolean userReply = false;
            for(Posts posts : allPostList){
                if(Posts.REPLY.equals(posts.getReplyStatus())){
                    userReply = true;
                }
            }
            model.addAttribute("userReplyStatus", userReply);



            //查询用户是否是会员，如果是，则返回会员的剩余天数
            Long endAt = 0L;
            List<Long> memeberIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(user.getId(), User.IS_MEMBER, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(memeberIds)) {
                userLog.info(" user " + user.getId() + " is not a member ");

            } else {
                user.setIsMember(User.IS_MEMBER);
                boolean updateResutl = userService.update(user);
                List<UserMemberRelation> userMemberRelations = userMemberRelationService.getObjectsByIds(memeberIds);
                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                    userLog.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()));
                    if (userMemberRelation.getEndAt().longValue() >= endAt) {
                        userLog.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt);
                        endAt = userMemberRelation.getEndAt().longValue();
                    } else {
                        userLog.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt);
                    }
                }
                userLog.info("final end at member time is : " + endAt);
                model.addAttribute("period", endAt);
            }

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get userInfo error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userDetailJson";
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    //2、修改用户信息
    @RequestMapping(value = "/a/u/user/detail", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String alias,
                             Integer grade, String img, String location) throws Exception {

        userLog.info("update user detail");

        User user = (User) request.getAttribute("user");
        userLog.info("get uid " + user.getId());

        try {
            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            if (DataUtils.isNotNullOrEmpty(alias)) {
                userLog.info("nick : " + user.getAlias() + " >>>>>>>>>> " + alias);
                user.setAlias(alias);
            }
            if (DataUtils.isNotNullOrEmpty(grade)) {
                userLog.info("grade : " + user.getGrade() + " >>>>>>>>>> " + grade);
                user.setGrade(grade);
            }
            if (DataUtils.isNotNullOrEmpty(img)) {
                userLog.info("img : " + user.getImg() + " >>>>>>>>>> " + img);
                user.setImg(img);
            }
            if (DataUtils.isNotNullOrEmpty(location)) {
                userLog.info("location : " + user.getLocation() + " >>>>>>>>>> " + location);
                user.setLocation(location);
            }
            userService.update(user);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("update user error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //修改用户密码
    @RequestMapping(value = "/a/u/password", method = RequestMethod.PUT)
    public String updateUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd, String newpwd) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        try {
            userLog.info(" user : " + uid + " want update pwd");

            if (StringUtil.isEmpty(newpwd) || StringUtils.isEmpty(pwd)) {
                userLog.info("params is null");
                model.addAttribute("code", -3003);
                return "/common/success";
            }

            String pass = PasswordUtils.encode(pwd);
            Boolean verify = user.getPwd().equals(pass);
            if (verify) {
                userLog.info(uid + " have right pwd ");

                String encodePass = PasswordUtils.encode(newpwd);
                user.setPwd(encodePass);
                boolean result = userService.update(user);

            } else {
                userLog.info(uid + " wrong pwd " + pwd);
                model.put("code", -2006);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user " + uid + " update pwd error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //3、收藏文档/视频
    @RequestMapping(value = "/a/u/collection/{id}", method = RequestMethod.PUT)
    public String collection(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                             Integer status, Integer type) throws Exception {
        Long relationId = 0L;
        Video video = new Video();
        Document document = new Document();
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        userLog.info("user : " + uid + " set collection : type = " + type + " id = " + id + " status = " + status);

        try {
            if (DataUtils.isNullOrEmpty(status) || DataUtils.isNullOrEmpty(type)) {
                userLog.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            //校验收藏对象是否存在
            if (UserFavoriteRelation.TARGET_TYPE_DOCUMENT.equals(type)) {
                document = documentService.getObjectById(id);
                if (null == document) {
                    userLog.info("document not exist");
                    model.addAttribute("code", -2104);
                    return "/common/success";
                } else {
                    userLog.info("get target document success");
                }
            } else if (UserFavoriteRelation.TARGET_TYPE_VIDEO.equals(type)) {
                video = videoService.getObjectById(id);
                if (null == video) {
                    userLog.info("video not exist");
                    model.addAttribute("code", -2105);
                    return "/common/success";
                } else {
                    userLog.info("get target document success");
                }
            } else {
                userLog.info("type illegal");
                model.addAttribute("code", -2100);
                return "/common/success";
            }

            if (UserFavoriteRelation.STATUS_PASSIVE.equals(status)) {
                userLog.info("==========取消收藏==========");
                relationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(id,
                        uid, type, UserFavoriteRelation.TYPE_COLLECTION);
                if (null == relationId) {
                    userLog.info("favorite relation not exist");
                    model.addAttribute("code", -2101);
                    return "/common/success";
                } else {
                    userLog.info("user " + uid + " collection " + id + " relation " + relationId + " exist");
                    UserFavoriteRelation relation = userFavoriteRelationService.getObjectById(relationId);
                    if (UserFavoriteRelation.STATUS_PASSIVE.equals(relation.getStatus())) {
                        userLog.info("relation " + relationId + " exist , but status passive");
                        model.addAttribute("code", -2101);
                        return "/common/success";
                    } else {
                        relation.setStatus(UserFavoriteRelation.STATUS_PASSIVE);
                        userFavoriteRelationService.update(relation);
                        userLog.info("cancel collection success");
                    }
                }

                if (UserFavoriteRelation.TARGET_TYPE_DOCUMENT.equals(type)) {
                    Long collectionCount = document.getCollection();
                    document.setCollection(collectionCount-1);
                    userLog.info("document : " + id + " collection : " + collectionCount + " >>>>>>>>>> " + document.getCollection());
                    documentService.update(document);
                }else {
                    Long collectionCount = video.getCollection();
                    video.setCollection(collectionCount-1);
                    userLog.info("video : " + id + " collection : " + collectionCount + " >>>>>>>>>> " + video.getCollection());
                    videoService.update(video);
                }

            } else if (UserFavoriteRelation.STATUS_ACTIVE.equals(status)) {
                userLog.info("==========收藏==========");
                relationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(id,
                        uid, type, UserFavoriteRelation.TYPE_COLLECTION);
                if (null != relationId) {
                    userLog.info("user " + uid + " collection " + id + " relation " + relationId + " exist");
                    UserFavoriteRelation relation = userFavoriteRelationService.getObjectById(relationId);
                    if (UserFavoriteRelation.STATUS_ACTIVE.equals(relation.getStatus())) {
                        userLog.info("favorite relation : " + relationId + " already exist");
                        model.addAttribute("code", -2102);
                        return "/common/success";
                    } else {
                        relation.setStatus(UserFavoriteRelation.STATUS_ACTIVE);
                        userFavoriteRelationService.update(relation);
                        userLog.info("collection success");
                    }
                } else {
                    UserFavoriteRelation userFavoriteRelation = new UserFavoriteRelation();
                    userFavoriteRelation.setUid(uid);
                    userFavoriteRelation.setTargetType(type);
                    userFavoriteRelation.setTargetId(id);
                    userFavoriteRelation.setStatus(UserFavoriteRelation.STATUS_ACTIVE);
                    userFavoriteRelation.setType(UserFavoriteRelation.TYPE_COLLECTION);
                    userFavoriteRelationService.insert(userFavoriteRelation);
                    userLog.info("collection success");
                }

                if (UserFavoriteRelation.TARGET_TYPE_DOCUMENT.equals(type)) {
                    Long collectionCount = document.getCollection();
                    document.setCollection(collectionCount+1);
                    userLog.info("document : " + id + " collection : " + collectionCount + " >>>>>>>>>> " + document.getCollection());
                    documentService.update(document);
                }else {
                    Long collectionCount = video.getCollection();
                    video.setCollection(collectionCount+1);
                    userLog.info("video : " + id + " collection : " + collectionCount + " >>>>>>>>>> " + video.getCollection());
                    videoService.update(video);
                }

            } else {
                userLog.info("status illegal");
                model.addAttribute("code", -2103);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + uid + " set collection : type = " + type + " id = " + id + " status = " + status + " error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //4、点赞文档/视频
    @RequestMapping(value = "/a/u/like/{id}", method = RequestMethod.PUT)
    public String like(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                       Integer status, Integer type) throws Exception {
        Long relationId = 0L;
        Video video = new Video();
        Document document = new Document();
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        userLog.info("user : " + uid + " set like : type = " + type + " id = " + id + " status = " + status);

        try {
            if (DataUtils.isNullOrEmpty(status) || DataUtils.isNullOrEmpty(type)) {
                userLog.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            //校验收藏对象是否存在
            if (UserFavoriteRelation.TARGET_TYPE_DOCUMENT.equals(type)) {
                document = documentService.getObjectById(id);
                if (null == document) {
                    userLog.info("document not exist");
                    model.addAttribute("code", -2104);
                    return "/common/success";
                } else {
                    userLog.info("get target document success");
                }
            } else if (UserFavoriteRelation.TARGET_TYPE_VIDEO.equals(type)) {
                video = videoService.getObjectById(id);
                if (null == video) {
                    userLog.info("video not exist");
                    model.addAttribute("code", -2105);
                    return "/common/success";
                } else {
                    userLog.info("get target document success");
                }
            } else {
                userLog.info("type illegal");
                model.addAttribute("code", -2100);
                return "/common/success";
            }

            if (UserFavoriteRelation.STATUS_PASSIVE.equals(status)) {
                userLog.info("==========取消点赞==========");
                relationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(id,
                        uid, type, UserFavoriteRelation.TYPE_LIKE);
                if (null == relationId) {
                    userLog.info("like relation not exist");
                    model.addAttribute("code", -2101);
                    return "/common/success";
                } else {
                    userLog.info("user " + uid + " like " + id + " relation " + relationId + " exist");
                    UserFavoriteRelation relation = userFavoriteRelationService.getObjectById(relationId);
                    if (UserFavoriteRelation.STATUS_PASSIVE.equals(relation.getStatus())) {
                        userLog.info("relation " + relationId + " exist , but status passive");
                        model.addAttribute("code", -2101);
                        return "/common/success";
                    } else {
                        relation.setStatus(UserFavoriteRelation.STATUS_PASSIVE);
                        userFavoriteRelationService.update(relation);
                        userLog.info("cancel like success");
                    }
                }

                if (UserFavoriteRelation.TARGET_TYPE_DOCUMENT.equals(type)) {
                    Long loveCount = document.getLove();
                    document.setLove(loveCount-1);
                    userLog.info("document : " + id + " love : " + loveCount + " >>>>>>>>>> " + document.getLove());
                    documentService.update(document);
                }else {
                    Long loveCount = video.getLove();
                    video.setLove(loveCount-1);
                    userLog.info("video : " + id + " love : " + loveCount + " >>>>>>>>>> " + video.getLove());
                    videoService.update(video);
                }

            } else if (UserFavoriteRelation.STATUS_ACTIVE.equals(status)) {
                userLog.info("==========点赞==========");
                relationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(id,
                        uid, type, UserFavoriteRelation.TYPE_LIKE);
                if (null != relationId) {
                    userLog.info("user " + uid + " like " + id + " relation " + relationId + " exist");
                    UserFavoriteRelation relation = userFavoriteRelationService.getObjectById(relationId);
                    if (UserFavoriteRelation.STATUS_ACTIVE.equals(relation.getStatus())) {
                        userLog.info("like relation : " + relationId + " already exist");
                        model.addAttribute("code", -2102);
                        return "/common/success";
                    } else {
                        relation.setStatus(UserFavoriteRelation.STATUS_ACTIVE);
                        userFavoriteRelationService.update(relation);
                        userLog.info("cancel like success");
                    }
                } else {
                    UserFavoriteRelation userFavoriteRelation = new UserFavoriteRelation();
                    userFavoriteRelation.setUid(uid);
                    userFavoriteRelation.setTargetType(type);
                    userFavoriteRelation.setTargetId(id);
                    userFavoriteRelation.setStatus(UserFavoriteRelation.STATUS_ACTIVE);
                    userFavoriteRelation.setType(UserFavoriteRelation.TYPE_LIKE);
                    userFavoriteRelationService.insert(userFavoriteRelation);
                    userLog.info("like success");
                }

                if (UserFavoriteRelation.TARGET_TYPE_DOCUMENT.equals(type)) {
                    Long loveCount = document.getLove();
                    document.setLove(loveCount+1);
                    userLog.info("document : " + id + " love : " + loveCount + " >>>>>>>>>> " + document.getLove());
                    documentService.update(document);
                }else {
                    Long loveCount = video.getLove();
                    video.setLove(loveCount+1);
                    userLog.info("video : " + id + " love : " + loveCount + " >>>>>>>>>> " + video.getLove());
                    videoService.update(video);
                }

            } else {
                userLog.info("status illegal");
                model.addAttribute("code", -2103);
                return "/common/success";
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + uid + " set like : type = " + type + " id = " + id + " status = " + status + " error");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //12、用户收藏文档列表
    @RequestMapping(value = "/a/u/document/collection/list", method = RequestMethod.GET)
    public String getCollectionDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {

        List<Long> documentIds = new ArrayList<>();
        List<Document> documents = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        userLog.info("user : " + uid + " get favorite list");

        try {
            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            userLog.info("=====获取收藏课程列表id=====");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (uid, UserFavoriteRelation.TARGET_TYPE_DOCUMENT, UserFavoriteRelation.TYPE_COLLECTION,
                            UserFavoriteRelation.STATUS_ACTIVE, firstNmuber, size);
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    documentIds.add(userFavoriteRelation.getTargetId());
                }
            }
            userLog.info("collection documentIds : " + documentIds);

            if (CollectionUtils.isNotEmpty(documentIds)) {
                documents = documentService.getObjectsByIds(documentIds);
            } else {
                userLog.info("no collection document");
            }

            totalIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (uid, UserFavoriteRelation.TARGET_TYPE_DOCUMENT, UserFavoriteRelation.TYPE_COLLECTION,
                            UserFavoriteRelation.STATUS_ACTIVE, 0, Integer.MAX_VALUE);

            userLog.info("   total = " + totalIds.size());
            Integer totalPage = (((totalIds.size() - 1)) / size) + 1;
            userLog.info("   totalPage = " + totalPage);

            if(totalPage > page){
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("documentList", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get collection document error ");
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/document/json/documentListJson";
    }


    //12、用户收藏视频列表
    @RequestMapping(value = "/a/u/video/collection/list", method = RequestMethod.GET)
    public String getCollectionVideo(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {

        List<Long> videoIds = new ArrayList<>();
        List<Video> videos = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        userLog.info("user : " + uid + " get favorite list");

        try {
            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            userLog.info("=====获取收藏课程列表id=====");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (uid, UserFavoriteRelation.TARGET_TYPE_VIDEO, UserFavoriteRelation.TYPE_COLLECTION,
                            UserFavoriteRelation.STATUS_ACTIVE, firstNmuber, size);
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    videoIds.add(userFavoriteRelation.getTargetId());
                }
            }
            userLog.info("collection videoIds : " + videoIds);

            if (CollectionUtils.isNotEmpty(videoIds)) {
                videos = videoService.getObjectsByIds(videoIds);
            } else {
                userLog.info("no collection video");
            }

            totalIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (uid, UserFavoriteRelation.TARGET_TYPE_VIDEO, UserFavoriteRelation.TYPE_COLLECTION,
                            UserFavoriteRelation.STATUS_ACTIVE, 0, Integer.MAX_VALUE);

            userLog.info("   total = " + totalIds.size());
            Integer totalPage = (((totalIds.size() - 1)) / size) + 1;
            userLog.info("   totalPage = " + totalPage);

            if(totalPage > page){
                next = true;
            }


            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("videoList", videos);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get collection video error ");
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/video/json/videoListJson";
    }

    //14、签到
    @RequestMapping(value = "/a/u/user/sign", method = RequestMethod.PUT)
    public String sign(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        userLog.info("get uid " + uid);

        userLog.info("user : " + uid + " sign");

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            userLog.info("=====判断当天是否签到=====");
            Long now = System.currentTimeMillis();
            Long signId = signService.getSignIdByUidAndSignDate(uid, MyTimeUtil.getStartTime(now));
            if (null != signId) {
                user.setSign(User.SIGN);
                userService.update(user);
                userLog.info("already sign today");
                model.addAttribute("code", -2017);
                return "/common/success";
            } else {
                userLog.info("user not sign");
            }

            Integer signStatus = user.getSign();
            userLog.info("user sign is : " + signStatus);

            userLog.info("=====插入用户签到记录=====");
            Sign signRecord = new Sign();
            signRecord.setUid(uid);
            signRecord.setSignAt(now);
            signRecord.setSignDate(MyTimeUtil.getStartTime(now));
            userLog.info("insert sign record : " + signRecord);
            signService.insert(signRecord);

            userLog.info("=====修改连续签到次数=====");
            //查询昨天是否签到，决定当前连续签到次数
            Long yDayZero = MyTimeUtil.getPreZeroTimeMillions(1);
            userLog.info("yesterday zero time : " + yDayZero);
            Long yDaySignId = signService.getSignIdByUidAndSignDate(uid, yDayZero);
            if (null == yDaySignId) {
                userLog.info("not continue sign");
                user.setConsecutive(1);
            } else {
                userLog.info("continue sign");
                Integer consecutive = user.getConsecutive();
                user.setConsecutive(consecutive + 1);
                userLog.info("user consecutive : " + consecutive + " >>>>>>>>>> " + user.getConsecutive());
            }

            userLog.info("=====修改历史最高签到记录=====");
            //根据当前连续签到次数与历史最高签到次数比较，确定是否更新历史最高签到记录
            Integer signHighest = user.getSignHighest();
            userLog.info("user signHighest : " + signHighest);
            userLog.info(user.getConsecutive() + " " + signHighest);
            if (user.getConsecutive() > signHighest) {
                user.setSignHighest(user.getConsecutive());
                userLog.info("user consecutive : " + signHighest + " >>>>>>>>>> " + user.getSignHighest());
            } else {
                userLog.info("user consecutive less than signHighest");
            }

            //获取学习星数按当前连续签到次数计算
            Integer addScore = user.getConsecutive();
            if (addScore > 5) {
                addScore = 5;
            }

            Long score = user.getScore();
            user.setScore(score + addScore);
            userLog.info("user score : " + score + " >>>>>>>>>> " + user.getScore());
            user.setSign(User.SIGN);

            Integer signTotal = user.getSignTotal();
            user.setSignTotal(signTotal + 1);
            userLog.info("user signTotal : " + signTotal + " >>>>>>>>>> " + user.getSignTotal());

            userService.update(user);

            //这是一个垃圾的单发短信。。。。
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format(new Date(System.currentTimeMillis()));
            String title = "获得逆袭豆通知";
            String content = "您已完成签到，获得" + addScore + "颗逆袭豆。";

            Message message = new Message();
            message.setType(Message.Type_pesson);
            message.setName(title);
            message.setContent(content);
            message.setUserId(uid);
            message.setPublishAt(System.currentTimeMillis());
            message.setSort(1);
            messageService.insert(message);
            userLog.info("send message success");

            model.addAttribute("code", 0);
            model.addAttribute("score", addScore);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + uid + " sign error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/signInfo";
    }


    //14、用户签到信息
    @RequestMapping(value = "/a/u/user/sign/list", method = RequestMethod.GET)
    public String signInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, String year, String month) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        Integer signTotal = user.getSignTotal();
        userLog.info("get uid " + uid);
        userLog.info("get signTotal" + signTotal);

        model.addAttribute("signTotal",signTotal);

        userLog.info("get user : " + uid + " " + year + "-" + month + " sign list");

        if (StringUtil.isEmpty(year) || StringUtil.isEmpty(month)) {
            userLog.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            Date inDate = new Date();

            try {
                if (Integer.valueOf(month) < 10) {
                    month = "0" + month;
                }
                String date = year + month + "01000000";
                DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                inDate = dateFormat.parse(date);

            } catch (Exception e) {
                userLog.error(e.getMessage());
                userLog.info("wrong date format");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            DateFormat weekFormat = new SimpleDateFormat("E");
            DateFormat dayFormat = new SimpleDateFormat("dd");
            Date monthBegin = TimeUtil.getMonthBegin(inDate);
            Date monthEnd = TimeUtil.getMonthEnd(inDate);
            String week = weekFormat.format(monthBegin);
            String day = dayFormat.format(monthEnd);
            userLog.info("the first day week of month : " + week + " , the day number of month : " + day);
            model.addAttribute("week", week);
            model.addAttribute("dayCount", day);

            //查询昨天是否签到，决定当前连续签到次数
            Long yDayZero = MyTimeUtil.getPreZeroTimeMillions(1);
            Long tDayZero = MyTimeUtil.getPreZeroTimeMillions(0);
            Long yDaySignId = signService.getSignIdByUidAndSignDate(uid, yDayZero);
            Long tDaySignId = signService.getSignIdByUidAndSignDate(uid, tDayZero);
            userLog.info("yesterday sign id : " + yDaySignId + " , today sign id : " + tDaySignId);

            if (null == yDaySignId && null == tDaySignId) {
                userLog.info("not continue sign");
                user.setConsecutive(0);
                userService.update(user);
                userLog.info("update user consecutive : 0 ");
            } else {
                userLog.info("continue sign : " + user.getConsecutive());
            }
            model.addAttribute("continue", user.getConsecutive());

            Map<Long, String> id_signDay = new HashMap();
            List<Integer> signDayList = new ArrayList<>();
            userLog.info("monthBegin.getTime() is :"+monthBegin.getTime());
            userLog.info("monthEnd.getTime() is :"+monthEnd.getTime());
            List<Long> signIds = signService.getSignIdsByUidAndSignDateAreaOrderBySignDateAsc(uid, monthBegin.getTime(), monthEnd.getTime());
            userLog.info("sign id size : " + signIds.size());
            List<Sign> signs = signService.getObjectsByIds(signIds);

            String signDay = "";
            for (Sign sign : signs) {
                signDay = dayFormat.format(sign.getSignDate());
                id_signDay.put(sign.getId(), signDay);

                Integer dayDate = Integer.valueOf(signDay);
                signDayList.add(dayDate);
            }

            List<Integer> signList = new ArrayList<>();
            Integer dayCountInt = Integer.valueOf(day);
            for (int i = 1; i <= dayCountInt; i++) {
                if (signDayList.contains(i)) {
                    signList.add(1);
                } else {
                    signList.add(0);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("signIds", signIds);
            model.addAttribute("signList", signList);
            model.addAttribute("id_signDay", id_signDay);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("user : " + uid + " sign error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userSignList";
    }




    //15、其他用户信息
    @RequestMapping(value = "/a/u/user/detail/{id}", method = RequestMethod.GET)
    public String otherUserDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        userLog.info("get user " + id + " detail");

        try {
            User user = userService.getObjectById(id);
            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            Long endAt = 0L;

            model.addAttribute("code", 0);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get userInfo error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/otherUserDetailJson";
    }




    //12、其他用户收藏文档列表
    @RequestMapping(value = "/a/u/document/collection/list/{id}", method = RequestMethod.GET)
    public String getOtherCollectionDocument(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                                             Integer page, Integer size) throws Exception {

        List<Long> documentIds = new ArrayList<>();
        List<Document> documents = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        userLog.info("user : " + id + " get favorite list");

        try {
            User user = userService.getObjectById(id);

            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            userLog.info("=====获取收藏课程列表id=====");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (id, UserFavoriteRelation.TARGET_TYPE_DOCUMENT, UserFavoriteRelation.TYPE_COLLECTION,
                            UserFavoriteRelation.STATUS_ACTIVE, firstNmuber, size);
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    documentIds.add(userFavoriteRelation.getTargetId());
                }
            }
            userLog.info("collection documentIds : " + documentIds);

            if (CollectionUtils.isNotEmpty(documentIds)) {
                documents = documentService.getObjectsByIds(documentIds);
            } else {
                userLog.info("no collection document");
            }

            totalIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (id, UserFavoriteRelation.TARGET_TYPE_DOCUMENT, UserFavoriteRelation.TYPE_COLLECTION,
                            UserFavoriteRelation.STATUS_ACTIVE, 0, Integer.MAX_VALUE);

            userLog.info("   total = " + totalIds.size());
            Integer totalPage = (((totalIds.size() - 1)) / size) + 1;
            userLog.info("   totalPage = " + totalPage);

            if(totalPage > page){
                next = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("documentList", documents);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get collection document error ");
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/document/json/documentListJson";
    }


    //12、用户收藏视频列表
    @RequestMapping(value = "/a/u/video/collection/list/{id}", method = RequestMethod.GET)
    public String getOtherCollectionVideo(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                                          Integer page, Integer size) throws Exception {

        List<Long> videoIds = new ArrayList<>();
        List<Video> videos = new ArrayList<>();
        List<Long> totalIds = new ArrayList<>();

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        userLog.info("user : " + id + " get favorite list");

        try {

            User user = userService.getObjectById(id);
            userLog.info(" user is " + user);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/common/success";
            }

            userLog.info("=====获取收藏课程列表id=====");
            List<Long> relationIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (id, UserFavoriteRelation.TARGET_TYPE_VIDEO, UserFavoriteRelation.TYPE_COLLECTION,
                            UserFavoriteRelation.STATUS_ACTIVE, firstNmuber, size);
            if (CollectionUtils.isNotEmpty(relationIds)) {
                List<UserFavoriteRelation> userFavoriteRelations = userFavoriteRelationService.getObjectsByIds(relationIds);
                for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelations) {
                    videoIds.add(userFavoriteRelation.getTargetId());
                }
            }
            userLog.info("collection videoIds : " + videoIds);

            if (CollectionUtils.isNotEmpty(videoIds)) {
                videos = videoService.getObjectsByIds(videoIds);
            } else {
                userLog.info("no collection video");
            }

            totalIds = userFavoriteRelationService.getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus
                    (id, UserFavoriteRelation.TARGET_TYPE_VIDEO, UserFavoriteRelation.TYPE_COLLECTION,
                            UserFavoriteRelation.STATUS_ACTIVE, 0, Integer.MAX_VALUE);

            userLog.info("   total = " + totalIds.size());
            Integer totalPage = (((totalIds.size() - 1)) / size) + 1;
            userLog.info("   totalPage = " + totalPage);

            if(totalPage > page){
                next = true;
            }


            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("videoList", videos);

        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error("get collection video error ");
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/video/json/videoListJson";
    }




    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module)
            throws Exception {
        userLog.info("hello upload " + module);
        if (StringUtils.isBlank(module)) {
            module = "common";
        }
        int code = 0;
        userLog.info(file.getOriginalFilename());

        //Long uid = cookieUtil.getID(request, response);
        try {
            String type = file.getContentType();
            long size = file.getSize();
            userLog.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file
                    .getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + extend;
            userLog.info("new name is " + fileName);
            //  /data/temp/
            String filePath = "/data/temp/" + fileName;

            File tempPic = new File(filePath);
            file.transferTo(tempPic);
            String url = this.imgStorageUtil.imgStorage(module, module + "/"
                    + fileName, filePath);
            userLog.info(module + " upload success ,and file name is " + fileName
                    + "temp path is " + filePath + " access url is " + url);
            tempPic.delete();
            userLog.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            return "/common/success";
        }

    }


    @RequestMapping(value = "/a/wrong/{token}", method = RequestMethod.GET)
    public String wrong(HttpServletRequest request,
                        HttpServletResponse response, ModelMap model, @PathVariable String token) throws Exception {

        userLog.info(" wrong user " + token);

        model.addAttribute("code", -2);
        model.addAttribute("token", token);

        return "/common/wrongUser";

    }

    /**
     * 强制更新版本重定向到此请求
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/force/update/version", method = RequestMethod.GET)
    public String forceUpdate(HttpServletRequest request, HttpServletResponse response,
                              ModelMap model) {
        userLog.info("method forceUpdate begin...");

        try {
            Long constantIdByCode = constantService.getConstantIdByKeyAndType("code", "version");
            Long constantIdByUrl = constantService.getConstantIdByKeyAndType("url", "version");
            Long constantIdByIosName = constantService.getConstantIdByKeyAndType("iosName", "version");
            Long constantIdByAndroidName = constantService.getConstantIdByKeyAndType("androidName", "version");
            Long constantIdByInfo = constantService.getConstantIdByKeyAndType("info", "version");

            if (null != constantIdByCode && null != constantIdByUrl) {
                Constant constantByCode = constantService.getObjectById(constantIdByCode);
                Constant constantByUrl = constantService.getObjectById(constantIdByUrl);
                Constant constantByIosName = constantService.getObjectById(constantIdByIosName);
                Constant constantByAndroidName = constantService.getObjectById(constantIdByAndroidName);
                Constant constantByInfo = constantService.getObjectById(constantIdByInfo);

                String iosName = constantByIosName.getValue();
                String androidName = constantByAndroidName.getValue();
                String url = constantByUrl.getValue();
                String versionCode = constantByCode.getValue();
                String info = constantByInfo.getValue();

                model.addAttribute("url", url);
                model.addAttribute("iosName", iosName);
                model.addAttribute("androidName", androidName);
                model.addAttribute("info", info);
                model.addAttribute("versionCode", versionCode);

                userLog.info("get version : iosName =  " + iosName + " androidName " + androidName + " url = " + url + " code = " + versionCode + " info = " + info);
            } else {
                userLog.info("no version");
            }

            model.addAttribute("code", -9);

        } catch (Exception e) {
            e.printStackTrace();
            userLog.error(e.getMessage());
            model.addAttribute("code", -9);
            return "/common/success";
        }

        return "/common/versionUpdate";
    }

}