package com.ptteng.academy.home.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.common.model.Sms;
import com.ptteng.academy.common.service.SmsService;
import com.ptteng.academy.home.util.mailUtil;
import com.ptteng.academy.home.util.userNameUtil;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserOpenidRelation;
import com.ptteng.academy.user.service.UserOpenidRelationService;
import com.ptteng.academy.user.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Authentication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class RegisterController {
    private static final Log userLog = LogFactory.getLog("user");

    private static final Log registerLog = LogFactory.getLog("register");

    @Autowired
    private UserService userService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;


    // 1、验证码发送
    @RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
    public String sendVerify(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String type) throws ServiceException, ServiceDaoException {
        registerLog.info(mobile + " want send sms of type " + type);

        if (StringUtils.isBlank(mobile)) {
            registerLog.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", -2001);
            return "/common/success";
        }

        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        registerLog.info("=====================" + type);
        if ("register".equals(type) || "bind".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {
                registerLog.info(type + " is already exist  " + mobile);

                model.addAttribute("code", -2007);
                return "/common/success";
            } else {
                registerLog.info(mobile + " is not exist , so can " + type);
            }

        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {

                registerLog.info(type + " is not already exist  " + mobile);

                model.addAttribute("code", -2000);
                return "/common/success";
            } else {
                registerLog.info(mobile + " is already exist , so can change password ");
            }
        }

        int code = 0;

        try {
            String result = this.smsService.sendMsg(mobile, type);
//            smsService.getSmsIdByMobileAndType(mobile,type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = -2003;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = -2008;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = -2015;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error(mobile + " send message error of type " + type);
            model.addAttribute("code", -1);

        }
        return "/common/success";

    }


    // 2、邮箱验证码发送
    @RequestMapping(value = "/a/mail/code/send", method = RequestMethod.POST)
    public String sendMailVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mail,
                                 String type) throws ServiceException, ServiceDaoException {
        registerLog.info(mail + " want send mail sms of type " + type);

        try {

            if (StringUtils.isBlank(mail)) {
                registerLog.info(mail + " want send sms of type " + type + " null mail ");
                model.addAttribute("code", -2022);
                return "/common/success";
            }else {
                //邮箱格式校验
                registerLog.info("mail address verify ");
                Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
                Matcher m = p.matcher(mail);
                boolean result = m.matches();
                registerLog.info("mail address verify result : " + result);
                if (result) {
                    registerLog.info("mail address verify OK");
                } else {
                    registerLog.info("mail address verify fail");
                    model.addAttribute("code", -2023);
                    return "/common/success";
                }
            }

            if (StringUtils.isBlank(type)) {
                type = "password";
            }

            registerLog.info("=====================" + type);
            if ("register".equals(type) || "bind".equals(type)) {
                Long uid = this.userService.getUserIdByMail(mail);
                if (uid != null) {
                    registerLog.info(type + " is already exist  " + mail);
                    model.addAttribute("code", -2019);
                    return "/common/success";
                }
            } else {
                Long uid = this.userService.getUserIdByMail(mail);
                if (uid == null) {
                    registerLog.info(type + " is not already exist  " + mail);
                    model.addAttribute("code", -2000);
                    return "/common/success";
                }
            }

            int code = 0;

            String result = "";
            sendMailMsg(mail, type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = -2003;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = -2008;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = -2015;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error(mail + " send message error of type " + type);
            model.addAttribute("code", -1);

        }
        return "/common/success";

    }


    //3、注册账号
    @RequestMapping(value = "/a/register", method = RequestMethod.POST)
    public String addUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String openid,
                              String type, String pwd, String img, String verify) throws Exception {

        registerLog.info(" user register : openid = " + openid + " type = " + type + " pwd = " + pwd);
        String verify_type = "register";
        try {
            registerLog.info("==========1、校验参数是否为空==========");
            if (StringUtil.isEmpty(openid)) {
                registerLog.info("openid is null");
                model.addAttribute("code", -2012);
                return "/common/success";
            } else if ((UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) &&
                    (StringUtil.isEmpty(pwd) || StringUtil.isEmpty(verify))) {
                registerLog.info("pwd is null");
                model.addAttribute("code", -2020);
                return "/common/success";
            } else {
                registerLog.info("params verify OK");
            }

            //一期限制只能注册微信账号
            if (UserOpenidRelation.TYPE_WEIXIN.equals(type)) {
                registerLog.info("type is weixin");
            } else {
                registerLog.info("type is not weixin");
                model.addAttribute("code", -1007);
                return "/common/success";
            }

            registerLog.info("==========2、校验account类型==========");
            String accountType = "";
            if (UserOpenidRelation.TYPE_MAIL.equals(type)) {
                registerLog.info("mail address verify ");
                Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
                Matcher m = p.matcher(openid);
                boolean result = m.matches();
                registerLog.info("mail address verify result : " + result);
                if (result) {
                    registerLog.info("mail address verify OK");
                } else {
                    registerLog.info("mail address verify fail");
                    model.addAttribute("code", -2023);
                    return "/common/success";
                }
            } else {
                registerLog.info("not mail address register , no verify ");
            }


            registerLog.info("==========3、校验用户是否注册==========");
            Long oldUserOpenId = null;

            oldUserOpenId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);
            if (oldUserOpenId != null) {
                registerLog.info(openid + " is already exist  " + oldUserOpenId);
                model.addAttribute("code", -2007);
                return "/common/success";
            } else {
                registerLog.info(openid + " not exist ,so can register ");
            }


            boolean verifyResult = false;
            registerLog.info("==========4、校验验证码==========");
            if (UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) {

                verifyResult = verifyCode(openid, verify_type, verify);

                if (verifyResult) {
                    registerLog.info("right verify code");
                } else {
                    registerLog.error("wrong verify code");
                    model.addAttribute("code", -2005);
                    return "/common/success";
                }

            } else {
                registerLog.info("not mail or mobile register , no verify ");
            }


            registerLog.info("==========5、注册用户==========");
            Long now = System.currentTimeMillis();
            User user = new User();
            user.setLastLoginAt(now);
            user.setRegisterAt(now);
            user.setStatus(User.STATUS_NORMAL);
            userNameUtil userNameUtill = new userNameUtil();
            user.setAlias(userNameUtill.getRandomName());

            //is_read公告状态 is_member 会员状态
            user.setPoststatus(User.POST_READ);
            user.setIsMember(User.IS_NOT_MEMBER);
            user.setIsRead(User.NOTICE_UNREAD);

            if (DataUtils.isNotNullOrEmpty(img)) {
                user.setImg(img);
            }

            if (UserOpenidRelation.TYPE_MOBILE.equals(type)) {
                user.setMobile(openid);
                user.setPwd(pwd);
            }else if(UserOpenidRelation.TYPE_MAIL.equals(type)){
                user.setMail(openid);
                user.setPwd(pwd);
            }else {
                registerLog.info("not mobile or mail register , don't need set user filed");
            }
            registerLog.info("insert user : " + user);
            Long uid = userService.insert(user);
            registerLog.info("insert user : " + uid + " success");


            registerLog.info("==========6、保存手机邮箱openid==========");

            UserOpenidRelation userMobileRelation = new UserOpenidRelation();
            userMobileRelation.setUid(uid);
            userMobileRelation.setOpenid(openid);
            userMobileRelation.setType(type);
            Long userMobileId = userOpenidRelationService.insert(userMobileRelation);
            registerLog.info(" userMobileId = " + userMobileId);


            String token = "";
            Map<String, String> maps = new HashMap();
            maps.put(CookieUtil.USER_ID, uid + "");
            cookieUtil.setIdentity(request, response, maps, uid);


            model.addAttribute("code", 0);
            model.addAttribute("token", token);
            model.addAttribute("uid", uid);

        } catch (Throwable t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error("add user error ");
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/user/json/userRegister";
    }


    //4、查询是否注册
    @RequestMapping(value = "/a/verify/openid", method = RequestMethod.GET)
    public String verifyMobile(HttpServletRequest request, HttpServletResponse response, ModelMap model, String openid, String type) {
        registerLog.info(" verify mobile if register ==========");

        Boolean result = false;
        try {
            if (StringUtils.isEmpty(openid)) {
                registerLog.info(" openId is null");
                model.addAttribute("code", -3002);
                return "/common/success";
            }

            Long relationId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);
            if (null != relationId) {
                result = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("register", result);

        } catch (Throwable t) {
            registerLog.error("verify openid : " + openid + " error  ");
            t.printStackTrace();

        }
        return "/common/boolResult";
    }


    //5、用户登陆
    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
    public String aLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd, String openid,
                         String type) throws Exception {

        registerLog.info("pwd is " + pwd + " openid= " + openid + " type =  " + type);

        registerLog.info("==========1、校验参数是否为空==========");
        if (StringUtil.isEmpty(openid)) {
            model.addAttribute("code", -2012);
            return "/common/success";
        } else if ((UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) && StringUtil.isEmpty(pwd)) {
            registerLog.info("pwd is null");
            model.addAttribute("code", -2020);
            return "/common/success";
        } else {
            registerLog.info("params verify OK");
        }

        registerLog.info("==========2、校验用户是否注册==========");
        Long uid = null;
        Long relationId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);

        if (relationId == null) {
            registerLog.info("user : " + uid + " not exist ");
            model.addAttribute("code", -2000);
            return "/common/success";
        } else {
            UserOpenidRelation relation = userOpenidRelationService.getObjectById(relationId);
            uid = relation.getUid();
            registerLog.info("user : " + uid + " exist");
        }

        User user = this.userService.getObjectById(uid);
        if (User.STATUS_OFF.equals(user.getStatus())) {
            registerLog.info(" status off ");
            model.addAttribute("code", -2009);
            return "/common/success";
        } else {
            registerLog.info(" status on ");
        }

        Boolean verify = false;
        if (UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) {
            String pass = PasswordUtils.encode(pwd);
            verify = pass.equals(user.getPwd());
            registerLog.info(" password verify success ");
        }else {
            verify = true;
            registerLog.info("openid login , don't need password verify");
        }

        if (verify) {
            registerLog.info(uid + " login ");
            Map<String, String> maps = new HashMap();
            maps.put(CookieUtil.USER_ID, uid + "");
            cookieUtil.setIdentity(request, response, maps, uid);
            String token = IdentityUtil.encodeCookie("phone", uid);
            user.setLastLoginAt(System.currentTimeMillis());
            userService.update(user);

            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("token", token);


        } else {
            registerLog.info(openid + " wrong pwd " + pwd);
            model.put("code", -2006);
            return "/common/success";
        }

        return "/academy-user-service/user/json/userLogin";
    }


    //6、绑定手机/邮箱/三方账号
    @RequestMapping(value = "/a/u/bind", method = RequestMethod.PUT)
    public String bind(HttpServletRequest request, HttpServletResponse response, ModelMap model, String openid, String type, String verify) throws Exception {

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        registerLog.info("get uid " + uid);

        String verify_type = "bind";

        registerLog.info("user " + uid + " bound openid " + openid + " type " + type);

        Boolean result = false;
        try {
            registerLog.info("==========1、校验参数是否为空==========");
            if (StringUtil.isEmpty(openid)) {
                model.addAttribute("code", -2012);
                return "/common/success";
            } else if ((UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) && StringUtil.isEmpty(verify)) {
                registerLog.info("verify is null");
                model.addAttribute("code", -2021);
                return "/common/success";
            } else {
                registerLog.info("params verify OK");
            }

            boolean verifyResult = false;
            registerLog.info("==========2、校验验证码==========");
            if (UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) {

                verifyResult = verifyCode(openid, verify_type, verify);

                if (verifyResult) {
                    registerLog.info("right verify code");
                } else {
                    registerLog.error("wrong verify code");
                    model.addAttribute("code", -2005);
                    return "/common/success";
                }

            } else {
                registerLog.info("not mail or mobile register , no verify ");
            }

            //openid是否绑定过
            Long relationId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);
            if (null != relationId) {
                registerLog.info("openid " + openid + " relation : " + relationId + " exist");
                if(UserOpenidRelation.TYPE_MAIL.equals(type)){
                    model.addAttribute("code", -2026);
                }else if(UserOpenidRelation.TYPE_MOBILE.equals(type)){
                    model.addAttribute("code", -2025);
                }else {
                    model.addAttribute("code", -2007);
                }
                return "/common/success";
            } else {
                registerLog.info("openid " + openid + " type " + type + " not exist and can bind ");
            }

            //用户是否存在该类型openid
            Long userRelationId = userOpenidRelationService.getUserOpenidRelationIdByUidAndType(uid, type);
            if (null != userRelationId) {
                registerLog.info(" user type : " + type + " relation id : " + userRelationId + " exist");
                if(UserOpenidRelation.TYPE_MAIL.equals(type)){
                    model.addAttribute("code", -2028);
                }else if(UserOpenidRelation.TYPE_MOBILE.equals(type)){
                    model.addAttribute("code", -2027);
                }else {
                    model.addAttribute("code", -2024);
                }

                return "/common/success";
            } else {
                registerLog.info("user " + uid + " type " + type + " openid not exist and can bind ");
            }

            registerLog.info("==========3、更新用户手机邮箱信息==========");
            if (UserOpenidRelation.TYPE_MOBILE.equals(type)) {
                user.setMobile(openid);
                registerLog.info("update user mobile");
            }else if(UserOpenidRelation.TYPE_MAIL.equals(type)){
                user.setMail(openid);
                registerLog.info("update user mail");
            } else {
                registerLog.info("not mail or mobile register , no user info update ");
            }

            UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
            userOpenidRelation.setUid(uid);
            userOpenidRelation.setOpenid(openid);
            userOpenidRelation.setType(type);
            Long userOpenId = userOpenidRelationService.insert(userOpenidRelation);
            registerLog.info("insert userOpenRelation : " + userOpenId + " success");

            registerLog.info("==========4、添加逆袭豆==========");
            if (UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) {

                Long score = user.getScore();
                user.setScore(score+20);
                registerLog.info("user score : " + score + " >>>>>>>>>> " + user.getScore());

            } else {
                registerLog.info("not mail or mobile register , no score add ");
            }
            registerLog.info("update user : " + user);
            userService.update(user);


            model.addAttribute("code", 0);
            model.addAttribute("register", result);

        } catch (Exception t) {
            registerLog.error("user bind error  ");
            t.printStackTrace();

        }
        return "/common/boolResult";
    }


    public String sendMailMsg(String mail, String type) throws ServiceException, ServiceDaoException {

        String code = "";
        String template = "";
        int count = 0;
        Sms sms = new Sms();

        if (type.equals("register")) {
            template = "academyRegisterMail";
        } else if (type.equals("password")) {
            template = "academyPwdMail";
        }else if(type.equals("bind")){
            template = "academyBindMail";
        }
        registerLog.info("template is :" + template);

        Long smsId = smsService.getSmsIdByMobileAndType(mail, type);
        registerLog.info(" smsId = " + smsId);
        String returnString = "";
        // 已经请求过验证码
        if (smsId != null) {
            registerLog.info(" didn't send sms ever ");
            // 检验每天发送次数
            sms = smsService.getObjectById(smsId);
            Format formatter = new SimpleDateFormat("d");
            String ftime = formatter.format(System.currentTimeMillis());
            String stime = formatter.format(sms.getSendAt());
            if (!ftime.equals(stime)) {
                sms.setCount(0);
            }
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;
            if (sms.getCount() < 5) {
                registerLog.info(" < 5   ");

                // 同类型30分钟内验证码相同
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();
                if (delay <= 1800000) {

                    registerLog.info("30分钟内发送相同验证码");
                    code = sms.getMessage();

                    try {
                        returnString = mailUtil.sendSMSMail(mail, code, template);
                    } catch (Exception e) {
                        registerLog.error(e.getMessage());
                    }

                    registerLog.info("邮件发送返回值：" + returnString);

                    if (returnString.equals("-1")) {
                        return SmsService.ErrorCode_sendError;
                    } else if (returnString.equals("0")) {
                        // TODO 处理返回值,参见HTTP协议文档
                        sms.setSendAt(System.currentTimeMillis());
                        count = sms.getCount();
                        count += 1;
                        sms.setCount(count);
                        registerLog.info("信息发送成功");
                    }

                } else {
                    registerLog.info("30分钟外发送相同验证码");
                    // 生成验证码
                    Random rand = new Random();
                    for (int i = 0; i < 6; i++) {
                        code = code + rand.nextInt(10);
                    }
                    code = code.trim();

                    try {
                        returnString = mailUtil.sendSMSMail(mail, code, template);
                    } catch (Exception e) {
                        registerLog.error(e.getMessage());
                    }

                    registerLog.info("短信发送返回值：" + returnString);

                    if (returnString.equals("-1")) {
                        return SmsService.ErrorCode_sendError;
                    } else if (returnString.equals("0")) {
                        // TODO 处理返回值,参见HTTP协议文档;
                        sms.setSendAt(System.currentTimeMillis());
                        sms.setTypeSendAt(System.currentTimeMillis());
                        count = sms.getCount();
                        count += 1;
                        sms.setCount(count);
                        sms.setMessage(code);
                        registerLog.info("超过30分钟发送新验证码");
                    }

                }
                smsService.update(sms);
            } else {
                registerLog.info("count > 5 ");

                return smsService.ErrorCode_SMS_smsMoreThan5;
            }

            // 第一次发送请求
        } else {

            registerLog.info(" first send code   ");
            // 生成验证码

            Random rand = new Random();
            for (int i = 0; i < 6; i++) {
                code = code + rand.nextInt(10);
            }
            code = code.trim();
            sms.setCount(0);
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;

            // 发送邮件
            try {

                returnString = mailUtil.sendSMSMail(mail, code, template);

                registerLog.info("短信发送返回值：" + returnString);
                if (returnString.equals("-1")) {
                    return SmsService.ErrorCode_sendError;
                } else if (returnString.equals("0")) {
                    // TODO 处理返回值,参见HTTP协议文档
                    count += 1;
                    // 保存sms对象信息
                    sms.setMobile(mail);
                    sms.setType(type);
                    sms.setMessage(code);
                    sms.setSendAt(System.currentTimeMillis());
                    sms.setTypeSendAt(System.currentTimeMillis());
                    sms.setCount(count);
                    Long ms = smsService.insert(sms);
                    registerLog.info("发送成功！ 信息保存结果：" + ms);
                }

            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }

        return "";
    }


    private boolean verifyModel() {
//        return "test".equals(this.accountConfig.get("testModel"));
        return true;
    }

    // 验证码校验
    private boolean verifyCode(String openid, String type, String verify) throws Exception {

        Boolean verifyResult = false;

        if (verifyModel()) {
            registerLog.info("is test model ");
            if ("555555".equals(verify)) {
                registerLog.info("test ,so not verify account ");
                verifyResult = true;
            } else {
                registerLog.info("log1: account is " + openid + ",type = " + type + ",verify" + verify);
                verifyResult = verifyMobileCode(openid, type, verify);
            }
        } else {
            registerLog.info("log1: account is " + openid + ",type = " + type + ",verify" + verify);
            verifyResult = verifyMobileCode(openid, type, verify);
        }
        return verifyResult;
    }

    private boolean verifyMobileCode(String mobile, String type, String verify)
            throws ServiceException, ServiceDaoException {

        registerLog.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        registerLog.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        registerLog.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        registerLog.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            registerLog.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }
}

