package com.ptteng.academy.home.controller;

import com.ptteng.academy.home.util.DynamicUtil;
import com.ptteng.academy.user.model.Notice;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.NoticeService;
import com.ptteng.academy.user.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Notice  crud
 * create_by shixing
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class NoticeController {
	private static final Log log = LogFactory.getLog(NoticeController.class);

	@Autowired
	private NoticeService noticeService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private UserService userService;



	/**
	 * create_by shixing
	 * 公告栏详情
	 * @param
	 * @return
	 */

	@RequestMapping(value = "/a/u/notice/detail", method = RequestMethod.GET)
	public String getNotice(HttpServletRequest request,
			HttpServletResponse response, ModelMap model)
			throws Exception {
		log.info(" The url is : /a/u/notice/detail");

		try{
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					CookieUtil.USER_ID));
			log.info("userId is :" + uid);
			User user = userService.getObjectById(uid);
			log.info("user is :" + user);
			Notice notice = null;
			Map<String, Object> params = DynamicUtil.getNotice();
			List<Long> noticeIds = noticeService.getIdsByDynamicCondition(Notice.class,params,0,Integer.MAX_VALUE);
			if(noticeIds.size() == 0){
				log.info("no notice found");
				model.addAttribute("code",0);
			}else if(noticeIds.size() == 1){
				Long id = noticeIds.get(0);
				notice = noticeService.getObjectById(id);
				log.info("notice is :" + notice);
				user.setIsRead(Notice.NOTICE_DOWN);
				boolean result = userService.update(user);
				log.info("update user ,result is:" + result);
			}else{
				log.error("id is not right,too much");
				model.addAttribute("code",-1);
			}
			log.info("notice is :" + notice);
			if(DataUtils.isNullOrEmpty(notice)){
				model.addAttribute("code",-9000);
				log.info("notice is not exist");
			}
			model.addAttribute("code",0);
			model.addAttribute("notice",notice);
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get notice detail error ");
			model.addAttribute("code", -1);
		}

		return "/academy-user-service/notice/json/noticeDetailJson";
	}





}

