/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Hollow;
import com.ptteng.academy.document.service.HollowService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HollowServiceImpl
extends BaseDaoServiceImpl
implements HollowService {
    private static final Log log = LogFactory.getLog(HollowServiceImpl.class);

    public Long insert(Hollow hollow) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + hollow));
        if (hollow == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        hollow.setCreateAt(Long.valueOf(currentTimeMillis));
        hollow.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)hollow);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + hollow));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Hollow> insertList(List<Hollow> hollowList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (hollowList == null ? "null" : Integer.valueOf(hollowList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(hollowList)) {
            return new ArrayList<Hollow>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Hollow hollow : hollowList) {
            hollow.setCreateAt(Long.valueOf(currentTimeMillis));
            hollow.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(hollowList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + hollowList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Hollow.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Hollow hollow) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (hollow == null ? "null" : hollow.getId())));
        boolean result = false;
        if (hollow == null) {
            return true;
        }
        hollow.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)hollow);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + hollow));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + hollow));
        }
        return result;
    }

    public boolean updateList(List<Hollow> hollowList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (hollowList == null ? "null" : Integer.valueOf(hollowList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(hollowList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Hollow hollow : hollowList) {
            hollow.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(hollowList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + hollowList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + hollowList.size()));
        return result;
    }

    public Hollow getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Hollow hollow = null;
        if (id == null) {
            return hollow;
        }
        try {
            hollow = (Hollow)this.dao.get(Hollow.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return hollow;
    }

    public List<Hollow> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List hollow = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Hollow>();
        }
        try {
            hollow = this.dao.getList(Hollow.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (hollow == null ? "null" : Integer.valueOf(hollow.size()))));
        return hollow;
    }

    public Long getRandomHollowId() throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)" get hollow id random ");
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getRandomHollowId", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" get random hollow id wrong ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getPopularHollowIds() throws ServiceException, ServiceDaoException {
        log.info((Object)" get popular hollow ");
        List idList = null;
        try {
            idList = this.dao.getIdList("getPopularHollowIds", new Object[0], Integer.valueOf(0), Integer.valueOf(10), false);
        }
        catch (DaoException e) {
            log.error((Object)" get popular hollow ids wrong ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getHollowIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getHollowIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countHollowIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getHollowIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getHollowIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

