-- ----------------------------
-- Table structure for `video`
-- ----------------------------
-- DROP TABLE IF EXISTS `video`;
CREATE TABLE `video` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `grade` int NOT NULL   COMMENT '年级',  
    `subject` int NOT NULL   COMMENT '科目',  
    `teacher_name` varchar(20)    COMMENT '教师名称',  
    `teacher_img` varchar(200)    COMMENT '教师头像',  
    `title` text NOT NULL   COMMENT '视频标题',  
    `type` int NOT NULL   COMMENT '视频类型（banner/card）',  
    `cover_img` varchar(255)    COMMENT '视频封面图片',  
    `cut_img` varchar(255)    COMMENT '视频截图图片',  
    `order_by` int    COMMENT '排序字段',  
    `source` varchar(500)    COMMENT '来源',  
    `content` text    COMMENT '内容',  
    `summary` text    COMMENT '摘要',  
    `publish_at` bigint    COMMENT '发布时间',  
    `status` tinyint NOT NULL   COMMENT '发布状态',  
    `url` varchar(500)    COMMENT '外链地址',  
    `read_count` int NOT NULL   COMMENT '浏览数',  
    `publish_type` int    COMMENT '发布类型',  
    `love` bigint NOT NULL   COMMENT '点赞数',  
    `collection` bigint NOT NULL   COMMENT '收藏数',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





