/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Teacher;
import com.ptteng.academy.document.service.TeacherService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TeacherServiceImpl
extends BaseDaoServiceImpl
implements TeacherService {
    private static final Log log = LogFactory.getLog(TeacherServiceImpl.class);

    public Long insert(Teacher teacher) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + teacher));
        if (teacher == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        teacher.setCreateAt(Long.valueOf(currentTimeMillis));
        teacher.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)teacher);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + teacher));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Teacher> insertList(List<Teacher> teacherList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (teacherList == null ? "null" : Integer.valueOf(teacherList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(teacherList)) {
            return new ArrayList<Teacher>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Teacher teacher : teacherList) {
            teacher.setCreateAt(Long.valueOf(currentTimeMillis));
            teacher.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(teacherList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + teacherList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Teacher.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Teacher teacher) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (teacher == null ? "null" : teacher.getId())));
        boolean result = false;
        if (teacher == null) {
            return true;
        }
        teacher.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)teacher);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + teacher));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + teacher));
        }
        return result;
    }

    public boolean updateList(List<Teacher> teacherList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (teacherList == null ? "null" : Integer.valueOf(teacherList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(teacherList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Teacher teacher : teacherList) {
            teacher.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(teacherList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + teacherList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + teacherList.size()));
        return result;
    }

    public Teacher getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Teacher teacher = null;
        if (id == null) {
            return teacher;
        }
        try {
            teacher = (Teacher)this.dao.get(Teacher.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return teacher;
    }

    public List<Teacher> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List teacher = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Teacher>();
        }
        try {
            teacher = this.dao.getList(Teacher.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (teacher == null ? "null" : Integer.valueOf(teacher.size()))));
        return teacher;
    }

    public List<Long> getTeacherIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTeacherIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTeacherIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTeacherIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTeacherIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

