/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Reply;
import com.ptteng.academy.document.service.ReplyService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplyServiceImpl
extends BaseDaoServiceImpl
implements ReplyService {
    private static final Log log = LogFactory.getLog(ReplyServiceImpl.class);

    public Long insert(Reply reply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + reply));
        if (reply == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        reply.setCreateAt(Long.valueOf(currentTimeMillis));
        reply.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)reply);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + reply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Reply> insertList(List<Reply> replyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (replyList == null ? "null" : Integer.valueOf(replyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(replyList)) {
            return new ArrayList<Reply>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Reply reply : replyList) {
            reply.setCreateAt(Long.valueOf(currentTimeMillis));
            reply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(replyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + replyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Reply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Reply reply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (reply == null ? "null" : reply.getId())));
        boolean result = false;
        if (reply == null) {
            return true;
        }
        reply.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)reply);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + reply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + reply));
        }
        return result;
    }

    public boolean updateList(List<Reply> replyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (replyList == null ? "null" : Integer.valueOf(replyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(replyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Reply reply : replyList) {
            reply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(replyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + replyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + replyList.size()));
        return result;
    }

    public Reply getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Reply reply = null;
        if (id == null) {
            return reply;
        }
        try {
            reply = (Reply)this.dao.get(Reply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return reply;
    }

    public List<Reply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List reply = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Reply>();
        }
        try {
            reply = this.dao.getList(Reply.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (reply == null ? "null" : Integer.valueOf(reply.size()))));
        return reply;
    }

    public List<Long> getReplyIdsByPidOrderByFloor(Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by pid,start,limit  : " + pid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getReplyIdsByPidOrderByFloor", new Object[]{pid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by pid,start,limit)  : " + pid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getReplyIdsByPidOrderByFloorDesc(Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by pid,start,limit  : " + pid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getReplyIdsByPidOrderByFloorDesc", new Object[]{pid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by pid,start,limit)  : " + pid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countReplyIdsByPidOrderByFloor(Long pid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by pid  : " + pid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getReplyIdsByPidOrderByFloor", new Object[]{pid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by pid)  : " + pid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getReplyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getReplyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countReplyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getReplyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getReplyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

