package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.service.VideoGradeRelationService;
import com.ptteng.academy.document.model.VideoGradeRelation;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class VideoGradeRelationServiceImpl extends BaseDaoServiceImpl implements VideoGradeRelationService {

 

	private static final Log log = LogFactory.getLog(VideoGradeRelationServiceImpl.class);



		   
		@Override
		public Long insert(VideoGradeRelation videoGradeRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + videoGradeRelation);

		if (videoGradeRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		videoGradeRelation.setCreateAt(currentTimeMillis);
		videoGradeRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(videoGradeRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + videoGradeRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<VideoGradeRelation> insertList(List<VideoGradeRelation> videoGradeRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (videoGradeRelationList == null ? "null" : videoGradeRelationList.size()));
      
		List<VideoGradeRelation> resultList = null;

		if (CollectionUtils.isEmpty(videoGradeRelationList)) {
			return new ArrayList<VideoGradeRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (VideoGradeRelation videoGradeRelation : videoGradeRelationList) {
			videoGradeRelation.setCreateAt(currentTimeMillis);
			videoGradeRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<VideoGradeRelation>) dao.batchSave(videoGradeRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + videoGradeRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(VideoGradeRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(VideoGradeRelation videoGradeRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (videoGradeRelation == null ? "null" : videoGradeRelation.getId()));

		boolean result = false;

		if (videoGradeRelation == null) {
			return true;
		}

		videoGradeRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(videoGradeRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + videoGradeRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + videoGradeRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<VideoGradeRelation> videoGradeRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (videoGradeRelationList == null ? "null" : videoGradeRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(videoGradeRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (VideoGradeRelation videoGradeRelation : videoGradeRelationList) {
			videoGradeRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(videoGradeRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + videoGradeRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + videoGradeRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public VideoGradeRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		VideoGradeRelation videoGradeRelation = null;

		if (id == null) {
			return videoGradeRelation;
		}

		try {
			videoGradeRelation = (VideoGradeRelation) dao.get(VideoGradeRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return videoGradeRelation;		
		}	
		  
    	   
		@Override
		public List<VideoGradeRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<VideoGradeRelation> videoGradeRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<VideoGradeRelation>();
		}

		try {
			videoGradeRelation = (List<VideoGradeRelation>) dao.getList(VideoGradeRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (videoGradeRelation == null ? "null" : videoGradeRelation.size()));
    
		return videoGradeRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getVideoGradeRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getVideoGradeRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countVideoGradeRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getVideoGradeRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getVideoGradeRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

