package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Hollow;
import com.ptteng.academy.document.service.HollowService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class HollowServiceImpl extends BaseDaoServiceImpl implements HollowService {


    private static final Log log = LogFactory.getLog(HollowServiceImpl.class);


    @Override
    public Long insert(Hollow hollow) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + hollow);

        if (hollow == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        hollow.setCreateAt(currentTimeMillis);
        hollow.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(hollow);
        } catch (DaoException e) {
            log.error(" insert wrong : " + hollow);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Hollow> insertList(List<Hollow> hollowList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (hollowList == null ? "null" : hollowList.size()));

        List<Hollow> resultList = null;

        if (CollectionUtils.isEmpty(hollowList)) {
            return new ArrayList<Hollow>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Hollow hollow : hollowList) {
            hollow.setCreateAt(currentTimeMillis);
            hollow.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Hollow>) dao.batchSave(hollowList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + hollowList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Hollow.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Hollow hollow) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (hollow == null ? "null" : hollow.getId()));

        boolean result = false;

        if (hollow == null) {
            return true;
        }

        hollow.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(hollow);
        } catch (DaoException e) {
            log.error(" update wrong : " + hollow);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + hollow);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Hollow> hollowList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (hollowList == null ? "null" : hollowList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(hollowList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Hollow hollow : hollowList) {
            hollow.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(hollowList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + hollowList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + hollowList.size());

        return result;
    }


    @Override
    public Hollow getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Hollow hollow = null;

        if (id == null) {
            return hollow;
        }

        try {
            hollow = (Hollow) dao.get(Hollow.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return hollow;
    }


    @Override
    public List<Hollow> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Hollow> hollow = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Hollow>();
        }

        try {
            hollow = (List<Hollow>) dao.getList(Hollow.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (hollow == null ? "null" : hollow.size()));

        return hollow;
    }

    @Override
    public Long getRandomHollowId() throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get hollow id random ");
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getRandomHollowId", new Object[]{});
        } catch (DaoException e) {
            log.error(" get random hollow id wrong ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public List<Long> getPopularHollowIds() throws ServiceException, ServiceDaoException {
        log.info(" get popular hollow ");
        List<Long> idList = null;

        try {
            idList = dao.getIdList("getPopularHollowIds", new Object[]{}, 0, 10, false);
        } catch (DaoException e) {
            log.error(" get popular hollow ids wrong ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }



    @Override
    public List<Long> getHollowIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getHollowIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countHollowIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getHollowIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getHollowIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

