/**
 * 
 */
package com.ptteng.sca.academy.document.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.document.model.Document;
import com.ptteng.academy.document.service.DocumentService;

import java.util.List;
import java.util.Map;

public class DocumentSCAClient implements DocumentService {

    private DocumentService documentService;

	public DocumentService getDocumentService() {
		return documentService;
	}
	
	
	public void setDocumentService(DocumentService documentService) {
		this.documentService =documentService;
	}
	
	
			   
		@Override
		public Long insert(Document document)throws ServiceException, ServiceDaoException{
		
		return documentService.insert(document);
		          
		
		}	
		  
    	   
		@Override
		public List<Document> insertList(List<Document> documentList)throws ServiceException, ServiceDaoException{
		
		return documentService.insertList(documentList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return documentService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Document document)throws ServiceException, ServiceDaoException{
		
		return documentService.update(document);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Document> documentList)throws ServiceException, ServiceDaoException{
		
		return documentService.updateList(documentList);
		          
		
		}	
		  
    	   
		@Override
		public Document getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return documentService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Document> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return documentService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getDocumentIdsByStatusAndTypeOrderByUpdateAt(Integer status,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return documentService.getDocumentIdsByStatusAndTypeOrderByUpdateAt(status,type,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countDocumentIdsByStatusAndTypeOrderByUpdateAt(Integer status,Integer type)throws ServiceException, ServiceDaoException{
		
		return documentService.countDocumentIdsByStatusAndTypeOrderByUpdateAt(status,type);
	
	
	}
	
		
	
		@Override
	public List<Long> getDocumentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return documentService.getDocumentIds(start, limit);
	}

	@Override
	public Integer countDocumentIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return documentService.countDocumentIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return documentService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return documentService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   documentService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.documentService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

