/**
 *
 */
package com.ptteng.sca.academy.document.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.document.model.Hollow;
import com.ptteng.academy.document.service.HollowService;

import java.util.List;
import java.util.Map;

public class HollowSCAClient implements HollowService {

    private HollowService hollowService;

    public HollowService getHollowService() {
        return hollowService;
    }


    public void setHollowService(HollowService hollowService) {
        this.hollowService = hollowService;
    }


    @Override
    public Long insert(Hollow hollow) throws ServiceException, ServiceDaoException {

        return hollowService.insert(hollow);


    }


    @Override
    public List<Hollow> insertList(List<Hollow> hollowList) throws ServiceException, ServiceDaoException {

        return hollowService.insertList(hollowList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return hollowService.delete(id);


    }


    @Override
    public boolean update(Hollow hollow) throws ServiceException, ServiceDaoException {

        return hollowService.update(hollow);


    }


    @Override
    public boolean updateList(List<Hollow> hollowList) throws ServiceException, ServiceDaoException {

        return hollowService.updateList(hollowList);


    }


    @Override
    public Hollow getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return hollowService.getObjectById(id);


    }


    @Override
    public List<Hollow> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return hollowService.getObjectsByIds(ids);


    }

    @Override
    public Long getRandomHollowId() throws ServiceException, ServiceDaoException {
        return hollowService.getRandomHollowId();
    }

    @Override
    public List<Long> getPopularHollowIds() throws ServiceException, ServiceDaoException {
        return hollowService.getPopularHollowIds();
    }


    @Override
    public List<Long> getHollowIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return hollowService.getHollowIds(start, limit);
    }

    @Override
    public Integer countHollowIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return hollowService.countHollowIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return hollowService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return hollowService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        hollowService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.hollowService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


}

