package com.ptteng.academy.document.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.document.model.Hollow;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface HollowService extends BaseDaoService {


    public Long insert(Hollow hollow) throws ServiceException, ServiceDaoException;


    public List<Hollow> insertList(List<Hollow> hollowList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Hollow hollow) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Hollow> hollowList) throws ServiceException, ServiceDaoException;


    public Hollow getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Hollow> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @Description 获取随机树叶
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/2 15:49
     */
    public Long getRandomHollowId() throws ServiceException, ServiceDaoException;


    /**
     * @Description 获取最热树叶列表
     * @param
     * @Author: PeiyuFeng
     * @Time 2017/5/2 16:05
     */
    public List<Long> getPopularHollowIds() throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getHollowIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countHollowIds() throws ServiceException, ServiceDaoException;


}

