package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.UserDperiodRelation;
import com.ptteng.academy.course.service.UserDperiodRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserDperiodRelationServiceImpl extends BaseDaoServiceImpl implements UserDperiodRelationService {


    private static final Log log = LogFactory.getLog(UserDperiodRelationServiceImpl.class);


    @Override
    public Long insert(UserDperiodRelation userDperiodRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userDperiodRelation);

        if (userDperiodRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userDperiodRelation.setCreateAt(currentTimeMillis);
        userDperiodRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userDperiodRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userDperiodRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserDperiodRelation> insertList(List<UserDperiodRelation> userDperiodRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userDperiodRelationList == null ? "null" : userDperiodRelationList.size()));

        List<UserDperiodRelation> resultList = null;

        if (CollectionUtils.isEmpty(userDperiodRelationList)) {
            return new ArrayList<UserDperiodRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserDperiodRelation userDperiodRelation : userDperiodRelationList) {
            userDperiodRelation.setCreateAt(currentTimeMillis);
            userDperiodRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserDperiodRelation>) dao.batchSave(userDperiodRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userDperiodRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserDperiodRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserDperiodRelation userDperiodRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userDperiodRelation == null ? "null" : userDperiodRelation.getId()));

        boolean result = false;

        if (userDperiodRelation == null) {
            return true;
        }

        userDperiodRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userDperiodRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + userDperiodRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userDperiodRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserDperiodRelation> userDperiodRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userDperiodRelationList == null ? "null" : userDperiodRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userDperiodRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserDperiodRelation userDperiodRelation : userDperiodRelationList) {
            userDperiodRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userDperiodRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userDperiodRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userDperiodRelationList.size());

        return result;
    }


    @Override
    public UserDperiodRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserDperiodRelation userDperiodRelation = null;

        if (id == null) {
            return userDperiodRelation;
        }

        try {
            userDperiodRelation = (UserDperiodRelation) dao.get(UserDperiodRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userDperiodRelation;
    }


    @Override
    public List<UserDperiodRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserDperiodRelation> userDperiodRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserDperiodRelation>();
        }

        try {
            userDperiodRelation = (List<UserDperiodRelation>) dao.getList(UserDperiodRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userDperiodRelation == null ? "null" : userDperiodRelation.size()));

        return userDperiodRelation;
    }

    @Override
    public Long getIdsByUserIdAndPeriodId(Long userId, Long periodId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by userId,periodId : " + userId + " , " + periodId);
        }
        Long id = null;

        try {
            id = (Long) dao.getMapping("getIdsByUserIdAndPeriodId", new Object[]{userId, periodId});


        } catch (DaoException e) {
            log.error(" get ids  wrong by userId,periodId : " + userId + " , " + periodId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + id);
        }
        return id;
    }


    @Override
    public List<Long> getUserDperiodRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserDperiodRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserDperiodRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserDperiodRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserDperiodRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

