package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Locks;
import com.ptteng.academy.course.service.LocksService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class LocksServiceImpl extends BaseDaoServiceImpl implements LocksService {


    private static final Log log = LogFactory.getLog(LocksServiceImpl.class);


    @Override
    public Long insert(Locks locks) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + locks);

        if (locks == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        locks.setCreateAt(currentTimeMillis);
        locks.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(locks);
        } catch (DaoException e) {
            log.error(" insert wrong : " + locks);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Locks> insertList(List<Locks> locksList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (locksList == null ? "null" : locksList.size()));

        List<Locks> resultList = null;

        if (CollectionUtils.isEmpty(locksList)) {
            return new ArrayList<Locks>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Locks locks : locksList) {
            locks.setCreateAt(currentTimeMillis);
            locks.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Locks>) dao.batchSave(locksList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + locksList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Locks.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Locks locks) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (locks == null ? "null" : locks.getId()));

        boolean result = false;

        if (locks == null) {
            return true;
        }

        locks.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(locks);
        } catch (DaoException e) {
            log.error(" update wrong : " + locks);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + locks);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Locks> locksList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (locksList == null ? "null" : locksList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(locksList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Locks locks : locksList) {
            locks.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(locksList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + locksList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + locksList.size());

        return result;
    }


    @Override
    public Locks getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Locks locks = null;

        if (id == null) {
            return locks;
        }

        try {
            locks = (Locks) dao.get(Locks.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return locks;
    }


    @Override
    public List<Locks> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Locks> locks = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Locks>();
        }

        try {
            locks = (List<Locks>) dao.getList(Locks.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (locks == null ? "null" : locks.size()));

        return locks;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getLocksIdsByUserIDAndType(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by userID,type,start,limit  : " + userID + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLocksIdsByUserIDAndType", new Object[]{userID, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by userID,type,start,limit)  : " + userID + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public Long getLocksIdByUserIDAndTypeAndTargetID(Long userID, Integer type, Long targetID) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by userID , type, targetID : " + userID + " , " + type + " , " + targetID);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getLocksIdByUserIDAndTypeAndTargetID", new Object[]{userID, type, targetID});
        } catch (DaoException e) {
            log.error(" get id wrong byuserID , type, targetID : " + userID + " , " + type + " , " + targetID);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countLocksIdsByUserIDAndType(Long userID, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by userID,type  : " + userID + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getLocksIdsByUserIDAndType", new Object[]{userID, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by userID,type)  : " + userID + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getLocksIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLocksIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countLocksIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getLocksIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getLocksIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

