package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class LessonServiceImpl extends BaseDaoServiceImpl implements LessonService {


    private static final Log log = LogFactory.getLog(LessonServiceImpl.class);


    @Override
    public Long insert(Lesson lesson) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + lesson);

        if (lesson == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        lesson.setCreateAt(currentTimeMillis);
        lesson.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(lesson);
        } catch (DaoException e) {
            log.error(" insert wrong : " + lesson);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Lesson> insertList(List<Lesson> lessonList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (lessonList == null ? "null" : lessonList.size()));

        List<Lesson> resultList = null;

        if (CollectionUtils.isEmpty(lessonList)) {
            return new ArrayList<Lesson>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Lesson lesson : lessonList) {
            lesson.setCreateAt(currentTimeMillis);
            lesson.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Lesson>) dao.batchSave(lessonList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + lessonList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Lesson.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Lesson lesson) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (lesson == null ? "null" : lesson.getId()));

        boolean result = false;

        if (lesson == null) {
            return true;
        }

        lesson.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(lesson);
        } catch (DaoException e) {
            log.error(" update wrong : " + lesson);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + lesson);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Lesson> lessonList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (lessonList == null ? "null" : lessonList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(lessonList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Lesson lesson : lessonList) {
            lesson.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(lessonList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + lessonList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + lessonList.size());

        return result;
    }


    @Override
    public Lesson getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Lesson lesson = null;

        if (id == null) {
            return lesson;
        }

        try {
            lesson = (Lesson) dao.get(Lesson.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return lesson;
    }


    @Override
    public List<Lesson> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Lesson> lesson = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Lesson>();
        }

        try {
            lesson = (List<Lesson>) dao.getList(Lesson.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (lesson == null ? "null" : lesson.size()));

        return lesson;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getLessonIdsByLevelOrderBySort(Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by level,start,limit  : " + level + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonIdsByLevelOrderBySort", new Object[]{level}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by level,start,limit)  : " + level + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getLessonIdsByLevelAndSubjectOrderBySort(Integer level, Long sujectID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by level,start,limit  : " + level + " , " + start + " , " + limit + "and subject id is" + sujectID);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            log.info(level + "level" + sujectID + "subjectId" + "==============================");
            idList = dao.getIdList("getLessonIdsByLevelAndSubjectOrderBySort", new Object[]{level, sujectID}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by level,start,limit)  : " + level + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;

    }

    @Override
    public List<Long> getLessonIdsBySubjectOrderBySort(Long sujectID, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by level,start,limit  : " + sujectID + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonIdsBySubjectOrderBySort", new Object[]{sujectID}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by subjectID,start,limit)  : " + sujectID + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getLessonIdsByRecommendOrderBySort(Integer recommend, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by recommend,start,limit  : " + recommend + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonIdsByRecommendOrderBySort", new Object[]{recommend}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by recommend,start,limit)  : " + recommend + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getLessonIdsBySubjectTypeAndSelected(Integer userType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by userType,start,limit  : " + userType + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonIdsBySubjectTypeAndSelected", new Object[]{userType}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by userType,start,limit)  : " + userType + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countLessonIdsByLevelOrderBySort(Integer level) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by level  : " + level);
        }
        Integer count = null;


        try {

            count = dao.count("getLessonIdsByLevelOrderBySort", new Object[]{level});


        } catch (DaoException e) {
            log.error(" count ids  wrong by level)  : " + level);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }

    @Override
    public Integer countLessonIdsByLevelAndSubjectOrderBySort(Integer level, Integer subjectId) throws ServiceException, ServiceDaoException {
        return null;
    }


//	//。。。
//	@Override
//	public Integer countLessonIdsByLevelOrderBySort(Integer level, Integer subjectId) throws ServiceException, ServiceDaoException {
//
//		if(log.isInfoEnabled()){
//			log.info(" count ids by level  : " + level );
//		}
//		Integer count=null;
//
//
//
//		try {
//
//			count = dao.count("getLessonIdsByLevelOrderBySort", new Object[] { level});
//
//
//		} catch (DaoException e) {
//			log.error(" count ids  wrong by level)  : " + level );
//			log.error(e);
//			e.printStackTrace();
//			throw new ServiceDaoException(e);
//		}
//		if(log.isInfoEnabled()){
//			log.info(" count  success : " + count);
//		}
//		return count;
//
//	}


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countLessonIdsByRecommendOrderBySort(Integer recommend) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by recommend  : " + recommend);
        }
        Integer count = null;


        try {

            count = dao.count("getLessonIdsByRecommendOrderBySort", new Object[]{recommend});


        } catch (DaoException e) {
            log.error(" count ids  wrong by recommend)  : " + recommend);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getLessonIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLessonIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countLessonIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getLessonIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getLessonIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

