package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.DictationWords;
import com.ptteng.academy.course.service.DictationWordsService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class DictationWordsServiceImpl extends BaseDaoServiceImpl implements DictationWordsService {


    private static final Log log = LogFactory.getLog(DictationWordsServiceImpl.class);


    @Override
    public Long insert(DictationWords dictationWords) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + dictationWords);

        if (dictationWords == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        dictationWords.setCreateAt(currentTimeMillis);
        dictationWords.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(dictationWords);
        } catch (DaoException e) {
            log.error(" insert wrong : " + dictationWords);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<DictationWords> insertList(List<DictationWords> dictationWordsList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (dictationWordsList == null ? "null" : dictationWordsList.size()));

        List<DictationWords> resultList = null;

        if (CollectionUtils.isEmpty(dictationWordsList)) {
            return new ArrayList<DictationWords>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationWords dictationWords : dictationWordsList) {
            dictationWords.setCreateAt(currentTimeMillis);
            dictationWords.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<DictationWords>) dao.batchSave(dictationWordsList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + dictationWordsList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(DictationWords.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(DictationWords dictationWords) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (dictationWords == null ? "null" : dictationWords.getId()));

        boolean result = false;

        if (dictationWords == null) {
            return true;
        }

        dictationWords.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(dictationWords);
        } catch (DaoException e) {
            log.error(" update wrong : " + dictationWords);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + dictationWords);
        }
        return result;
    }


    @Override
    public boolean updateList(List<DictationWords> dictationWordsList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (dictationWordsList == null ? "null" : dictationWordsList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(dictationWordsList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationWords dictationWords : dictationWordsList) {
            dictationWords.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(dictationWordsList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + dictationWordsList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + dictationWordsList.size());

        return result;
    }


    @Override
    public DictationWords getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        DictationWords dictationWords = null;

        if (id == null) {
            return dictationWords;
        }

        try {
            dictationWords = (DictationWords) dao.get(DictationWords.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return dictationWords;
    }


    @Override
    public List<DictationWords> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<DictationWords> dictationWords = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DictationWords>();
        }

        try {
            dictationWords = (List<DictationWords>) dao.getList(DictationWords.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (dictationWords == null ? "null" : dictationWords.size()));

        return dictationWords;
    }

    @Override
    public List<Long> getDictationWordsIdsByNid(Long nid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get ids by nid,start,limit " + nid + " , " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDictationWordsIdsByNid", new Object[]{nid}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by nid,start,limit : " + nid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public List<Long> getDictationWordsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDictationWordsIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDictationWordsIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDictationWordsIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDictationWordsIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

