package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.DictationSubject;
import com.ptteng.academy.course.service.DictationSubjectService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class DictationSubjectServiceImpl extends BaseDaoServiceImpl implements DictationSubjectService {


    private static final Log log = LogFactory.getLog(DictationSubjectServiceImpl.class);


    @Override
    public Long insert(DictationSubject dictationSubject) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + dictationSubject);

        if (dictationSubject == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        dictationSubject.setCreateAt(currentTimeMillis);
        dictationSubject.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(dictationSubject);
        } catch (DaoException e) {
            log.error(" insert wrong : " + dictationSubject);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<DictationSubject> insertList(List<DictationSubject> dictationSubjectList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (dictationSubjectList == null ? "null" : dictationSubjectList.size()));

        List<DictationSubject> resultList = null;

        if (CollectionUtils.isEmpty(dictationSubjectList)) {
            return new ArrayList<DictationSubject>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationSubject dictationSubject : dictationSubjectList) {
            dictationSubject.setCreateAt(currentTimeMillis);
            dictationSubject.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<DictationSubject>) dao.batchSave(dictationSubjectList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + dictationSubjectList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(DictationSubject.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(DictationSubject dictationSubject) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (dictationSubject == null ? "null" : dictationSubject.getId()));

        boolean result = false;

        if (dictationSubject == null) {
            return true;
        }

        dictationSubject.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(dictationSubject);
        } catch (DaoException e) {
            log.error(" update wrong : " + dictationSubject);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + dictationSubject);
        }
        return result;
    }


    @Override
    public boolean updateList(List<DictationSubject> dictationSubjectList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (dictationSubjectList == null ? "null" : dictationSubjectList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(dictationSubjectList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationSubject dictationSubject : dictationSubjectList) {
            dictationSubject.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(dictationSubjectList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + dictationSubjectList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + dictationSubjectList.size());

        return result;
    }


    @Override
    public DictationSubject getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        DictationSubject dictationSubject = null;

        if (id == null) {
            return dictationSubject;
        }

        try {
            dictationSubject = (DictationSubject) dao.get(DictationSubject.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return dictationSubject;
    }


    @Override
    public List<DictationSubject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<DictationSubject> dictationSubject = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DictationSubject>();
        }

        try {
            dictationSubject = (List<DictationSubject>) dao.getList(DictationSubject.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (dictationSubject == null ? "null" : dictationSubject.size()));

        return dictationSubject;
    }

    @Override
    public List<Long> getIdsOnline(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get online ids by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getIdsOnline", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Long getIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by name  : " + name);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getDictationSubjectIdByName", new Object[]{name});

        } catch (DaoException e) {
            log.error(" get id wrong by name  : " + name);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }


    @Override
    public List<Long> getDictationSubjectIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDictationSubjectIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDictationSubjectIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDictationSubjectIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDictationSubjectIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

