package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.DictationPeriod;
import com.ptteng.academy.course.service.DictationPeriodService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class DictationPeriodServiceImpl extends BaseDaoServiceImpl implements DictationPeriodService {


    private static final Log log = LogFactory.getLog(DictationPeriodServiceImpl.class);


    @Override
    public Long insert(DictationPeriod dictationPeriod) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + dictationPeriod);

        if (dictationPeriod == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        dictationPeriod.setCreateAt(currentTimeMillis);
        dictationPeriod.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(dictationPeriod);
        } catch (DaoException e) {
            log.error(" insert wrong : " + dictationPeriod);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<DictationPeriod> insertList(List<DictationPeriod> dictationPeriodList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (dictationPeriodList == null ? "null" : dictationPeriodList.size()));

        List<DictationPeriod> resultList = null;

        if (CollectionUtils.isEmpty(dictationPeriodList)) {
            return new ArrayList<DictationPeriod>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationPeriod dictationPeriod : dictationPeriodList) {
            dictationPeriod.setCreateAt(currentTimeMillis);
            dictationPeriod.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<DictationPeriod>) dao.batchSave(dictationPeriodList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + dictationPeriodList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(DictationPeriod.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(DictationPeriod dictationPeriod) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (dictationPeriod == null ? "null" : dictationPeriod.getId()));

        boolean result = false;

        if (dictationPeriod == null) {
            return true;
        }

        dictationPeriod.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(dictationPeriod);
        } catch (DaoException e) {
            log.error(" update wrong : " + dictationPeriod);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + dictationPeriod);
        }
        return result;
    }


    @Override
    public boolean updateList(List<DictationPeriod> dictationPeriodList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (dictationPeriodList == null ? "null" : dictationPeriodList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(dictationPeriodList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DictationPeriod dictationPeriod : dictationPeriodList) {
            dictationPeriod.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(dictationPeriodList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + dictationPeriodList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + dictationPeriodList.size());

        return result;
    }


    @Override
    public DictationPeriod getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        DictationPeriod dictationPeriod = null;

        if (id == null) {
            return dictationPeriod;
        }

        try {
            dictationPeriod = (DictationPeriod) dao.get(DictationPeriod.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return dictationPeriod;
    }


    @Override
    public List<DictationPeriod> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<DictationPeriod> dictationPeriod = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DictationPeriod>();
        }

        try {
            dictationPeriod = (List<DictationPeriod>) dao.getList(DictationPeriod.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (dictationPeriod == null ? "null" : dictationPeriod.size()));

        return dictationPeriod;
    }

    @Override
    public List<Long> getIdsByLidOrderBySort(Long lid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by lid : " + lid);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        try {
            idList = dao.getIdList("getIdsByLidOrderBySort", new Object[]{lid}, 0, Integer.MAX_VALUE, false);


        } catch (DaoException e) {
            log.error(" get ids wrong by lid : " + lid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public List<Long> getDictationPeriodIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDictationPeriodIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDictationPeriodIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDictationPeriodIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDictationPeriodIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

