package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Coupon;
import com.ptteng.academy.course.service.CouponService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CouponServiceImpl extends BaseDaoServiceImpl implements CouponService {


    private static final Log log = LogFactory.getLog(CouponServiceImpl.class);


    @Override
    public Long insert(Coupon coupon) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + coupon);

        if (coupon == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        coupon.setCreateAt(currentTimeMillis);
        coupon.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(coupon);
        } catch (DaoException e) {
            log.error(" insert wrong : " + coupon);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Coupon> insertList(List<Coupon> couponList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (couponList == null ? "null" : couponList.size()));

        List<Coupon> resultList = null;

        if (CollectionUtils.isEmpty(couponList)) {
            return new ArrayList<Coupon>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Coupon coupon : couponList) {
            coupon.setCreateAt(currentTimeMillis);
            coupon.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Coupon>) dao.batchSave(couponList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + couponList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Coupon.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Coupon coupon) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (coupon == null ? "null" : coupon.getId()));

        boolean result = false;

        if (coupon == null) {
            return true;
        }

        coupon.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(coupon);
        } catch (DaoException e) {
            log.error(" update wrong : " + coupon);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + coupon);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Coupon> couponList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (couponList == null ? "null" : couponList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(couponList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Coupon coupon : couponList) {
            coupon.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(couponList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + couponList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + couponList.size());

        return result;
    }


    @Override
    public Coupon getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Coupon coupon = null;

        if (id == null) {
            return coupon;
        }

        try {
            coupon = (Coupon) dao.get(Coupon.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return coupon;
    }


    @Override
    public List<Coupon> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Coupon> coupon = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Coupon>();
        }

        try {
            coupon = (List<Coupon>) dao.getList(Coupon.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (coupon == null ? "null" : coupon.size()));

        return coupon;
    }


    @Override
    public List<Long> getCouponIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getCouponIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countCouponIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getCouponIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getCouponIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

