/**
 * 
 */
package com.ptteng.sca.academy.business.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.business.model.Clerk;
import com.ptteng.academy.business.service.ClerkService;

import java.util.List;
import java.util.Map;

public class ClerkSCAClient implements ClerkService {

    private ClerkService clerkService;

	public ClerkService getClerkService() {
		return clerkService;
	}
	
	
	public void setClerkService(ClerkService clerkService) {
		this.clerkService =clerkService;
	}
	
	
			   
		@Override
		public Long insert(Clerk clerk)throws ServiceException, ServiceDaoException{
		
		return clerkService.insert(clerk);
		          
		
		}	
		  
    	   
		@Override
		public List<Clerk> insertList(List<Clerk> clerkList)throws ServiceException, ServiceDaoException{
		
		return clerkService.insertList(clerkList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return clerkService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Clerk clerk)throws ServiceException, ServiceDaoException{
		
		return clerkService.update(clerk);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Clerk> clerkList)throws ServiceException, ServiceDaoException{
		
		return clerkService.updateList(clerkList);
		          
		
		}	
		  
    	   
		@Override
		public Clerk getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return clerkService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Clerk> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return clerkService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getClerkIdsByAgentId(Long agentId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return clerkService.getClerkIdsByAgentId(agentId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getClerkIdsByRegionalManagerId(Long regionalManagerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return clerkService.getClerkIdsByRegionalManagerId(regionalManagerId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countClerkIdsByAgentId(Long agentId)throws ServiceException, ServiceDaoException{
		
		return clerkService.countClerkIdsByAgentId(agentId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countClerkIdsByRegionalManagerId(Long regionalManagerId)throws ServiceException, ServiceDaoException{
		
		return clerkService.countClerkIdsByRegionalManagerId(regionalManagerId);
	
	
	}
	
		
	
		@Override
	public List<Long> getClerkIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return clerkService.getClerkIds(start, limit);
	}

	@Override
	public Integer countClerkIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return clerkService.countClerkIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return clerkService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return clerkService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   clerkService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.clerkService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

