/**
 *
 */
package com.ptteng.sca.academy.business.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.business.model.Clazz;
import com.ptteng.academy.business.service.ClazzService;

import java.util.List;
import java.util.Map;

public class ClazzSCAClient implements ClazzService {

    private ClazzService clazzService;

    public ClazzService getClazzService() {
        return clazzService;
    }


    public void setClazzService(ClazzService clazzService) {
        this.clazzService = clazzService;
    }


    @Override
    public Long insert(Clazz clazz) throws ServiceException, ServiceDaoException {

        return clazzService.insert(clazz);


    }

    @Override
    public Long getClazzIdsBySchoolIdAndGradeAndClassNo(Long schoolId, Integer grade, Integer classNo) throws ServiceException, ServiceDaoException {
        return clazzService.getClazzIdsBySchoolIdAndGradeAndClassNo(schoolId, grade, classNo);
    }


    @Override
    public List<Clazz> insertList(List<Clazz> clazzList) throws ServiceException, ServiceDaoException {

        return clazzService.insertList(clazzList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return clazzService.delete(id);


    }


    @Override
    public boolean update(Clazz clazz) throws ServiceException, ServiceDaoException {

        return clazzService.update(clazz);


    }


    @Override
    public boolean updateList(List<Clazz> clazzList) throws ServiceException, ServiceDaoException {

        return clazzService.updateList(clazzList);


    }


    @Override
    public Clazz getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return clazzService.getObjectById(id);


    }


    @Override
    public List<Clazz> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return clazzService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getClazzIdsBySchoolId(Long schoolId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return clazzService.getClazzIdsBySchoolId(schoolId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countClazzIdsBySchoolId(Long schoolId) throws ServiceException, ServiceDaoException {

        return clazzService.countClazzIdsBySchoolId(schoolId);


    }


    @Override
    public List<Long> getClazzIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return clazzService.getClazzIds(start, limit);
    }

    @Override
    public Integer countClazzIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return clazzService.countClazzIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return clazzService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return clazzService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        clazzService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.clazzService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }


}

